/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.util.GotoLineNumberDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class PositionPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
StatusBarWidget.TextPresentation,
CaretListener,
SelectionListener {
    private String myText;

    public PositionPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/PositionPanel", "<init>"));
        }
        super(project);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/PositionPanel", "selectionChanged"));
        }
        this.updatePosition(this.getEditor());
    }

    @NotNull
    public String ID() {
        if ("Position" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/PositionPanel", "ID"));
        }
        return "Position";
    }

    public StatusBarWidget copy() {
        return new PositionPanel(this.getProject());
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/PositionPanel", "getPresentation"));
        }
        return this;
    }

    @NotNull
    public String getText() {
        String string = this.myText == null ? "" : this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/PositionPanel", "getText"));
        }
        return string;
    }

    @NotNull
    public String getMaxPossibleText() {
        if ("0000000000000" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/PositionPanel", "getMaxPossibleText"));
        }
        return "0000000000000";
    }

    public float getAlignment() {
        return 0.5f;
    }

    public String getTooltipText() {
        return UIBundle.message((String)"go.to.line.command.double.click", (Object[])new Object[0]);
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return new Consumer<MouseEvent>(){

            public void consume(MouseEvent mouseEvent) {
                final Project project = PositionPanel.this.getProject();
                if (project == null) {
                    return;
                }
                final Editor editor = PositionPanel.this.getEditor();
                if (editor == null) {
                    return;
                }
                CommandProcessor processor = CommandProcessor.getInstance();
                processor.executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        GotoLineNumberDialog dialog = new GotoLineNumberDialog(project, editor);
                        dialog.show();
                        IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
                    }
                }, UIBundle.message((String)"go.to.line.command.name", (Object[])new Object[0]), null);
            }
        };
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/PositionPanel", "install"));
        }
        super.install(statusBar);
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addCaretListener((CaretListener)this, (Disposable)this);
        multicaster.addSelectionListener((SelectionListener)this, (Disposable)this);
    }

    private static void appendLogicalPosition(LogicalPosition caret, StringBuilder message) {
        message.append(caret.line + 1);
        message.append(":");
        message.append(caret.column + 1);
    }

    public void selectionChanged(SelectionEvent e) {
        this.updatePosition(e.getEditor());
    }

    public void caretPositionChanged(CaretEvent e) {
        this.updatePosition(e.getEditor());
    }

    public void caretAdded(CaretEvent e) {
        this.updatePosition(e.getEditor());
    }

    public void caretRemoved(CaretEvent e) {
        this.updatePosition(e.getEditor());
    }

    private void updatePosition(Editor editor) {
        if (editor == null) {
            this.myText = "";
        } else {
            if (!this.isOurEditor(editor)) {
                return;
            }
            this.myText = this.getPositionText(editor);
        }
        this.myStatusBar.updateWidget(this.ID());
    }

    private String getPositionText(Editor editor) {
        if (!editor.isDisposed() && this.myStatusBar != null) {
            StringBuilder message = new StringBuilder();
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasBlockSelection()) {
                LogicalPosition start = selectionModel.getBlockStart();
                LogicalPosition end = selectionModel.getBlockEnd();
                if (start == null || end == null) {
                    throw new IllegalStateException(String.format("Invalid selection model state detected: 'blockSelection' property is 'true' but selection start position (%s) or selection end position (%s) is undefined", start, end));
                }
                PositionPanel.appendLogicalPosition(start, message);
                message.append("-");
                PositionPanel.appendLogicalPosition(new LogicalPosition(Math.abs(end.line - start.line), Math.max(0, Math.abs(end.column - start.column) - 1)), message);
            } else {
                int caretCount = editor.getCaretModel().getCaretCount();
                if (caretCount > 1) {
                    message.append(caretCount).append(" carets");
                } else {
                    int len;
                    LogicalPosition caret = editor.getCaretModel().getLogicalPosition();
                    PositionPanel.appendLogicalPosition(caret, message);
                    if (selectionModel.hasSelection() && (len = Math.abs(selectionModel.getSelectionStart() - selectionModel.getSelectionEnd())) != 0) {
                        message.append("/").append(len);
                    }
                }
            }
            return message.toString();
        }
        return "";
    }
}

