/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.BalloonHandler;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IconLikeCustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.openapi.wm.impl.status.MacStatusBarUI;
import com.intellij.openapi.wm.impl.status.StatusBarUI;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.openapi.wm.impl.status.ToolWindowsWidget;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.NotificationPopup;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeStatusBarImpl
extends JComponent
implements StatusBarEx {
    private static final int MIN_ICON_HEIGHT = 20;
    private final InfoAndProgressPanel myInfoAndProgressPanel;
    private IdeFrame myFrame;
    private static final String uiClassID = "IdeStatusBarUI";
    private final Map<String, WidgetBean> myWidgetMap = new HashMap();
    private final List<String> myOrderedWidgets = new ArrayList<String>();
    private JPanel myLeftPanel;
    private JPanel myRightPanel;
    private JPanel myCenterPanel;
    private String myInfo;
    private String myRequestor;
    private final List<String> myCustomComponentIds = new ArrayList<String>();
    private final Set<IdeStatusBarImpl> myChildren = new HashSet<IdeStatusBarImpl>();

    public StatusBar findChild(Component c) {
        IdeFrame frame = null;
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!(eachParent instanceof IdeFrame)) continue;
            frame = (IdeFrame)eachParent;
        }
        return frame != null ? frame.getStatusBar() : this;
    }

    public void install(IdeFrame frame) {
        this.myFrame = frame;
    }

    private void updateChildren(ChildAction action) {
        for (IdeStatusBarImpl child : this.myChildren) {
            action.update(child);
        }
    }

    public StatusBar createChild() {
        final IdeStatusBarImpl bar = new IdeStatusBarImpl(this);
        this.myChildren.add(bar);
        Disposer.register((Disposable)bar, (Disposable)new Disposable(){

            public void dispose() {
                IdeStatusBarImpl.this.myChildren.remove(bar);
            }
        });
        for (String eachId : this.myOrderedWidgets) {
            WidgetBean eachBean = this.myWidgetMap.get(eachId);
            if (!(eachBean.widget instanceof StatusBarWidget.Multiframe)) continue;
            StatusBarWidget copy = ((StatusBarWidget.Multiframe)eachBean.widget).copy();
            bar.addWidget(copy, eachBean.position);
        }
        return bar;
    }

    public JComponent getComponent() {
        return this;
    }

    IdeStatusBarImpl(@Nullable IdeStatusBarImpl master) {
        this.setLayout(new BorderLayout(2, 0));
        this.setBorder(BorderFactory.createEmptyBorder(1, 4, 0, SystemInfo.isMac ? 2 : 0));
        this.myInfoAndProgressPanel = new InfoAndProgressPanel();
        this.addWidget((StatusBarWidget)this.myInfoAndProgressPanel, Position.CENTER);
        this.setOpaque(true);
        this.updateUI();
        if (master == null) {
            Disposer.register((Disposable)Disposer.get((String)"ui"), (Disposable)this);
        }
        if (master == null) {
            this.addWidget((StatusBarWidget)new ToolWindowsWidget(this), Position.LEFT);
        }
        this.enableEvents(16L);
        this.enableEvents(32L);
    }

    public IdeStatusBarImpl() {
        this(null);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size == null) {
            return null;
        }
        Insets insets = this.getInsets();
        int minHeight = insets.top + insets.bottom + 20;
        return new Dimension(size.width, Math.max(size.height, minHeight));
    }

    public void addWidget(@NotNull StatusBarWidget widget) {
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addWidget"));
        }
        this.addWidget(widget, Position.RIGHT, "__AUTODETECT__");
    }

    public void addWidget(@NotNull StatusBarWidget widget, @NotNull String anchor) {
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addWidget"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addWidget"));
        }
        this.addWidget(widget, Position.RIGHT, anchor);
    }

    private void addWidget(@NotNull StatusBarWidget widget, @NotNull Position pos) {
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addWidget"));
        }
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addWidget"));
        }
        this.addWidget(widget, pos, "__IGNORED__");
    }

    public void addWidget(final @NotNull StatusBarWidget widget, @NotNull Disposable parentDisposable) {
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addWidget"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addWidget"));
        }
        this.addWidget(widget);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                IdeStatusBarImpl.this.removeWidget(widget.ID());
            }
        });
    }

    public void addWidget(final @NotNull StatusBarWidget widget, @NotNull String anchor, @NotNull Disposable parentDisposable) {
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addWidget"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addWidget"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addWidget"));
        }
        this.addWidget(widget, anchor);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                IdeStatusBarImpl.this.removeWidget(widget.ID());
            }
        });
    }

    @Override
    public void removeCustomIndicationComponents() {
        for (String id : this.myCustomComponentIds) {
            this.removeWidget(id);
        }
        this.myCustomComponentIds.clear();
    }

    public void addCustomIndicationComponent(final @NotNull JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addCustomIndicationComponent"));
        }
        final String customId = c.getClass().getName() + new Random().nextLong();
        this.addWidget((StatusBarWidget)new CustomStatusBarWidget(){

            @NotNull
            public String ID() {
                String string = customId;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$4", "ID"));
                }
                return string;
            }

            @Nullable
            public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$4", "getPresentation"));
                }
                return null;
            }

            public void install(@NotNull StatusBar statusBar) {
                if (statusBar == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$4", "install"));
                }
            }

            public void dispose() {
            }

            public JComponent getComponent() {
                return c;
            }
        });
        this.myCustomComponentIds.add(customId);
    }

    public void removeCustomIndicationComponent(@NotNull JComponent c) {
        String[] keys;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "removeCustomIndicationComponent"));
        }
        Set<String> keySet = this.myWidgetMap.keySet();
        for (String key : keys = ArrayUtil.toStringArray(keySet)) {
            WidgetBean value = this.myWidgetMap.get(key);
            if (!(value.widget instanceof CustomStatusBarWidget) || value.component != c) continue;
            this.removeWidget(key);
            this.myCustomComponentIds.remove(key);
        }
    }

    public void dispose() {
        this.myWidgetMap.clear();
        this.myChildren.clear();
        if (this.myLeftPanel != null) {
            this.myLeftPanel.removeAll();
        }
        if (this.myRightPanel != null) {
            this.myRightPanel.removeAll();
        }
        if (this.myCenterPanel != null) {
            this.myCenterPanel.removeAll();
        }
    }

    private void addWidget(@NotNull StatusBarWidget widget, final @NotNull Position pos, final @NotNull String anchor) {
        JPanel panel;
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addWidget"));
        }
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addWidget"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addWidget"));
        }
        this.myOrderedWidgets.add(widget.ID());
        if (pos == Position.RIGHT) {
            if (this.myRightPanel == null) {
                this.myRightPanel = new JPanel();
                this.myRightPanel.setLayout(new BoxLayout(this.myRightPanel, 0));
                this.myRightPanel.setOpaque(false);
                this.add((Component)this.myRightPanel, "East");
            }
            panel = this.myRightPanel;
        } else if (pos == Position.LEFT) {
            if (this.myLeftPanel == null) {
                this.myLeftPanel = new JPanel();
                this.myLeftPanel.setLayout(new BoxLayout(this.myLeftPanel, 0));
                this.myLeftPanel.setOpaque(false);
                this.add((Component)this.myLeftPanel, "West");
            }
            panel = this.myLeftPanel;
        } else {
            if (this.myCenterPanel == null) {
                this.myCenterPanel = new JPanel(new BorderLayout());
                this.myCenterPanel.setOpaque(false);
                this.add((Component)this.myCenterPanel, "Center");
            }
            panel = this.myCenterPanel;
        }
        JComponent c = IdeStatusBarImpl.wrap(widget);
        if (Position.RIGHT == pos && panel.getComponentCount() > 0) {
            boolean before;
            String wid;
            if (!anchor.equals("__AUTODETECT__")) {
                List parts = StringUtil.split((String)anchor, (String)" ");
                if (parts.size() < 2 || !this.myWidgetMap.keySet().contains(parts.get(1))) {
                    wid = "Notifications";
                    before = true;
                } else {
                    wid = (String)parts.get(1);
                    before = "before".equalsIgnoreCase((String)parts.get(0));
                }
            } else {
                wid = "Notifications";
                before = true;
            }
            for (String id : this.myWidgetMap.keySet()) {
                if (!id.equalsIgnoreCase(wid)) continue;
                WidgetBean bean = this.myWidgetMap.get(id);
                int i = 0;
                for (Component component : this.myRightPanel.getComponents()) {
                    if (component == bean.component) {
                        if (before) {
                            panel.add((Component)c, i);
                            this.updateBorder(i);
                        } else {
                            int ndx = i + 1;
                            panel.add((Component)c, i + 1);
                            this.updateBorder(ndx);
                        }
                        this.installWidget(widget, pos, c, anchor);
                        return;
                    }
                    ++i;
                }
            }
        }
        if (Position.LEFT == pos && panel.getComponentCount() == 0) {
            c.setBorder(SystemInfo.isMac ? BorderFactory.createEmptyBorder(2, 0, 2, 4) : BorderFactory.createEmptyBorder());
        }
        panel.add(c);
        this.installWidget(widget, pos, c, anchor);
        if (widget instanceof StatusBarWidget.Multiframe) {
            final StatusBarWidget.Multiframe mfw = (StatusBarWidget.Multiframe)widget;
            this.updateChildren(new ChildAction(){

                @Override
                public void update(IdeStatusBarImpl child) {
                    StatusBarWidget widgetCopy = mfw.copy();
                    child.addWidget(widgetCopy, pos, anchor);
                }
            });
        }
    }

    private void updateBorder(int ndx) {
        JComponent self;
        if (this.myRightPanel.getComponentCount() == 0) {
            return;
        }
        if (ndx >= this.myRightPanel.getComponentCount()) {
            --ndx;
        }
        if (ndx < 0) {
            ++ndx;
        }
        if ((self = (JComponent)this.myRightPanel.getComponent(ndx)) instanceof IconPresentationWrapper || self instanceof IconLikeCustomStatusBarWidget) {
            int prev = ndx - 1;
            int next = ndx + 1;
            JComponent p = prev >= 0 ? (JComponent)this.myRightPanel.getComponent(prev) : null;
            JComponent n = next < this.myRightPanel.getComponentCount() ? (JComponent)this.myRightPanel.getComponent(next) : null;
            boolean prevIcon = p instanceof IconPresentationWrapper || p instanceof IconLikeCustomStatusBarWidget;
            boolean nextIcon = n instanceof IconPresentationWrapper || n instanceof IconLikeCustomStatusBarWidget;
            self.setBorder(prevIcon ? BorderFactory.createEmptyBorder(2, 2, 2, 2) : StatusBarWidget.WidgetBorder.INSTANCE);
            if (nextIcon) {
                n.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            }
        }
    }

    public void setInfo(@Nullable String s) {
        this.setInfo(s, null);
    }

    public void setInfo(final @Nullable String s, final @Nullable String requestor) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (IdeStatusBarImpl.this.myInfoAndProgressPanel != null) {
                    Pair<String, String> pair = IdeStatusBarImpl.this.myInfoAndProgressPanel.setText(s, requestor);
                    IdeStatusBarImpl.this.myInfo = (String)pair.first;
                    IdeStatusBarImpl.this.myRequestor = (String)pair.second;
                }
            }
        });
    }

    public String getInfo() {
        return this.myInfo;
    }

    @Override
    public String getInfoRequestor() {
        return this.myRequestor;
    }

    @Override
    public void addProgress(@NotNull ProgressIndicatorEx indicator, @NotNull TaskInfo info) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addProgress"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "addProgress"));
        }
        this.myInfoAndProgressPanel.addProgress(indicator, info);
    }

    @Override
    public List<Pair<TaskInfo, ProgressIndicator>> getBackgroundProcesses() {
        return this.myInfoAndProgressPanel.getBackgroundProcesses();
    }

    @Override
    public void setProcessWindowOpen(boolean open) {
        this.myInfoAndProgressPanel.setProcessWindowOpen(open);
    }

    @Override
    public boolean isProcessWindowOpen() {
        return this.myInfoAndProgressPanel.isProcessWindowOpen();
    }

    @Override
    public void startRefreshIndication(final String tooltipText) {
        this.myInfoAndProgressPanel.setRefreshToolTipText(tooltipText);
        this.myInfoAndProgressPanel.setRefreshVisible(true);
        this.updateChildren(new ChildAction(){

            @Override
            public void update(IdeStatusBarImpl child) {
                child.startRefreshIndication(tooltipText);
            }
        });
    }

    @Override
    public void stopRefreshIndication() {
        this.myInfoAndProgressPanel.setRefreshVisible(false);
        this.updateChildren(new ChildAction(){

            @Override
            public void update(IdeStatusBarImpl child) {
                child.stopRefreshIndication();
            }
        });
    }

    @Override
    public BalloonHandler notifyProgressByBalloon(@NotNull MessageType type, @NotNull String htmlBody) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "notifyProgressByBalloon"));
        }
        if (htmlBody == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "notifyProgressByBalloon"));
        }
        return this.notifyProgressByBalloon(type, htmlBody, null, null);
    }

    @Override
    public BalloonHandler notifyProgressByBalloon(@NotNull MessageType type, @NotNull String htmlBody, @Nullable Icon icon, @Nullable HyperlinkListener listener) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "notifyProgressByBalloon"));
        }
        if (htmlBody == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "notifyProgressByBalloon"));
        }
        return this.myInfoAndProgressPanel.notifyByBalloon(type, htmlBody, icon, listener);
    }

    public void fireNotificationPopup(@NotNull JComponent content, Color backgroundColor) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "fireNotificationPopup"));
        }
        new NotificationPopup(this, content, backgroundColor);
    }

    private void installWidget(@NotNull StatusBarWidget widget, @NotNull Position pos, @NotNull JComponent c, String anchor) {
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "installWidget"));
        }
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "installWidget"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "installWidget"));
        }
        this.myWidgetMap.put(widget.ID(), WidgetBean.create(widget, pos, c, anchor));
        widget.install((StatusBar)this);
        Disposer.register((Disposable)this, (Disposable)widget);
    }

    private static JComponent wrap(@NotNull StatusBarWidget widget) {
        JComponent wrapper;
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "wrap"));
        }
        if (widget instanceof CustomStatusBarWidget) {
            return ((CustomStatusBarWidget)widget).getComponent();
        }
        StatusBarWidget.WidgetPresentation presentation = widget.getPresentation(SystemInfo.isMac ? StatusBarWidget.PlatformType.MAC : StatusBarWidget.PlatformType.DEFAULT);
        assert (presentation != null) : "Presentation should not be null!";
        if (presentation instanceof StatusBarWidget.IconPresentation) {
            wrapper = new IconPresentationWrapper((StatusBarWidget.IconPresentation)presentation);
        } else if (presentation instanceof StatusBarWidget.TextPresentation) {
            wrapper = new TextPresentationWrapper((StatusBarWidget.TextPresentation)presentation);
            wrapper.setBorder((Border)StatusBarWidget.WidgetBorder.INSTANCE);
        } else if (presentation instanceof StatusBarWidget.MultipleTextValuesPresentation) {
            wrapper = new MultipleTextValuesPresentationWrapper((StatusBarWidget.MultipleTextValuesPresentation)presentation);
            wrapper.setBorder((Border)StatusBarWidget.WidgetBorder.INSTANCE);
        } else {
            throw new IllegalArgumentException("Unable to find a wrapper for presentation: " + presentation.getClass().getSimpleName());
        }
        return wrapper;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected void setUI(StatusBarUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((StatusBarUI)UIManager.getUI(this));
        } else {
            this.setUI(SystemInfo.isMac && !UIUtil.isUnderDarcula() ? new MacStatusBarUI() : new StatusBarUI());
        }
    }

    @Override
    public StatusBarUI getUI() {
        return (StatusBarUI)this.ui;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (UIUtil.isUnderDarcula()) {
            g.setColor(UIUtil.getPanelBackground());
            g.drawLine(0, this.getHeight(), this.getWidth(), this.getHeight());
        }
    }

    public void removeWidget(final @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "removeWidget"));
        }
        WidgetBean bean = this.myWidgetMap.get(id);
        if (bean != null) {
            if (Position.LEFT == bean.position) {
                this.myLeftPanel.remove(bean.component);
            } else if (Position.RIGHT == bean.position) {
                Component[] components = this.myRightPanel.getComponents();
                int i = 0;
                for (Component c : components) {
                    if (c == bean.component) break;
                    ++i;
                }
                this.myRightPanel.remove(bean.component);
                this.updateBorder(i);
            } else {
                this.myCenterPanel.remove(bean.component);
            }
            this.myWidgetMap.remove(bean.widget.ID());
            Disposer.dispose((Disposable)bean.widget);
        }
        this.updateChildren(new ChildAction(){

            @Override
            public void update(IdeStatusBarImpl child) {
                child.removeWidget(id);
            }
        });
        this.myOrderedWidgets.remove(id);
    }

    @Override
    public void updateWidgets() {
        for (String s : this.myWidgetMap.keySet()) {
            this.updateWidget(s);
        }
        this.updateChildren(new ChildAction(){

            @Override
            public void update(IdeStatusBarImpl child) {
                child.updateWidgets();
            }
        });
    }

    public void updateWidget(final @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl", "updateWidget"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                WidgetBean bean = (WidgetBean)IdeStatusBarImpl.this.myWidgetMap.get(id);
                if (bean != null) {
                    if (bean.component instanceof StatusBarWrapper) {
                        ((StatusBarWrapper)((Object)bean.component)).beforeUpdate();
                    }
                    bean.component.repaint();
                }
                IdeStatusBarImpl.this.updateChildren(new ChildAction(){

                    @Override
                    public void update(IdeStatusBarImpl child) {
                        child.updateWidget(id);
                    }
                });
            }
        });
    }

    @Nullable
    public StatusBarWidget getWidget(String id) {
        WidgetBean bean = this.myWidgetMap.get(id);
        return bean == null ? null : bean.widget;
    }

    public IdeFrame getFrame() {
        return this.myFrame;
    }

    private static final class IconPresentationWrapper
    extends JComponent
    implements StatusBarWrapper {
        private final StatusBarWidget.IconPresentation myPresentation;
        private final Consumer<MouseEvent> myClickConsumer;
        private Icon myIcon;

        private IconPresentationWrapper(@NotNull StatusBarWidget.IconPresentation presentation) {
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$IconPresentationWrapper", "<init>"));
            }
            this.myPresentation = presentation;
            this.myClickConsumer = this.myPresentation.getClickConsumer();
            this.myIcon = this.myPresentation.getIcon();
            this.putClientProperty("ToCenterTooltip", Boolean.TRUE);
            this.setToolTipText(presentation.getTooltipText());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (IconPresentationWrapper.this.myClickConsumer != null && !e.isPopupTrigger() && 1 == e.getButton()) {
                        IconPresentationWrapper.this.myClickConsumer.consume((Object)e);
                    }
                }
            });
            this.setOpaque(false);
        }

        @Override
        public void beforeUpdate() {
            this.myIcon = this.myPresentation.getIcon();
        }

        private StatusBarWidget.IconPresentation getPresentation() {
            return this.myPresentation;
        }

        @Override
        @Nullable
        public String getToolTipText() {
            return this.myPresentation.getTooltipText();
        }

        @Override
        protected void paintComponent(Graphics g) {
            Rectangle bounds = this.getBounds();
            Insets insets = this.getInsets();
            if (this.myIcon != null) {
                int iconWidth = this.myIcon.getIconWidth();
                int iconHeight = this.myIcon.getIconHeight();
                this.myIcon.paintIcon(this, g, insets.left + (bounds.width - insets.left - insets.right - iconWidth) / 2, insets.top + (bounds.height - insets.top - insets.bottom - iconHeight) / 2);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(24, 20);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }

    private static final class TextPresentationWrapper
    extends TextPanel
    implements StatusBarWrapper {
        private final StatusBarWidget.TextPresentation myPresentation;
        private final Consumer<MouseEvent> myClickConsumer;
        private boolean myMouseOver;

        private TextPresentationWrapper(@NotNull StatusBarWidget.TextPresentation presentation) {
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$TextPresentationWrapper", "<init>"));
            }
            this.myPresentation = presentation;
            this.myClickConsumer = this.myPresentation.getClickConsumer();
            this.setTextAlignment(presentation.getAlignment());
            this.putClientProperty("ToCenterTooltip", Boolean.TRUE);
            this.setToolTipText(presentation.getTooltipText());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (TextPresentationWrapper.this.myClickConsumer != null && !e.isPopupTrigger() && 1 == e.getButton()) {
                        TextPresentationWrapper.this.myClickConsumer.consume((Object)e);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    TextPresentationWrapper.this.myMouseOver = true;
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    TextPresentationWrapper.this.myMouseOver = false;
                }
            });
            this.setOpaque(false);
        }

        @Override
        @Nullable
        public String getToolTipText() {
            return this.myPresentation.getTooltipText();
        }

        @Override
        public void beforeUpdate() {
            this.setText(this.myPresentation.getText());
        }
    }

    private static final class MultipleTextValuesPresentationWrapper
    extends TextPanel
    implements StatusBarWrapper {
        private final StatusBarWidget.MultipleTextValuesPresentation myPresentation;

        private MultipleTextValuesPresentationWrapper(@NotNull StatusBarWidget.MultipleTextValuesPresentation presentation) {
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$MultipleTextValuesPresentationWrapper", "<init>"));
            }
            this.myPresentation = presentation;
            this.putClientProperty("ToCenterTooltip", Boolean.TRUE);
            this.setToolTipText(presentation.getTooltipText());
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$MultipleTextValuesPresentationWrapper$1", "onClick"));
                    }
                    ListPopup popup = MultipleTextValuesPresentationWrapper.this.myPresentation.getPopupStep();
                    if (popup == null) {
                        return false;
                    }
                    Dimension dimension = popup.getContent().getPreferredSize();
                    Point at = new Point(0, -dimension.height);
                    popup.show(new RelativePoint(e.getComponent(), at));
                    return true;
                }
            }.installOn((Component)this);
            this.setOpaque(false);
        }

        @Override
        public void beforeUpdate() {
            this.setText(this.myPresentation.getSelectedValue());
        }

        @Override
        @Nullable
        public String getToolTipText() {
            return this.myPresentation.getTooltipText();
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$MultipleTextValuesPresentationWrapper", "paintComponent"));
            }
            super.paintComponent(g);
            if (this.getText() != null) {
                Rectangle r = this.getBounds();
                Insets insets = this.getInsets();
                Icon icon = AllIcons.Ide.Statusbar_arrows;
                icon.paintIcon(this, g, r.width - insets.right - icon.getIconWidth() - 2, r.height / 2 - icon.getIconHeight() / 2);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            return new Dimension(preferredSize.width + AllIcons.Ide.Statusbar_arrows.getIconWidth() + 4, preferredSize.height);
        }
    }

    private static interface StatusBarWrapper {
        public void beforeUpdate();
    }

    static interface ChildAction {
        public void update(IdeStatusBarImpl var1);
    }

    private static class WidgetBean {
        JComponent component;
        Position position;
        StatusBarWidget widget;
        String anchor;

        private WidgetBean() {
        }

        static WidgetBean create(@NotNull StatusBarWidget widget, @NotNull Position position, @NotNull JComponent component, @NotNull String anchor) {
            if (widget == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$WidgetBean", "create"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$WidgetBean", "create"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$WidgetBean", "create"));
            }
            if (anchor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$WidgetBean", "create"));
            }
            WidgetBean bean = new WidgetBean();
            bean.widget = widget;
            bean.position = position;
            bean.component = component;
            bean.anchor = anchor;
            return bean;
        }
    }

    private static enum Position {
        LEFT,
        RIGHT,
        CENTER;

    }
}

