/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.Patches;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Toolkit;
import java.awt.peer.ComponentPeer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public class X11UiUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.X11UiUtil");
    private static final int True = 1;
    private static final int False = 0;
    private static final long None = 0L;
    private static final long XA_ATOM = 4L;
    private static final long XA_WINDOW = 33L;
    private static final int CLIENT_MESSAGE = 33;
    private static final int FORMAT_BYTE = 8;
    private static final int FORMAT_LONG = 32;
    private static final long EVENT_MASK = 0x180000L;
    private static final long NET_WM_STATE_TOGGLE = 2L;
    @Nullable
    private static final Xlib X11 = Xlib.access$400();

    @Nullable
    public static String getWmName() {
        if (X11 == null) {
            return null;
        }
        try {
            Long netWmWindow = X11UiUtil.X11.getNetWmWindow();
            if (netWmWindow != null) {
                return X11UiUtil.X11.getUtfStringProperty(netWmWindow, X11.NET_WM_NAME);
            }
        }
        catch (Throwable t) {
            LOG.info("cannot get WM name", t);
        }
        return null;
    }

    public static void patchDetectedWm(String wmName) {
        if (X11 == null || !Registry.is((String)"ide.x11.override.wm")) {
            return;
        }
        try {
            if (wmName.startsWith("Mutter") || "Muffin".equals(wmName) || "GNOME Shell".equals(wmName)) {
                X11UiUtil.setWM("MUTTER_WM", "METACITY_WM");
            } else if ("Marco".equals(wmName)) {
                X11UiUtil.setWM("MARCO_WM", "METACITY_WM");
            } else if ("awesome".equals(wmName)) {
                X11UiUtil.setWM("SAWFISH_WM");
            }
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
    }

    private static void setWM(String ... wmConstants) throws Exception {
        Class<?> xwmClass = Class.forName("sun.awt.X11.XWM");
        Object xwm = X11UiUtil.method(xwmClass, "getWM", new Class[0]).invoke(null, new Object[0]);
        if (xwm != null) {
            for (String wmConstant : wmConstants) {
                try {
                    Field wm = X11UiUtil.field(xwmClass, wmConstant);
                    Object id = wm.get(null);
                    if (id == null) continue;
                    X11UiUtil.field(xwmClass, "awt_wmgr").set(null, id);
                    X11UiUtil.field(xwmClass, "WMID").set(xwm, id);
                    break;
                }
                catch (NoSuchFieldException ignore) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean isFullScreenSupported() {
        String wmName;
        if (X11 == null) {
            return false;
        }
        if (Patches.SUN_BUG_ID_8013359 && (wmName = X11UiUtil.getWmName()) != null && (wmName.startsWith("Mutter") || ContainerUtil.newHashSet((Object[])new String[]{"Metacity", "GNOME Shell", "Muffin", "Marco"}).contains(wmName))) {
            return false;
        }
        IdeFrame[] frames = WindowManager.getInstance().getAllProjectFrames();
        if (frames.length == 0) {
            return true;
        }
        return frames[0] instanceof JFrame && X11UiUtil.hasWindowProperty((JFrame)frames[0], X11.NET_WM_ALLOWED_ACTIONS, X11.NET_WM_ACTION_FULLSCREEN);
    }

    public static boolean isInFullScreenMode(JFrame frame) {
        return X11 != null && X11UiUtil.hasWindowProperty(frame, X11.NET_WM_STATE, X11.NET_WM_STATE_FULLSCREEN);
    }

    private static boolean hasWindowProperty(JFrame frame, long name, long expected) {
        if (X11 == null) {
            return false;
        }
        try {
            ComponentPeer peer = frame.getPeer();
            long window = (Long)X11.getWindow.invoke((Object)peer, new Object[0]);
            long[] values = X11UiUtil.X11.getLongArrayProperty(window, name, 4L);
            if (values != null) {
                for (long value : values) {
                    if (value != expected) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            LOG.info("cannot check window property", t);
            return false;
        }
    }

    public static void toggleFullScreenMode(JFrame frame) {
        if (X11 == null) {
            return;
        }
        try {
            ComponentPeer peer = frame.getPeer();
            long window = (Long)X11.getWindow.invoke((Object)peer, new Object[0]);
            long screen = (Long)X11.getScreenNumber.invoke((Object)peer, new Object[0]);
            long rootWindow = (Long)X11.RootWindow.invoke(null, X11.display, screen);
            X11UiUtil.X11.sendClientMessage(rootWindow, window, X11.NET_WM_STATE, new long[]{2L, X11.NET_WM_STATE_FULLSCREEN});
        }
        catch (Throwable t) {
            LOG.info("cannot toggle mode", t);
        }
    }

    private static Method method(Class<?> aClass, String name, Class<?> ... parameterTypes) throws Exception {
        while (aClass != null) {
            try {
                Method method = aClass.getDeclaredMethod(name, parameterTypes);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                aClass = aClass.getSuperclass();
            }
        }
        throw new NoSuchMethodException(name);
    }

    private static Method method(Class<?> aClass, String name, int parameters) throws Exception {
        for (Method method : aClass.getDeclaredMethods()) {
            if (!name.equals(method.getName()) || method.getParameterTypes().length != parameters) continue;
            method.setAccessible(true);
            return method;
        }
        throw new NoSuchMethodException(name);
    }

    private static Field field(Class<?> aClass, String name) throws Exception {
        Field field = aClass.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }

    private static class Xlib {
        private Unsafe unsafe;
        private Method XGetWindowProperty;
        private Method XFree;
        private Method RootWindow;
        private Method XSendEvent;
        private Method getWindow;
        private Method getScreenNumber;
        private Method awtLock;
        private Method awtUnlock;
        private long display;
        private long UTF8_STRING;
        private long NET_SUPPORTING_WM_CHECK;
        private long NET_WM_NAME;
        private long NET_WM_ALLOWED_ACTIONS;
        private long NET_WM_STATE;
        private long NET_WM_ACTION_FULLSCREEN;
        private long NET_WM_STATE_FULLSCREEN;

        private Xlib() {
        }

        @Nullable
        private static Xlib getInstance() {
            Class<?> toolkitClass = Toolkit.getDefaultToolkit().getClass();
            if (!SystemInfo.isXWindow || !"sun.awt.X11.XToolkit".equals(toolkitClass.getName())) {
                return null;
            }
            try {
                Xlib x11 = new Xlib();
                Class<?> XlibWrapper = Class.forName("sun.awt.X11.XlibWrapper");
                x11.unsafe = (Unsafe)X11UiUtil.field(XlibWrapper, "unsafe").get(null);
                x11.XGetWindowProperty = X11UiUtil.method(XlibWrapper, "XGetWindowProperty", 12);
                x11.XFree = X11UiUtil.method(XlibWrapper, "XFree", 1);
                x11.RootWindow = X11UiUtil.method(XlibWrapper, "RootWindow", 2);
                x11.XSendEvent = X11UiUtil.method(XlibWrapper, "XSendEvent", 5);
                Class<?> XBaseWindow = Class.forName("sun.awt.X11.XBaseWindow");
                x11.getWindow = X11UiUtil.method(XBaseWindow, "getWindow", new Class[0]);
                x11.getScreenNumber = X11UiUtil.method(XBaseWindow, "getScreenNumber", new Class[0]);
                x11.display = (Long)X11UiUtil.method(toolkitClass, "getDisplay", new Class[0]).invoke(null, new Object[0]);
                x11.awtLock = X11UiUtil.method(toolkitClass, "awtLock", new Class[0]);
                x11.awtUnlock = X11UiUtil.method(toolkitClass, "awtUnlock", new Class[0]);
                Class<?> XAtom = Class.forName("sun.awt.X11.XAtom");
                Method get = X11UiUtil.method(XAtom, "get", new Class[]{String.class});
                Field atom = X11UiUtil.field(XAtom, "atom");
                x11.UTF8_STRING = (Long)atom.get(get.invoke(null, "UTF8_STRING"));
                x11.NET_SUPPORTING_WM_CHECK = (Long)atom.get(get.invoke(null, "_NET_SUPPORTING_WM_CHECK"));
                x11.NET_WM_NAME = (Long)atom.get(get.invoke(null, "_NET_WM_NAME"));
                x11.NET_WM_ALLOWED_ACTIONS = (Long)atom.get(get.invoke(null, "_NET_WM_ALLOWED_ACTIONS"));
                x11.NET_WM_STATE = (Long)atom.get(get.invoke(null, "_NET_WM_STATE"));
                x11.NET_WM_ACTION_FULLSCREEN = (Long)atom.get(get.invoke(null, "_NET_WM_ACTION_FULLSCREEN"));
                x11.NET_WM_STATE_FULLSCREEN = (Long)atom.get(get.invoke(null, "_NET_WM_STATE_FULLSCREEN"));
                Long netWmWindow = x11.getNetWmWindow();
                if (netWmWindow == null) {
                    LOG.info("_NET protocol is not supported");
                    return null;
                }
                return x11;
            }
            catch (Throwable t) {
                LOG.info("cannot initialize", t);
                return null;
            }
        }

        @Nullable
        private Long getNetWmWindow() throws Exception {
            long rootWindow = (Long)this.RootWindow.invoke(null, this.display, 0);
            long[] values = this.getLongArrayProperty(rootWindow, this.NET_SUPPORTING_WM_CHECK, 33L);
            return values != null && values.length > 0 ? Long.valueOf(values[0]) : null;
        }

        @Nullable
        private long[] getLongArrayProperty(long window, long name, long type) throws Exception {
            return (long[])this.getWindowProperty(window, name, type, 32L);
        }

        @Nullable
        private String getUtfStringProperty(long window, long name) throws Exception {
            byte[] bytes = (byte[])this.getWindowProperty(window, name, this.UTF8_STRING, 8L);
            return bytes != null ? new String(bytes, "UTF-8") : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private <T> T getWindowProperty(long window, long name, long type, long expectedFormat) throws Exception {
            Object[] property = null;
            long data = this.unsafe.allocateMemory(64L);
            this.awtLock.invoke(null, new Object[0]);
            try {
                this.unsafe.setMemory(data, 64L, (byte)0);
                int result = (Integer)this.XGetWindowProperty.invoke(null, this.display, window, name, 0L, 65535L, 0L, type, data, data + 8L, data + 16L, data + 24L, data + 32L);
                if (result == 0) {
                    long pointer;
                    int format = this.unsafe.getInt(data + 8L);
                    long l = pointer = SystemInfo.is64Bit ? this.unsafe.getLong(data + 32L) : (long)this.unsafe.getInt(data + 32L);
                    if (pointer != 0L && (long)format == expectedFormat) {
                        int length;
                        int n = length = SystemInfo.is64Bit ? (int)this.unsafe.getLong(data + 16L) : this.unsafe.getInt(data + 16L);
                        if (format == 8) {
                            byte[] bytes = new byte[length];
                            for (int i = 0; i < length; ++i) {
                                bytes[i] = this.unsafe.getByte(pointer + (long)i);
                            }
                            property = bytes;
                        } else if (format == 32) {
                            long[] values = ArrayUtil.newLongArray((int)length);
                            for (int i = 0; i < length; ++i) {
                                values[i] = SystemInfo.is64Bit ? this.unsafe.getLong(pointer + (long)(8 * i)) : (long)this.unsafe.getInt(pointer + (long)(4 * i));
                            }
                            property = values;
                        } else if ((long)format != 0L) {
                            LOG.info("unexpected format: " + format);
                        }
                    }
                    if (pointer != 0L) {
                        this.XFree.invoke(null, pointer);
                    }
                }
            }
            finally {
                this.awtUnlock.invoke(null, new Object[0]);
                this.unsafe.freeMemory(data);
            }
            return (T)property;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendClientMessage(long target, long window, long type, long ... data) throws Exception {
            assert (data.length <= 5);
            long event = this.unsafe.allocateMemory(128L);
            this.awtLock.invoke(null, new Object[0]);
            try {
                this.unsafe.setMemory(event, 128L, (byte)0);
                this.unsafe.putInt(event, 33);
                if (!SystemInfo.is64Bit) {
                    this.unsafe.putInt(event + 8L, 1);
                    this.unsafe.putInt(event + 16L, (int)window);
                    this.unsafe.putInt(event + 20L, (int)type);
                    this.unsafe.putInt(event + 24L, 32);
                    for (int i = 0; i < data.length; ++i) {
                        this.unsafe.putInt(event + 28L + (long)(4 * i), (int)data[i]);
                    }
                } else {
                    this.unsafe.putInt(event + 16L, 1);
                    this.unsafe.putLong(event + 32L, window);
                    this.unsafe.putLong(event + 40L, this.NET_WM_STATE);
                    this.unsafe.putInt(event + 48L, 32);
                    for (int i = 0; i < data.length; ++i) {
                        this.unsafe.putLong(event + 56L + (long)(8 * i), data[i]);
                    }
                }
                this.XSendEvent.invoke(null, this.display, target, false, 0x180000L, event);
            }
            finally {
                this.awtUnlock.invoke(null, new Object[0]);
                this.unsafe.freeMemory(event);
            }
        }

        static /* synthetic */ Xlib access$400() {
            return Xlib.getInstance();
        }
    }
}

