/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.impl.IdeNotificationArea;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.status.EncodingPanel;
import com.intellij.openapi.wm.impl.status.InsertOverwritePanel;
import com.intellij.openapi.wm.impl.status.LineSeparatorPanel;
import com.intellij.openapi.wm.impl.status.PositionPanel;
import com.intellij.openapi.wm.impl.status.ToggleReadOnlyAttributePanel;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SideBorder;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeFrameImpl
extends JFrame
implements IdeFrameEx,
DataProvider {
    public static final Key<Boolean> SHOULD_OPEN_IN_FULL_SCREEN = Key.create((String)"should.open.in.full.screen");
    private static final String FULL_SCREEN = "FullScreen";
    private static boolean myUpdatingTitle;
    private static String xdgCurrentDesktop;
    private String myTitle;
    private String myFileTitle;
    private File myCurrentFile;
    private Project myProject;
    private IdeRootPane myRootPane;
    private final BalloonLayout myBalloonLayout;
    private IdeFrameDecorator myFrameDecorator;
    private boolean myRestoreFullScreen;

    public IdeFrameImpl(ApplicationInfoEx applicationInfoEx, ActionManagerEx actionManager, UISettings uiSettings, DataManager dataManager, Application application) {
        super(applicationInfoEx.getFullApplicationName());
        this.myRootPane = this.createRootPane(actionManager, uiSettings, dataManager, application);
        this.setRootPane(this.myRootPane);
        this.setBackground(UIUtil.getPanelBackground());
        AppUIUtil.updateWindowIcon(this);
        Dimension size = ScreenUtil.getMainScreenBounds().getSize();
        size.width = Math.min(1400, size.width - 20);
        size.height = Math.min(1000, size.height - 40);
        this.setSize(size);
        this.setLocationRelativeTo(null);
        LayoutFocusTraversalPolicyExt layoutFocusTraversalPolicy = new LayoutFocusTraversalPolicyExt();
        this.setFocusTraversalPolicy(layoutFocusTraversalPolicy);
        this.setupCloseAction();
        new MnemonicHelper().register((Component)this);
        this.myBalloonLayout = new BalloonLayoutImpl(this.myRootPane.getLayeredPane(), new Insets(8, 8, 8, 8));
        if (!Registry.is((String)"ide.windowSystem.focusAppOnStartup") && !IdeFrameImpl.isThereActiveFrame()) {
            this.setFocusableWindowState(false);
        }
        if (SystemInfo.isMac) {
            this.setIconImage(null);
        }
        MouseGestureManager.getInstance().add(this);
        this.myFrameDecorator = IdeFrameDecorator.decorate(this);
        this.addWindowStateListener(new WindowAdapter(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                IdeFrameImpl.this.updateBorder();
            }
        });
        Toolkit.getDefaultToolkit().addPropertyChangeListener("win.xpstyle.themeActive", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IdeFrameImpl.this.updateBorder();
            }
        });
        IdeMenuBar.installAppMenuIfNeeded(this);
    }

    private void updateBorder() {
        int state = this.getExtendedState();
        if (!WindowManager.getInstance().isFullScreenSupportedInCurrentOS() || !SystemInfo.isWindows || this.myRootPane == null) {
            return;
        }
        this.myRootPane.setBorder(null);
        boolean isNotClassic = Boolean.parseBoolean(String.valueOf(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")));
        if (isNotClassic && (state & 6) != 0) {
            IdeFrame[] projectFrames = WindowManager.getInstance().getAllProjectFrames();
            GraphicsDevice device = ScreenUtil.getScreenDevice((Rectangle)this.getBounds());
            for (IdeFrame frame : projectFrames) {
                if (frame == this || !((IdeFrameImpl)frame).isInFullScreen() || ScreenUtil.getScreenDevice((Rectangle)((IdeFrameImpl)frame).getBounds()) != device) continue;
                Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(device.getDefaultConfiguration());
                int mask = 0;
                if (insets.top != 0) {
                    mask |= 2;
                }
                if (insets.left != 0) {
                    mask |= 1;
                }
                if (insets.bottom != 0) {
                    mask |= 8;
                }
                if (insets.right != 0) {
                    mask |= 4;
                }
                this.myRootPane.setBorder((Border)new SideBorder((Color)JBColor.BLACK, mask, false, 3));
                break;
            }
        }
    }

    protected IdeRootPane createRootPane(ActionManagerEx actionManager, UISettings uiSettings, DataManager dataManager, Application application) {
        return new IdeRootPane(actionManager, uiSettings, dataManager, application, this);
    }

    @Override
    public Insets getInsets() {
        if (SystemInfo.isMac && this.isInFullScreen()) {
            return new Insets(0, 0, 0, 0);
        }
        return super.getInsets();
    }

    public JComponent getComponent() {
        return this.getRootPane();
    }

    @Nullable
    public static Window getActiveFrame() {
        for (Frame frame : IdeFrameImpl.getFrames()) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return null;
    }

    public static boolean isThereActiveFrame() {
        Frame[] all;
        for (Frame each : all = Frame.getFrames()) {
            if (!each.isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void show() {
        super.show();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeFrameImpl.this.setFocusableWindowState(true);
            }
        });
    }

    @Override
    public synchronized void setMaximizedBounds(Rectangle bounds) {
        super.setMaximizedBounds(null);
    }

    private void setupCloseAction() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (IdeFrameImpl.this.isTemporaryDisposed()) {
                    return;
                }
                final Application app = ApplicationManager.getApplication();
                app.invokeLater((Runnable)new DumbAwareRunnable(){

                    public void run() {
                        if (app.isDisposed()) {
                            ApplicationManagerEx.getApplicationEx().exit();
                            return;
                        }
                        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
                        if (openProjects.length > 1 || openProjects.length == 1 && SystemInfo.isMacSystemMenu) {
                            if (IdeFrameImpl.this.myProject != null && IdeFrameImpl.this.myProject.isOpen()) {
                                ProjectUtil.closeAndDispose(IdeFrameImpl.this.myProject);
                            }
                            ((AppLifecycleListener)app.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).projectFrameClosed();
                            WelcomeFrame.showIfNoProjectOpened();
                        } else {
                            ApplicationManagerEx.getApplicationEx().exit();
                        }
                    }
                }, ModalityState.NON_MODAL);
            }
        });
    }

    public StatusBar getStatusBar() {
        return ((IdeRootPane)this.getRootPane()).getStatusBar();
    }

    @Override
    public void setTitle(String title) {
        if (myUpdatingTitle) {
            super.setTitle(title);
        } else {
            this.myTitle = title;
        }
        this.updateTitle();
    }

    public void setFrameTitle(String text) {
        super.setTitle(text);
    }

    public void setFileTitle(String fileTitle) {
        this.setFileTitle(fileTitle, null);
    }

    public void setFileTitle(@Nullable String fileTitle, @Nullable File file) {
        this.myFileTitle = fileTitle;
        this.myCurrentFile = file;
        this.updateTitle();
    }

    public IdeRootPaneNorthExtension getNorthExtension(String key) {
        return this.myRootPane.findByName(key);
    }

    private void updateTitle() {
        IdeFrameImpl.updateTitle(this, this.myTitle, this.myFileTitle, this.myCurrentFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTitle(JFrame frame, String title, String fileTitle, File currentFile) {
        if (myUpdatingTitle) {
            return;
        }
        try {
            myUpdatingTitle = true;
            frame.getRootPane().putClientProperty("Window.documentFile", currentFile);
            String applicationName = ((ApplicationInfoEx)ApplicationInfo.getInstance()).getFullApplicationName();
            Builder builder = new Builder();
            if (SystemInfo.isMac) {
                builder.append(fileTitle).append(title).append(ProjectManager.getInstance().getOpenProjects().length == 0 || ((ApplicationInfoEx)ApplicationInfo.getInstance()).isEAP() && !applicationName.endsWith("SNAPSHOT") ? applicationName : null);
            } else {
                builder.append(title).append(fileTitle).append(applicationName);
            }
            frame.setTitle(builder.sb.toString());
        }
        finally {
            myUpdatingTitle = false;
        }
    }

    public void updateView() {
        ((IdeRootPane)this.getRootPane()).updateToolbar();
        ((IdeRootPane)this.getRootPane()).updateMainMenuActions();
        ((IdeRootPane)this.getRootPane()).updateNorthComponents();
    }

    public Object getData(String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId) && this.myProject != null) {
            return this.myProject.isInitialized() ? this.myProject : null;
        }
        if (IdeFrame.KEY.getName().equals(dataId)) {
            return this;
        }
        return null;
    }

    public void setProject(Project project) {
        if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && this.myProject != project && project != null) {
            boolean bl = this.myRestoreFullScreen = this.myProject == null && IdeFrameImpl.shouldRestoreFullScreen(project);
            if (this.myProject != null) {
                this.storeFullScreenStateIfNeeded(false);
            }
        }
        this.myProject = project;
        if (project != null) {
            ProjectFrameBounds.getInstance(project);
            if (this.myRootPane != null) {
                this.myRootPane.installNorthComponents(project);
                project.getMessageBus().connect().subscribe(StatusBar.Info.TOPIC, (Object)this.myRootPane.getStatusBar());
            }
            this.installDefaultProjectStatusBarWidgets(this.myProject);
        } else if (this.myRootPane != null) {
            this.myRootPane.deinstallNorthComponents();
        }
        if (project == null) {
            FocusTrackback.release(this);
        }
        if (this.isVisible() && this.myRestoreFullScreen) {
            this.toggleFullScreen(true);
            this.myRestoreFullScreen = false;
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && this.myRestoreFullScreen) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeFrameImpl.this.toggleFullScreen(true);
                    if (SystemInfo.isMacOSLion) {
                        IdeFrameImpl.this.setBounds(ScreenUtil.getScreenRectangle((Point)IdeFrameImpl.this.getLocationOnScreen()));
                    }
                    IdeFrameImpl.this.myRestoreFullScreen = false;
                }
            });
        }
    }

    private void installDefaultProjectStatusBarWidgets(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/IdeFrameImpl", "installDefaultProjectStatusBarWidgets"));
        }
        final StatusBar statusBar = this.getStatusBar();
        final PositionPanel positionPanel = new PositionPanel(project);
        statusBar.addWidget((StatusBarWidget)positionPanel, "before FatalError");
        final IdeNotificationArea notificationArea = new IdeNotificationArea();
        statusBar.addWidget((StatusBarWidget)notificationArea, "before FatalError");
        final EncodingPanel encodingPanel = new EncodingPanel(project);
        statusBar.addWidget((StatusBarWidget)encodingPanel, "after Position");
        final LineSeparatorPanel lineSeparatorPanel = new LineSeparatorPanel(project);
        statusBar.addWidget((StatusBarWidget)lineSeparatorPanel, "before " + encodingPanel.ID());
        final ToggleReadOnlyAttributePanel readOnlyAttributePanel = new ToggleReadOnlyAttributePanel();
        InsertOverwritePanel insertOverwritePanel = null;
        if (!SystemInfo.isMac) {
            insertOverwritePanel = new InsertOverwritePanel(project);
            statusBar.addWidget((StatusBarWidget)insertOverwritePanel, "after Encoding");
            statusBar.addWidget((StatusBarWidget)readOnlyAttributePanel, "after InsertOverwrite");
        } else {
            statusBar.addWidget((StatusBarWidget)readOnlyAttributePanel, "after Encoding");
        }
        final InsertOverwritePanel finalInsertOverwritePanel = insertOverwritePanel;
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                statusBar.removeWidget(encodingPanel.ID());
                statusBar.removeWidget(lineSeparatorPanel.ID());
                statusBar.removeWidget(positionPanel.ID());
                statusBar.removeWidget(notificationArea.ID());
                statusBar.removeWidget(readOnlyAttributePanel.ID());
                if (finalInsertOverwritePanel != null) {
                    statusBar.removeWidget(finalInsertOverwritePanel.ID());
                }
                ((StatusBarEx)statusBar).removeCustomIndicationComponents();
            }
        });
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void dispose() {
        if (this.isTemporaryDisposed()) {
            super.dispose();
            return;
        }
        MouseGestureManager.getInstance().remove(this);
        WelcomeFrame.notifyFrameClosed(this);
        if (this.myRootPane != null) {
            this.myRootPane = null;
        }
        if (this.myFrameDecorator != null) {
            Disposer.dispose((Disposable)this.myFrameDecorator);
            this.myFrameDecorator = null;
        }
        FocusTrackback.release(this);
        super.dispose();
    }

    private boolean isTemporaryDisposed() {
        return this.myRootPane != null && this.myRootPane.getClientProperty("dispose.temporary") != null;
    }

    public void storeFullScreenStateIfNeeded() {
        if (this.myFrameDecorator != null) {
            this.storeFullScreenStateIfNeeded(this.myFrameDecorator.isInFullScreen());
        }
    }

    public void storeFullScreenStateIfNeeded(boolean state) {
        if (!WindowManager.getInstance().isFullScreenSupportedInCurrentOS()) {
            return;
        }
        if (this.myProject != null) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(FULL_SCREEN, String.valueOf(state));
        }
    }

    public static boolean shouldRestoreFullScreen(@Nullable Project project) {
        return WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && project != null && (SHOULD_OPEN_IN_FULL_SCREEN.get((UserDataHolder)project) == Boolean.TRUE || PropertiesComponent.getInstance((Project)project).getBoolean(FULL_SCREEN, false));
    }

    @Override
    public void paint(Graphics g) {
        UIUtil.applyRenderingHints((Graphics)g);
        super.paint(g);
    }

    public Rectangle suggestChildFrameBounds() {
        Rectangle b = this.getBounds();
        b.x += 100;
        b.width -= 200;
        b.y += 100;
        b.height -= 200;
        return b;
    }

    @Nullable
    public static Component findNearestModalComponent(@NotNull Component c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/IdeFrameImpl", "findNearestModalComponent"));
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (eachParent instanceof IdeFrame) {
                return eachParent;
            }
            if (!(eachParent instanceof JDialog) || !((JDialog)eachParent).isModal()) continue;
            return eachParent;
        }
        return null;
    }

    public final BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    @Override
    public boolean isInFullScreen() {
        return this.myFrameDecorator != null && this.myFrameDecorator.isInFullScreen();
    }

    @Override
    public void toggleFullScreen(boolean state) {
        IdeFrame[] frames;
        if (this.myFrameDecorator != null) {
            this.myFrameDecorator.toggleFullScreen(state);
        }
        for (IdeFrame frame : frames = WindowManager.getInstance().getAllProjectFrames()) {
            ((IdeFrameImpl)frame).updateBorder();
        }
    }

    @Override
    public void toFront() {
        super.toFront();
    }

    @Override
    public void toBack() {
        super.toBack();
    }

    static {
        xdgCurrentDesktop = System.getenv("XDG_CURRENT_DESKTOP");
    }

    private static final class Builder {
        public StringBuilder sb = new StringBuilder();

        private Builder() {
        }

        public Builder append(@Nullable String s) {
            if (s == null || s.length() == 0) {
                return this;
            }
            if (this.sb.length() > 0) {
                this.sb.append(" - ");
            }
            this.sb.append(s);
            return this;
        }
    }
}

