/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.containers.Queue;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker");
    private final boolean myIsRecursive;
    private final Queue<Pair<NewVirtualFile, FileAttributes>> myRefreshQueue;
    private final List<VFileEvent> myEvents;
    private volatile boolean myCancelled;
    private static Function<VirtualFile, Boolean> ourCancellingCondition = null;

    public RefreshWorker(@NotNull NewVirtualFile refreshRoot, boolean isRecursive) {
        if (refreshRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "<init>"));
        }
        this.myRefreshQueue = new Queue(100);
        this.myEvents = new ArrayList<VFileEvent>();
        this.myCancelled = false;
        this.myIsRecursive = isRecursive;
        this.myRefreshQueue.addLast((Object)Pair.create((Object)refreshRoot, (Object)null));
    }

    @NotNull
    public List<VFileEvent> getEvents() {
        List<VFileEvent> list = this.myEvents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "getEvents"));
        }
        return list;
    }

    public void cancel() {
        this.myCancelled = true;
    }

    public void scan() {
        NewVirtualFile root = (NewVirtualFile)((Pair)this.myRefreshQueue.pullFirst()).first;
        boolean rootDirty = root.isDirty();
        LogUtil.debug((Logger)LOG, (String)"root=%s dirty=%b", (Object[])new Object[]{root, rootDirty});
        if (!rootDirty) {
            return;
        }
        NewVirtualFileSystem fs = root.getFileSystem();
        FileAttributes rootAttributes = fs.getAttributes((VirtualFile)root);
        if (rootAttributes == null) {
            this.scheduleDeletion((VirtualFile)root);
            root.markClean();
            return;
        }
        if (rootAttributes.isDirectory()) {
            fs = PersistentFS.replaceWithNativeFS(fs);
        }
        this.myRefreshQueue.addLast((Object)Pair.create((Object)root, (Object)rootAttributes));
        try {
            this.processQueue(fs, PersistentFS.getInstance());
        }
        catch (RefreshCancelledException e) {
            LOG.debug("refresh cancelled");
        }
    }

    private void processQueue(NewVirtualFileSystem fs, PersistentFS persistence) throws RefreshCancelledException {
        TObjectHashingStrategy strategy = FilePathHashingStrategy.create((boolean)fs.isCaseSensitive());
        while (!this.myRefreshQueue.isEmpty()) {
            boolean upToDateHidden;
            boolean currentHidden;
            boolean upToDateWritable;
            boolean currentWritable;
            FileAttributes attributes;
            Pair pair = (Pair)this.myRefreshQueue.pullFirst();
            NewVirtualFile file = (NewVirtualFile)pair.first;
            boolean fileDirty = file.isDirty();
            LogUtil.debug((Logger)LOG, (String)"file=%s dirty=%b", (Object[])new Object[]{file, fileDirty});
            if (!fileDirty) continue;
            this.checkCancelled(file);
            FileAttributes fileAttributes = attributes = pair.second != null ? (FileAttributes)pair.second : fs.getAttributes((VirtualFile)file);
            if (attributes == null) {
                this.scheduleDeletion((VirtualFile)file);
                continue;
            }
            NewVirtualFile parent = file.getParent();
            if (parent != null && this.checkAndScheduleFileTypeChange((VirtualFile)parent, (VirtualFile)file, attributes)) {
                file.markClean();
                continue;
            }
            if (file.isDirectory()) {
                VirtualDirectoryImpl dir = (VirtualDirectoryImpl)file;
                boolean fullSync = dir.allChildrenLoaded();
                if (fullSync) {
                    Object[] currentNames = persistence.list((VirtualFile)file);
                    Object[] upToDateNames = VfsUtil.filterNames((String[])fs.list((VirtualFile)file));
                    THashSet newNames = ContainerUtil.newTroveSet((TObjectHashingStrategy)strategy, (Object[])upToDateNames);
                    ContainerUtil.removeAll((Collection)newNames, (Object[])currentNames);
                    THashSet deletedNames = ContainerUtil.newTroveSet((TObjectHashingStrategy)strategy, (Object[])currentNames);
                    ContainerUtil.removeAll((Collection)deletedNames, (Object[])upToDateNames);
                    OpenTHashSet actualNames = null;
                    if (!fs.isCaseSensitive()) {
                        actualNames = new OpenTHashSet(strategy, upToDateNames);
                    }
                    LogUtil.debug((Logger)LOG, (String)"current=%s +%s -%s", (Object[])new Object[]{currentNames, newNames, deletedNames});
                    for (String name : deletedNames) {
                        this.scheduleDeletion((VirtualFile)file.findChild(name));
                    }
                    for (String name : newNames) {
                        this.checkCancelled(file);
                        FileAttributes childAttributes = fs.getAttributes((VirtualFile)new FakeVirtualFile((VirtualFile)file, name));
                        if (childAttributes != null) {
                            this.scheduleCreation((VirtualFile)file, name, childAttributes.isDirectory(), false);
                            continue;
                        }
                        LOG.warn("[+] fs=" + fs + " dir=" + file + " name=" + name);
                    }
                    for (VirtualFile child : file.getChildren()) {
                        this.checkCancelled(file);
                        if (deletedNames.contains(child.getName())) continue;
                        FileAttributes childAttributes = fs.getAttributes(child);
                        if (childAttributes != null) {
                            this.checkAndScheduleChildRefresh((VirtualFile)file, child, childAttributes);
                            this.checkAndScheduleFileNameChange((OpenTHashSet<String>)actualNames, child);
                            continue;
                        }
                        LOG.warn("[x] fs=" + fs + " dir=" + file + " name=" + child.getName());
                        this.scheduleDeletion(child);
                    }
                } else {
                    Collection cachedChildren = file.getCachedChildren();
                    OpenTHashSet actualNames = null;
                    if (!fs.isCaseSensitive()) {
                        actualNames = new OpenTHashSet(strategy, (Object[])VfsUtil.filterNames((String[])fs.list((VirtualFile)file)));
                    }
                    LogUtil.debug((Logger)LOG, (String)"cached=%s actual=%s", (Object[])new Object[]{cachedChildren, actualNames});
                    for (VirtualFile child : cachedChildren) {
                        this.checkCancelled(file);
                        FileAttributes childAttributes = fs.getAttributes(child);
                        if (childAttributes != null) {
                            this.checkAndScheduleChildRefresh((VirtualFile)file, child, childAttributes);
                            this.checkAndScheduleFileNameChange((OpenTHashSet<String>)actualNames, child);
                            continue;
                        }
                        this.scheduleDeletion(child);
                    }
                    List<String> names = dir.getSuspiciousNames();
                    LogUtil.debug((Logger)LOG, (String)"suspicious=%s", (Object[])new Object[]{names});
                    for (String name : names) {
                        FakeVirtualFile fake;
                        FileAttributes childAttributes;
                        this.checkCancelled(file);
                        if (name.isEmpty() || (childAttributes = fs.getAttributes((VirtualFile)(fake = new FakeVirtualFile((VirtualFile)file, name)))) == null) continue;
                        this.scheduleCreation((VirtualFile)file, name, childAttributes.isDirectory(), false);
                    }
                }
            } else {
                long currentTimestamp = persistence.getTimeStamp((VirtualFile)file);
                long upToDateTimestamp = attributes.lastModified;
                long currentLength = persistence.getLength((VirtualFile)file);
                long upToDateLength = attributes.length;
                if (currentTimestamp != upToDateTimestamp || currentLength != upToDateLength) {
                    this.scheduleUpdateContent((VirtualFile)file);
                }
            }
            if ((currentWritable = persistence.isWritable((VirtualFile)file)) != (upToDateWritable = attributes.isWritable())) {
                this.scheduleAttributeChange((VirtualFile)file, "writable", currentWritable, upToDateWritable);
            }
            if (SystemInfo.isWindows && (currentHidden = file.is(VFileProperty.HIDDEN)) != (upToDateHidden = attributes.isHidden())) {
                this.scheduleAttributeChange((VirtualFile)file, VirtualFile.PROP_HIDDEN, currentHidden, upToDateHidden);
            }
            if (attributes.isSymLink()) {
                String upToDateVfsTarget;
                String currentTarget = file.getCanonicalPath();
                String upToDateTarget = fs.resolveSymLink((VirtualFile)file);
                String string = upToDateVfsTarget = upToDateTarget != null ? FileUtil.toSystemIndependentName((String)upToDateTarget) : null;
                if (!Comparing.equal((String)currentTarget, (String)upToDateVfsTarget)) {
                    this.scheduleAttributeChange((VirtualFile)file, "symlink", currentTarget, upToDateVfsTarget);
                }
            }
            if (!this.myIsRecursive && file.isDirectory()) continue;
            file.markClean();
        }
    }

    private void checkAndScheduleFileNameChange(@Nullable OpenTHashSet<String> actualNames, VirtualFile child) {
        String currentName;
        String actualName;
        if (actualNames != null && (actualName = (String)actualNames.get((Object)(currentName = child.getName()))) != null && !currentName.equals(actualName)) {
            this.scheduleAttributeChange(child, "name", currentName, actualName);
        }
    }

    private void checkCancelled(@NotNull NewVirtualFile stopAt) {
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkCancelled"));
        }
        if (this.myCancelled || ourCancellingCondition != null && ((Boolean)ourCancellingCondition.fun((Object)stopAt)).booleanValue()) {
            RefreshWorker.forceMarkDirty(stopAt);
            while (!this.myRefreshQueue.isEmpty()) {
                NewVirtualFile next = (NewVirtualFile)((Pair)this.myRefreshQueue.pullFirst()).first;
                RefreshWorker.forceMarkDirty(next);
            }
            throw new RefreshCancelledException();
        }
    }

    private static void forceMarkDirty(NewVirtualFile file) {
        file.markClean();
        file.markDirty();
    }

    private void checkAndScheduleChildRefresh(@NotNull VirtualFile parent, @NotNull VirtualFile child, @NotNull FileAttributes childAttributes) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleChildRefresh"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleChildRefresh"));
        }
        if (childAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleChildRefresh"));
        }
        if (!this.checkAndScheduleFileTypeChange(parent, child, childAttributes)) {
            boolean upToDateIsDirectory = childAttributes.isDirectory();
            if (this.myIsRecursive || !upToDateIsDirectory) {
                this.myRefreshQueue.addLast((Object)Pair.create((Object)((NewVirtualFile)child), (Object)childAttributes));
            }
        }
    }

    private boolean checkAndScheduleFileTypeChange(@NotNull VirtualFile parent, @NotNull VirtualFile child, @NotNull FileAttributes childAttributes) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleFileTypeChange"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleFileTypeChange"));
        }
        if (childAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleFileTypeChange"));
        }
        boolean currentIsDirectory = child.isDirectory();
        boolean currentIsSymlink = child.is(VFileProperty.SYMLINK);
        boolean currentIsSpecial = child.is(VFileProperty.SPECIAL);
        boolean upToDateIsDirectory = childAttributes.isDirectory();
        boolean upToDateIsSymlink = childAttributes.isSymLink();
        boolean upToDateIsSpecial = childAttributes.isSpecial();
        if (currentIsDirectory != upToDateIsDirectory || currentIsSymlink != upToDateIsSymlink || currentIsSpecial != upToDateIsSpecial) {
            this.scheduleDeletion(child);
            this.scheduleCreation(parent, child.getName(), upToDateIsDirectory, true);
            return true;
        }
        return false;
    }

    private void scheduleAttributeChange(@NotNull VirtualFile file, @NotNull String property, Object current, Object upToDate) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleAttributeChange"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleAttributeChange"));
        }
        LogUtil.debug((Logger)LOG, (String)"update '%s' file=%s", (Object[])new Object[]{property, file});
        this.myEvents.add((VFileEvent)new VFilePropertyChangeEvent(null, file, property, current, upToDate, true));
    }

    private void scheduleUpdateContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleUpdateContent"));
        }
        LogUtil.debug((Logger)LOG, (String)"update file=%s", (Object[])new Object[]{file});
        this.myEvents.add((VFileEvent)new VFileContentChangeEvent(null, file, file.getModificationStamp(), -1L, true));
    }

    private void scheduleCreation(@NotNull VirtualFile parent, @NotNull String childName, boolean isDirectory, boolean isReCreation) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleCreation"));
        }
        if (childName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleCreation"));
        }
        LogUtil.debug((Logger)LOG, (String)"create parent=%s name=%s dir=%b", (Object[])new Object[]{parent, childName, isDirectory});
        this.myEvents.add((VFileEvent)new VFileCreateEvent(null, parent, childName, isDirectory, true, isReCreation));
    }

    private void scheduleDeletion(@Nullable VirtualFile file) {
        if (file != null) {
            LogUtil.debug((Logger)LOG, (String)"delete file=%s", (Object[])new Object[]{file});
            this.myEvents.add((VFileEvent)new VFileDeleteEvent(null, file, true));
        }
    }

    public static void setCancellingCondition(@Nullable Function<VirtualFile, Boolean> condition) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourCancellingCondition = condition;
    }

    private static class RefreshCancelledException
    extends RuntimeException {
        private RefreshCancelledException() {
        }
    }
}

