/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.text.StringFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileSystemEntry
extends NewVirtualFile {
    public static final VirtualFileSystemEntry[] EMPTY_ARRAY = new VirtualFileSystemEntry[0];
    protected static final PersistentFS ourPersistence = PersistentFS.getInstance();
    private static final Key<String> SYMLINK_TARGET = Key.create((String)"local.vfs.symlink.target");
    private static final int IS_WRITABLE_FLAG = 0x1000000;
    private static final int IS_HIDDEN_FLAG = 0x2000000;
    private static final int INDEXED_FLAG = 0x4000000;
    static final int CHILDREN_CACHED = 0x8000000;
    private static final int DIRTY_FLAG = 0x10000000;
    private static final int IS_SYMLINK_FLAG = 0x20000000;
    private static final int HAS_SYMLINK_FLAG = 0x40000000;
    private static final int IS_SPECIAL_FLAG = Integer.MIN_VALUE;
    static final int SYSTEM_LINE_SEPARATOR_DETECTED = 0x8000000;
    private static final int ALL_FLAGS_MASK = -16777216;
    private volatile int myNameId;
    private volatile VirtualDirectoryImpl myParent;
    private volatile int myFlags;
    private volatile int myId;

    public VirtualFileSystemEntry(int nameId, VirtualDirectoryImpl parent, int id, @PersistentFS.Attributes int attributes) {
        this.myParent = parent;
        this.myId = id;
        this.myNameId = nameId;
        if (parent != null && parent != VirtualDirectoryImpl.NULL_VIRTUAL_FILE) {
            this.setFlagInt(0x20000000, PersistentFS.isSymLink(attributes));
            this.setFlagInt(Integer.MIN_VALUE, PersistentFS.isSpecialFile(attributes));
            this.updateLinkStatus();
        }
        this.setFlagInt(0x1000000, PersistentFS.isWritable(attributes));
        this.setFlagInt(0x2000000, PersistentFS.isHidden(attributes));
        this.setModificationStamp(LocalTimeCounter.currentTime());
    }

    private void updateLinkStatus() {
        boolean isSymLink = this.is(VFileProperty.SYMLINK);
        if (isSymLink) {
            String target = this.myParent.getFileSystem().resolveSymLink((VirtualFile)this);
            this.setLinkTarget(target != null ? FileUtil.toSystemIndependentName((String)target) : null);
        }
        this.setFlagInt(0x40000000, isSymLink || this.myParent.getFlagInt(0x40000000));
    }

    @NotNull
    public String getName() {
        String string = FileNameCache.getVFileName(this.myNameId);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "getName"));
        }
        return string;
    }

    public int compareNameTo(@NotNull String name, boolean ignoreCase) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "compareNameTo"));
        }
        return FileNameCache.compareNameTo(this.myNameId, name, ignoreCase);
    }

    protected static int compareNames(@NotNull String name1, @NotNull String name2, boolean ignoreCase) {
        if (name1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "compareNames"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "compareNames"));
        }
        return VirtualFileSystemEntry.compareNames(name1, name2, ignoreCase, 0);
    }

    static int compareNames(@NotNull String name1, @NotNull String name2, boolean ignoreCase, int offset2) {
        if (name1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "compareNames"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "compareNames"));
        }
        int d = name1.length() - name2.length() + offset2;
        if (d != 0) {
            return d;
        }
        for (int i = 0; i < name1.length(); ++i) {
            d = StringUtil.compare((char)name1.charAt(i), (char)name2.charAt(i + offset2), (boolean)ignoreCase);
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    public VirtualFileSystemEntry getParent() {
        return this.myParent;
    }

    public boolean isDirty() {
        return (this.myFlags & 0x10000000) != 0;
    }

    public long getModificationStamp() {
        return this.myFlags & 0xFFFFFF;
    }

    public synchronized void setModificationStamp(long modificationStamp) {
        this.myFlags = this.myFlags & 0xFF000000 | (int)modificationStamp & 0xFFFFFF;
    }

    boolean getFlagInt(int mask) {
        assert ((mask & 0xFFFFFF) == 0) : "Unexpected flag";
        return (this.myFlags & mask) != 0;
    }

    synchronized void setFlagInt(int mask, boolean value) {
        assert ((mask & 0xFFFFFF) == 0) : "Unexpected flag";
        this.myFlags = value ? (this.myFlags |= mask) : (this.myFlags &= ~mask);
    }

    public boolean isFileIndexed() {
        return this.getFlagInt(0x4000000);
    }

    public void setFileIndexed(boolean indexed) {
        this.setFlagInt(0x4000000, indexed);
    }

    public void markClean() {
        this.setFlagInt(0x10000000, false);
    }

    public void markDirty() {
        if (!this.isDirty()) {
            this.markDirtyInternal();
            VirtualDirectoryImpl parent = this.myParent;
            if (parent != null) {
                parent.markDirty();
            }
        }
    }

    protected void markDirtyInternal() {
        this.setFlagInt(0x10000000, true);
    }

    public void markDirtyRecursively() {
        this.markDirty();
        for (VirtualFile file : this.getCachedChildren()) {
            ((NewVirtualFile)file).markDirtyRecursively();
        }
    }

    protected char[] appendPathOnFileSystem(int accumulatedPathLength, int[] positionRef) {
        return FileNameCache.appendPathOnFileSystem(this.myNameId, this.myParent, accumulatedPathLength, positionRef);
    }

    protected static int copyString(@NotNull char[] chars, int pos, @NotNull String s) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "copyString"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "copyString"));
        }
        int length = s.length();
        s.getChars(0, length, chars, pos);
        return pos + length;
    }

    @NotNull
    public String getUrl() {
        String protocol = this.getFileSystem().getProtocol();
        int prefixLen = protocol.length() + "://".length();
        int[] pos = new int[]{prefixLen};
        char[] chars = this.appendPathOnFileSystem(prefixLen, pos);
        VirtualFileSystemEntry.copyString(chars, VirtualFileSystemEntry.copyString(chars, 0, protocol), "://");
        String string = chars.length == pos[0] ? StringFactory.createShared((char[])chars) : new String(chars, 0, pos[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "getUrl"));
        }
        return string;
    }

    @NotNull
    public String getPath() {
        int[] pos = new int[]{0};
        char[] chars = this.appendPathOnFileSystem(0, pos);
        String string = chars.length == pos[0] ? StringFactory.createShared((char[])chars) : new String(chars, 0, pos[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "getPath"));
        }
        return string;
    }

    public void delete(Object requestor) throws IOException {
        ourPersistence.deleteFile(requestor, (VirtualFile)this);
    }

    public void rename(Object requestor, @NotNull @NonNls String newName) throws IOException {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "rename"));
        }
        if (this.getName().equals(newName)) {
            return;
        }
        if (!VirtualFileSystemEntry.isValidName((String)newName)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{newName}));
        }
        ourPersistence.renameFile(requestor, (VirtualFile)this, newName);
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "createChildData"));
        }
        VirtualFileSystemEntry.validateName(name);
        VirtualFile virtualFile = ourPersistence.createChildFile(requestor, (VirtualFile)this, name);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "createChildData"));
        }
        return virtualFile;
    }

    public boolean isWritable() {
        return this.getFlagInt(0x1000000);
    }

    public void setWritable(boolean writable) throws IOException {
        ourPersistence.setWritable((VirtualFile)this, writable);
    }

    public long getTimeStamp() {
        return ourPersistence.getTimeStamp((VirtualFile)this);
    }

    public void setTimeStamp(long time) throws IOException {
        ourPersistence.setTimeStamp((VirtualFile)this, time);
    }

    public long getLength() {
        return ourPersistence.getLength((VirtualFile)this);
    }

    public VirtualFile copy(final Object requestor, final @NotNull VirtualFile newParent, final @NotNull String copyName) throws IOException {
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "copy"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "copy"));
        }
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message((String)"file.copy.error", (Object[])new Object[]{newParent.getPresentableUrl()}));
        }
        if (!newParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"file.copy.target.must.be.directory", (Object[])new Object[0]));
        }
        return EncodingRegistry.doActionAndRestoreEncoding((VirtualFile)this, (ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                return ourPersistence.copyFile(requestor, (VirtualFile)VirtualFileSystemEntry.this, newParent, copyName);
            }
        });
    }

    public void move(final Object requestor, final @NotNull VirtualFile newParent) throws IOException {
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "move"));
        }
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message((String)"file.move.error", (Object[])new Object[]{newParent.getPresentableUrl()}));
        }
        EncodingRegistry.doActionAndRestoreEncoding((VirtualFile)this, (ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                ourPersistence.moveFile(requestor, (VirtualFile)VirtualFileSystemEntry.this, newParent);
                return VirtualFileSystemEntry.this;
            }
        });
    }

    public int getId() {
        return this.myId;
    }

    public int hashCode() {
        int id = this.myId;
        return id >= 0 ? id : -id;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, String name) throws IOException {
        VirtualFileSystemEntry.validateName(name);
        VirtualFile virtualFile = ourPersistence.createChildDirectory(requestor, (VirtualFile)this, name);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "createChildDirectory"));
        }
        return virtualFile;
    }

    private static void validateName(String name) throws IOException {
        if (name == null || name.isEmpty()) {
            throw new IOException("File name cannot be empty");
        }
        if (name.indexOf(47) >= 0 || name.indexOf(File.separatorChar) >= 0) {
            throw new IOException("File name cannot contain file path separators: '" + name + "'");
        }
    }

    public boolean exists() {
        return ourPersistence.exists((VirtualFile)this);
    }

    public boolean isValid() {
        return this.exists();
    }

    public String toString() {
        return this.getUrl();
    }

    public void setNewName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "setNewName"));
        }
        if (newName.isEmpty()) {
            throw new IllegalArgumentException("Name of the virtual file cannot be set to empty string");
        }
        this.myParent.removeChild((VirtualFile)this);
        this.myNameId = FileNameCache.storeName(newName);
        this.myParent.addChild(this);
    }

    public void setParent(@NotNull VirtualFile newParent) {
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "setParent"));
        }
        this.myParent.removeChild((VirtualFile)this);
        this.myParent = (VirtualDirectoryImpl)newParent;
        this.myParent.addChild(this);
        this.updateLinkStatus();
    }

    public boolean isInLocalFileSystem() {
        return this.getFileSystem() instanceof LocalFileSystem;
    }

    public void invalidate() {
        this.myId = -Math.abs(this.myId);
    }

    public Charset getCharset() {
        return this.isCharsetSet() ? super.getCharset() : this.computeCharset();
    }

    private Charset computeCharset() {
        Charset charset;
        if (this.isDirectory()) {
            Charset configured = EncodingManager.getInstance().getEncoding((VirtualFile)this, true);
            charset = configured == null ? Charset.defaultCharset() : configured;
            this.setCharset(charset);
        } else if (SingleRootFileViewProvider.isTooLargeForContentLoading((VirtualFile)this)) {
            charset = super.getCharset();
        } else {
            try {
                byte[] content;
                try {
                    content = this.contentsToByteArray();
                }
                catch (FileNotFoundException e) {
                    return super.getCharset();
                }
                charset = LoadTextUtil.detectCharsetAndSetBOM((VirtualFile)this, content);
            }
            catch (FileTooBigException e) {
                return super.getCharset();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return charset;
    }

    public String getPresentableName() {
        if (UISettings.getInstance().HIDE_KNOWN_EXTENSION_IN_TABS && !this.isDirectory()) {
            String nameWithoutExtension = this.getNameWithoutExtension();
            return nameWithoutExtension.isEmpty() ? this.getName() : nameWithoutExtension;
        }
        return this.getName();
    }

    public boolean is(@NotNull VFileProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry", "is"));
        }
        if (property == VFileProperty.SPECIAL) {
            return this.getFlagInt(Integer.MIN_VALUE);
        }
        if (property == VFileProperty.HIDDEN) {
            return this.getFlagInt(0x2000000);
        }
        if (property == VFileProperty.SYMLINK) {
            return this.getFlagInt(0x20000000);
        }
        return super.is(property);
    }

    public void updateProperty(String property, boolean value) {
        if (property == "writable") {
            this.setFlagInt(0x1000000, value);
        }
        if (property == PROP_HIDDEN) {
            this.setFlagInt(0x2000000, value);
        }
    }

    public void setLinkTarget(@Nullable String target) {
        this.putUserData(SYMLINK_TARGET, target);
    }

    public String getCanonicalPath() {
        if (this.getFlagInt(0x40000000)) {
            if (this.is(VFileProperty.SYMLINK)) {
                return (String)this.getUserData(SYMLINK_TARGET);
            }
            VirtualDirectoryImpl parent = this.myParent;
            if (parent != null) {
                return parent.getCanonicalPath() + "/" + this.getName();
            }
            return this.getName();
        }
        return this.getPath();
    }

    public NewVirtualFile getCanonicalFile() {
        if (this.getFlagInt(0x40000000)) {
            String path = this.getCanonicalPath();
            return path != null ? (NewVirtualFile)this.getFileSystem().findFileByPath(path) : null;
        }
        return this;
    }
}

