/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.SubList;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualDirectoryImpl
extends VirtualFileSystemEntry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl");
    public static boolean CHECK = ApplicationManager.getApplication().isUnitTestMode();
    static final VirtualDirectoryImpl NULL_VIRTUAL_FILE = new VirtualDirectoryImpl(FileNameCache.storeName("*?;%NULL"), null, (NewVirtualFileSystem)LocalFileSystem.getInstance(), -42, 0){

        @Override
        public String toString() {
            return "NULL";
        }
    };
    private final NewVirtualFileSystem myFS;
    private VirtualFileSystemEntry[] myChildren;
    private static final Comparator CASE_SENSITIVE = new Comparator(){

        @Override
        public int compareFileNameTo(@NotNull String myName, @NotNull VirtualFileSystemEntry file) {
            if (myName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl$2", "compareFileNameTo"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl$2", "compareFileNameTo"));
            }
            return -file.compareNameTo(myName, false);
        }
    };
    private static final Comparator CASE_INSENSITIVE = new Comparator(){

        @Override
        public int compareFileNameTo(@NotNull String myName, @NotNull VirtualFileSystemEntry file) {
            if (myName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl$3", "compareFileNameTo"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl$3", "compareFileNameTo"));
            }
            return -file.compareNameTo(myName, true);
        }
    };
    private static final boolean IS_UNDER_TEAMCITY = System.getProperty("bootstrap.testcases") != null;
    private static final boolean SHOULD_PERFORM_ACCESS_CHECK = System.getenv("NO_FS_ROOTS_ACCESS_CHECK") == null;
    private static final Collection<String> ourAdditionalRoots = new THashSet();
    private static boolean insideGettingRoots;
    private static final Function<VirtualFileSystemEntry, String> verboseToString;

    public VirtualDirectoryImpl(@NonNls int nameId, @Nullable VirtualDirectoryImpl parent, @NotNull NewVirtualFileSystem fs, int id, @PersistentFS.Attributes int attributes) {
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "<init>"));
        }
        super(nameId, parent, id, attributes);
        this.myChildren = EMPTY_ARRAY;
        this.myFS = fs;
    }

    @NotNull
    public NewVirtualFileSystem getFileSystem() {
        NewVirtualFileSystem newVirtualFileSystem = this.myFS;
        if (newVirtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "getFileSystem"));
        }
        return newVirtualFileSystem;
    }

    @Nullable
    private VirtualFileSystemEntry findChild(@NotNull String name, boolean doRefresh, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "findChild"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "findChild"));
        }
        boolean ignoreCase = !delegate.isCaseSensitive();
        Comparator comparator = VirtualDirectoryImpl.getComparator(ignoreCase);
        VirtualFileSystemEntry result = this.doFindChild(name, ensureCanonicalName, delegate, comparator);
        if (result == NULL_VIRTUAL_FILE) {
            result = doRefresh ? this.createAndFindChildWithEventFire(name, delegate) : null;
        } else if (result != null && doRefresh && delegate.isDirectory((VirtualFile)result) != result.isDirectory()) {
            RefreshQueue.getInstance().refresh(false, false, null, new VirtualFile[]{result});
            result = this.findChild(name, false, ensureCanonicalName, delegate);
        }
        if (result == null) {
            this.addToAdoptedChildren(!delegate.isCaseSensitive(), name, comparator);
        }
        return result;
    }

    private synchronized void addToAdoptedChildren(boolean ignoreCase, @NotNull String name, @NotNull Comparator comparator) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "addToAdoptedChildren"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "addToAdoptedChildren"));
        }
        long r = VirtualDirectoryImpl.findIndexInBoth(this.myChildren, name, comparator);
        int indexInReal = (int)(r >> 32);
        int indexInAdopted = (int)r;
        if (indexInAdopted >= 0) {
            return;
        }
        if (!this.allChildrenLoaded()) {
            this.insertChildAt(new AdoptedChild(name), indexInAdopted);
        }
        if (indexInReal >= 0) {
            this.removeFromArray(indexInReal);
        }
        this.assertConsistency(this.myChildren, ignoreCase, name);
    }

    @Nullable
    private synchronized VirtualFileSystemEntry doFindChildInArray(@NotNull String name, @NotNull Comparator comparator) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "doFindChildInArray"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "doFindChildInArray"));
        }
        VirtualFileSystemEntry[] array = this.myChildren;
        long r = VirtualDirectoryImpl.findIndexInBoth(array, name, comparator);
        int indexInReal = (int)(r >> 32);
        int indexInAdopted = (int)r;
        if (indexInAdopted >= 0) {
            return NULL_VIRTUAL_FILE;
        }
        if (indexInReal >= 0) {
            return array[indexInReal];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFileSystemEntry doFindChild(@NotNull String name, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate, @NotNull Comparator comparator) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "doFindChild"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "doFindChild"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "doFindChild"));
        }
        if (name.isEmpty()) {
            return null;
        }
        VirtualFileSystemEntry found = this.doFindChildInArray(name, comparator);
        if (found != null) {
            return found;
        }
        if (this.allChildrenLoaded()) {
            return NULL_VIRTUAL_FILE;
        }
        if (ensureCanonicalName) {
            if ((name = UriUtil.trimTrailingSlashes(UriUtil.trimLeadingSlashes(FileUtilRt.toSystemIndependentName((String)name)))).indexOf(47) != -1) {
                return null;
            }
            FakeVirtualFile fake = new FakeVirtualFile((VirtualFile)this, name);
            if ((name = delegate.getCanonicallyCasedName((VirtualFile)fake)).isEmpty()) {
                return null;
            }
        }
        VirtualDirectoryImpl virtualDirectoryImpl = this;
        synchronized (virtualDirectoryImpl) {
            VirtualFileSystemEntry[] array = this.myChildren;
            long r = VirtualDirectoryImpl.findIndexInBoth(array, name, comparator);
            int indexInReal = (int)(r >> 32);
            int indexInAdopted = (int)r;
            if (indexInAdopted >= 0) {
                return NULL_VIRTUAL_FILE;
            }
            if (indexInReal >= 0) {
                return array[indexInReal];
            }
            int id = ourPersistence.getId((VirtualFile)this, name, delegate);
            if (id <= 0) {
                return null;
            }
            VirtualFileSystemEntry child = this.createChild(FileNameCache.storeName(name), id, delegate);
            VirtualFileSystemEntry[] after = this.myChildren;
            if (after != array) {
                this.addChild(child);
            } else {
                this.insertChildAt(child, indexInReal);
                this.assertConsistency(this.myChildren, !delegate.isCaseSensitive(), name);
            }
            return child;
        }
    }

    @NotNull
    private static Comparator getComparator(boolean ignoreCase) {
        Comparator comparator = ignoreCase ? CASE_INSENSITIVE : CASE_SENSITIVE;
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "getComparator"));
        }
        return comparator;
    }

    private synchronized VirtualFileSystemEntry[] getArraySafely() {
        return this.myChildren;
    }

    @NotNull
    public VirtualFileSystemEntry createChild(String name, int id, @NotNull NewVirtualFileSystem delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "createChild"));
        }
        VirtualFileSystemEntry virtualFileSystemEntry = this.createChild(FileNameCache.storeName(name), id, delegate);
        if (virtualFileSystemEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "createChild"));
        }
        return virtualFileSystemEntry;
    }

    @NotNull
    private VirtualFileSystemEntry createChild(int nameId, int id, @NotNull NewVirtualFileSystem delegate) {
        VirtualFileSystemEntry child;
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "createChild"));
        }
        int attributes = ourPersistence.getFileAttributes(id);
        if (PersistentFS.isDirectory(attributes)) {
            child = new VirtualDirectoryImpl(nameId, this, delegate, id, attributes);
        } else {
            child = new VirtualFileImpl(nameId, this, id, attributes);
            VirtualDirectoryImpl.assertAccessInTests(child, delegate);
        }
        if (delegate.markNewFilesAsDirty()) {
            child.markDirty();
        }
        VirtualFileSystemEntry virtualFileSystemEntry = child;
        if (virtualFileSystemEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "createChild"));
        }
        return virtualFileSystemEntry;
    }

    public static void allowRootAccess(String ... roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "allowRootAccess"));
        }
        for (String root : roots) {
            ourAdditionalRoots.add(FileUtil.toSystemIndependentName((String)root));
        }
    }

    public static void disallowRootAccess(String ... roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "disallowRootAccess"));
        }
        for (String root : roots) {
            ourAdditionalRoots.remove(FileUtil.toSystemIndependentName((String)root));
        }
    }

    private static void assertAccessInTests(@NotNull VirtualFileSystemEntry child, @NotNull NewVirtualFileSystem delegate) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "assertAccessInTests"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "assertAccessInTests"));
        }
        Application application = ApplicationManager.getApplication();
        if (IS_UNDER_TEAMCITY && SHOULD_PERFORM_ACCESS_CHECK && application.isUnitTestMode() && application instanceof ApplicationImpl && ((ApplicationImpl)application).isComponentsCreated()) {
            boolean isUnder;
            if (delegate != LocalFileSystem.getInstance() && delegate != JarFileSystem.getInstance()) {
                return;
            }
            if (child.getParent() == null || child.getParent().getParent() == null) {
                return;
            }
            Set<String> allowed = VirtualDirectoryImpl.allowedRoots();
            boolean bl = isUnder = allowed == null;
            if (!isUnder) {
                String childPath = child.getPath();
                if (delegate == JarFileSystem.getInstance()) {
                    VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar((VirtualFile)child);
                    assert (local != null) : child;
                    childPath = local.getPath();
                }
                for (String root : allowed) {
                    String rootLocalPath;
                    if (FileUtil.startsWith((String)childPath, (String)root)) {
                        isUnder = true;
                        break;
                    }
                    if (!root.startsWith("jar://") || !(isUnder = FileUtil.startsWith((String)childPath, (String)(rootLocalPath = FileUtil.toSystemIndependentName((String)PathUtil.toPresentableUrl((String)root)))))) continue;
                    break;
                }
            }
            assert (isUnder || allowed.isEmpty()) : "File accessed outside allowed roots: " + (Object)((Object)child) + ";\nAllowed roots: " + new ArrayList<String>(allowed);
        }
    }

    @Nullable
    private static Set<String> allowedRoots() {
        if (insideGettingRoots) {
            return null;
        }
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length == 0) {
            return null;
        }
        THashSet allowed = new THashSet();
        allowed.add(FileUtil.toSystemIndependentName((String)PathManager.getHomePath()));
        try {
            URL outUrl = Application.class.getResource("/");
            String output = new File(outUrl.toURI()).getParentFile().getParentFile().getPath();
            allowed.add(FileUtil.toSystemIndependentName((String)output));
        }
        catch (URISyntaxException ignored) {
            // empty catch block
        }
        allowed.add(FileUtil.toSystemIndependentName((String)SystemProperties.getJavaHome()));
        allowed.add(FileUtil.toSystemIndependentName((String)new File(FileUtil.getTempDirectory()).getParent()));
        allowed.add(FileUtil.toSystemIndependentName((String)System.getProperty("java.io.tmpdir")));
        allowed.add(FileUtil.toSystemIndependentName((String)SystemProperties.getUserHome()));
        for (Project project : openProjects) {
            if (!project.isInitialized()) {
                return null;
            }
            for (VirtualFile root : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                allowed.add(root.getPath());
            }
            for (VirtualFile root : VirtualDirectoryImpl.getAllRoots(project)) {
                allowed.add(StringUtil.trimEnd((String)root.getPath(), (String)"!/"));
            }
            String location = project.getBasePath();
            assert (location != null) : project;
            allowed.add(FileUtil.toSystemIndependentName((String)location));
        }
        allowed.addAll(ourAdditionalRoots);
        return allowed;
    }

    private static VirtualFile[] getAllRoots(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "getAllRoots"));
        }
        insideGettingRoots = true;
        THashSet roots = new THashSet();
        OrderEnumerator enumerator = ProjectRootManager.getInstance((Project)project).orderEntries();
        ContainerUtil.addAll((Collection)roots, (Object[])enumerator.getClassesRoots());
        ContainerUtil.addAll((Collection)roots, (Object[])enumerator.getSourceRoots());
        insideGettingRoots = false;
        return VfsUtilCore.toVirtualFileArray((Collection)roots);
    }

    @Nullable
    private VirtualFileSystemEntry createAndFindChildWithEventFire(@NotNull String name, @NotNull NewVirtualFileSystem delegate) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "createAndFindChildWithEventFire"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "createAndFindChildWithEventFire"));
        }
        FakeVirtualFile fake = new FakeVirtualFile((VirtualFile)this, name);
        FileAttributes attributes = delegate.getAttributes((VirtualFile)fake);
        if (attributes == null) {
            return null;
        }
        String realName = delegate.getCanonicallyCasedName((VirtualFile)fake);
        VFileCreateEvent event = new VFileCreateEvent(null, (VirtualFile)this, realName, attributes.isDirectory(), true);
        RefreshQueue.getInstance().processSingleEvent((VFileEvent)event);
        return this.findChild(realName);
    }

    @Nullable
    public NewVirtualFile refreshAndFindChild(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "refreshAndFindChild"));
        }
        return this.findChild(name, true, true, this.getFileSystem());
    }

    private static int findIndexInOneHalf(VirtualFileSystemEntry[] array, int start, int end, final boolean isAdopted, @NotNull String name, final @NotNull Comparator comparator) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "findIndexInOneHalf"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "findIndexInOneHalf"));
        }
        return VirtualDirectoryImpl.binSearch(array, start, end, name, new Comparator(){

            @Override
            public int compareFileNameTo(@NotNull String myName, @NotNull VirtualFileSystemEntry file) {
                if (myName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl$4", "compareFileNameTo"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl$4", "compareFileNameTo"));
                }
                if (isAdopted && !VirtualDirectoryImpl.isAdoptedChild(file)) {
                    return 1;
                }
                if (!isAdopted && VirtualDirectoryImpl.isAdoptedChild(file)) {
                    return -1;
                }
                return comparator.compareFileNameTo(myName, file);
            }
        });
    }

    private static long findIndexInBoth(@NotNull VirtualFileSystemEntry[] array, @NotNull String name, @NotNull Comparator comparator) {
        int newEnd;
        boolean endInAdopted;
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "findIndexInBoth"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "findIndexInBoth"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "findIndexInBoth"));
        }
        int high = array.length - 1;
        if (high == -1) {
            return VirtualDirectoryImpl.pack(-1, -1);
        }
        int low = 0;
        boolean startInAdopted = VirtualDirectoryImpl.isAdoptedChild(array[low]);
        if (startInAdopted == (endInAdopted = VirtualDirectoryImpl.isAdoptedChild(array[high]))) {
            int index = VirtualDirectoryImpl.findIndexInOneHalf(array, low, high + 1, startInAdopted, name, comparator);
            int otherIndex = startInAdopted ? -1 : -array.length - 1;
            return startInAdopted ? VirtualDirectoryImpl.pack(otherIndex, index) : VirtualDirectoryImpl.pack(index, otherIndex);
        }
        boolean adopted = false;
        int cmp = -1;
        int mid = -1;
        int foundIndex = -1;
        while (low <= high) {
            mid = low + high >>> 1;
            VirtualFileSystemEntry file = array[mid];
            cmp = comparator.compareFileNameTo(name, file);
            adopted = VirtualDirectoryImpl.isAdoptedChild(file);
            if (cmp == 0) {
                foundIndex = mid;
                break;
            }
            if (!(!adopted && cmp > 0 || adopted && cmp < 0)) {
                int indexInAdopted = VirtualDirectoryImpl.findIndexInOneHalf(array, mid + 1, high + 1, true, name, comparator);
                int indexInReal = VirtualDirectoryImpl.findIndexInOneHalf(array, low, mid, false, name, comparator);
                return VirtualDirectoryImpl.pack(indexInReal, indexInAdopted);
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        if (cmp != 0) {
            foundIndex = -low - 1;
        }
        int newStart = adopted ? low : mid + 1;
        int n = newEnd = adopted ? mid + 1 : high + 1;
        int theOtherHalfIndex = newStart < newEnd ? VirtualDirectoryImpl.findIndexInOneHalf(array, newStart, newEnd, !adopted, name, comparator) : -newStart - 1;
        return adopted ? VirtualDirectoryImpl.pack(theOtherHalfIndex, foundIndex) : VirtualDirectoryImpl.pack(foundIndex, theOtherHalfIndex);
    }

    private static long pack(int indexInReal, int indexInAdopted) {
        return (long)indexInReal << 32 | (long)indexInAdopted & 0xFFFFFFFFL;
    }

    @Nullable
    public synchronized NewVirtualFile findChildIfCached(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "findChildIfCached"));
        }
        boolean ignoreCase = !this.getFileSystem().isCaseSensitive();
        Comparator comparator = VirtualDirectoryImpl.getComparator(ignoreCase);
        VirtualFileSystemEntry found = this.doFindChildInArray(name, comparator);
        return found == NULL_VIRTUAL_FILE ? null : found;
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildren() {
        if (!ourPersistence.wereChildrenAccessed((VirtualFile)this)) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "iterInDbChildren"));
            }
            return list;
        }
        if (!ourPersistence.areChildrenLoaded((VirtualFile)this)) {
            String[] names = ourPersistence.listPersisted((VirtualFile)this);
            NewVirtualFileSystem delegate = PersistentFS.replaceWithNativeFS(this.getFileSystem());
            for (String name : names) {
                this.findChild(name, false, false, delegate);
            }
        }
        Collection collection = this.getCachedChildren();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "iterInDbChildren"));
        }
        return collection;
    }

    @NotNull
    public synchronized VirtualFile[] getChildren() {
        VirtualFileSystemEntry[] result;
        boolean ignoreCase;
        VirtualFileSystemEntry[] children = this.myChildren;
        NewVirtualFileSystem delegate = this.getFileSystem();
        boolean bl = ignoreCase = !delegate.isCaseSensitive();
        if (this.allChildrenLoaded()) {
            this.assertConsistency(children, ignoreCase, new Object[0]);
            if (children == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "getChildren"));
            }
            return children;
        }
        final boolean wasChildrenLoaded = ourPersistence.areChildrenLoaded((VirtualFile)this);
        final FSRecords.NameId[] childrenIds = ourPersistence.listAll((VirtualFile)this);
        if (childrenIds.length == 0) {
            result = EMPTY_ARRAY;
        } else {
            Arrays.sort(childrenIds, new java.util.Comparator<FSRecords.NameId>(){

                @Override
                public int compare(FSRecords.NameId o1, FSRecords.NameId o2) {
                    String name1 = o1.name;
                    String name2 = o2.name;
                    int cmp = VirtualFileSystemEntry.compareNames(name1, name2, ignoreCase);
                    if (cmp == 0 && name1 != name2) {
                        LOG.error((Object)((Object)VirtualFileSystemEntry.ourPersistence) + " returned duplicate file names(" + name1 + "," + name2 + ")" + " ignoreCase: " + ignoreCase + " SystemInfo.isFileSystemCaseSensitive: " + SystemInfo.isFileSystemCaseSensitive + " SystemInfo.OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + " wasChildrenLoaded: " + wasChildrenLoaded + " in the dir: " + (Object)((Object)VirtualDirectoryImpl.this) + ";" + " children: " + Arrays.toString(childrenIds));
                    }
                    return cmp;
                }
            });
            result = new VirtualFileSystemEntry[childrenIds.length];
            int delegateI = 0;
            int i = 0;
            int cachedEnd = this.getAdoptedChildrenStart();
            while (delegateI < childrenIds.length) {
                FSRecords.NameId nameId = childrenIds[delegateI];
                while (i < cachedEnd && children[i].compareNameTo(nameId.name, ignoreCase) < 0) {
                    ++i;
                }
                VirtualFileSystemEntry resultFile = i < cachedEnd && children[i].compareNameTo(nameId.name, ignoreCase) == 0 ? children[i++] : this.createChild(nameId.nameId, nameId.id, delegate);
                result[delegateI++] = resultFile;
            }
            this.assertConsistency(result, ignoreCase, new Object[]{children, cachedEnd, childrenIds});
        }
        if (this.getId() > 0) {
            this.myChildren = result;
            this.setChildrenLoaded();
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "getChildren"));
        }
        return result;
    }

    private void assertConsistency(@NotNull VirtualFileSystemEntry[] array, boolean ignoreCase, Object ... details) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "assertConsistency"));
        }
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "assertConsistency"));
        }
        if (!CHECK) {
            return;
        }
        boolean allChildrenLoaded = this.allChildrenLoaded();
        for (int i = 0; i < array.length; ++i) {
            VirtualFileSystemEntry file = array[i];
            boolean isAdopted = VirtualDirectoryImpl.isAdoptedChild(file);
            assert (!isAdopted || !allChildrenLoaded);
            if (isAdopted && i != array.length - 1) assert (VirtualDirectoryImpl.isAdoptedChild(array[i + 1]));
            if (i == 0) continue;
            VirtualFileSystemEntry prev = array[i - 1];
            String prevName = prev.getName();
            int cmp = file.compareNameTo(prevName, ignoreCase);
            if (cmp == 0) {
                VirtualDirectoryImpl.error((String)verboseToString.fun((Object)prev) + " equals to " + (String)verboseToString.fun((Object)file), array, details);
            }
            if (isAdopted != VirtualDirectoryImpl.isAdoptedChild(prev) || cmp > 0) continue;
            VirtualDirectoryImpl.error("Not sorted: " + (String)verboseToString.fun((Object)prev) + " is not less than " + (String)verboseToString.fun((Object)file), array, details);
        }
    }

    private static void error(@NonNls String message, VirtualFileSystemEntry[] array, Object ... details) {
        String children = StringUtil.join((Object[])array, verboseToString, (String)",");
        throw new AssertionError((Object)(message + "; children: " + children + "\nDetails: " + ContainerUtil.map((Object[])details, (Function)new Function<Object, Object>(){

            public Object fun(Object o) {
                return o instanceof Object[] ? Arrays.toString((Object[])o) : o;
            }
        })));
    }

    @Nullable
    public VirtualFileSystemEntry findChild(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "findChild"));
        }
        return this.findChild(name, false, true, this.getFileSystem());
    }

    public VirtualFileSystemEntry findChildById(int id, boolean cachedOnly) {
        VirtualFileSystemEntry[] array = this.getArraySafely();
        VirtualFileSystemEntry result = null;
        for (VirtualFileSystemEntry file : array) {
            VirtualFileSystemEntry withId = file;
            if (withId.getId() != id) continue;
            result = withId;
            break;
        }
        if (result != null) {
            return result;
        }
        if (cachedOnly) {
            return null;
        }
        String name = ourPersistence.getName(id);
        return this.findChild(name, false, false, this.getFileSystem());
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        throw new IOException("Cannot get content of directory: " + (Object)((Object)this));
    }

    public synchronized void addChild(@NotNull VirtualFileSystemEntry child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "addChild"));
        }
        VirtualFileSystemEntry[] array = this.myChildren;
        String childName = child.getName();
        boolean ignoreCase = !this.getFileSystem().isCaseSensitive();
        long r = VirtualDirectoryImpl.findIndexInBoth(array, childName, VirtualDirectoryImpl.getComparator(ignoreCase));
        int indexInReal = (int)(r >> 32);
        int indexInAdopted = (int)r;
        if (indexInAdopted >= 0) {
            this.removeFromArray(indexInAdopted);
        }
        if (indexInReal < 0) {
            this.insertChildAt(child, indexInReal);
        }
        this.assertConsistency(this.myChildren, ignoreCase, new Object[]{child});
    }

    private void insertChildAt(@NotNull VirtualFileSystemEntry file, int negativeIndex) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "insertChildAt"));
        }
        VirtualFileSystemEntry[] array = this.myChildren;
        VirtualFileSystemEntry[] appended = new VirtualFileSystemEntry[array.length + 1];
        int i = -negativeIndex - 1;
        System.arraycopy(array, 0, appended, 0, i);
        appended[i] = file;
        System.arraycopy(array, i, appended, i + 1, array.length - i);
        this.myChildren = appended;
    }

    public synchronized void removeChild(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "removeChild"));
        }
        boolean ignoreCase = !this.getFileSystem().isCaseSensitive();
        String name = file.getName();
        this.addToAdoptedChildren(ignoreCase, name, VirtualDirectoryImpl.getComparator(ignoreCase));
        this.assertConsistency(this.myChildren, ignoreCase, file);
    }

    private void removeFromArray(int index) {
        this.myChildren = (VirtualFileSystemEntry[])ArrayUtil.remove((Object[])this.myChildren, (int)index, (ArrayFactory)new ArrayFactory<VirtualFileSystemEntry>(){

            @NotNull
            public VirtualFileSystemEntry[] create(int count) {
                VirtualFileSystemEntry[] virtualFileSystemEntryArray = new VirtualFileSystemEntry[count];
                if (virtualFileSystemEntryArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl$8", "create"));
                }
                return virtualFileSystemEntryArray;
            }
        });
    }

    public boolean allChildrenLoaded() {
        return this.getFlagInt(0x8000000);
    }

    private void setChildrenLoaded() {
        this.setFlagInt(0x8000000, true);
    }

    @NotNull
    public synchronized List<String> getSuspiciousNames() {
        SubList<VirtualFileSystemEntry> suspicious = new SubList<VirtualFileSystemEntry>(this.myChildren, this.getAdoptedChildrenStart(), this.myChildren.length);
        List list = ContainerUtil.map2List(suspicious, (Function)new Function<VirtualFile, String>(){

            public String fun(VirtualFile file) {
                return file.getName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "getSuspiciousNames"));
        }
        return list;
    }

    private int getAdoptedChildrenStart() {
        int index = VirtualDirectoryImpl.binSearch(this.myChildren, 0, this.myChildren.length, "", new Comparator(){

            @Override
            public int compareFileNameTo(@NotNull String myName, @NotNull VirtualFileSystemEntry v) {
                if (myName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl$10", "compareFileNameTo"));
                }
                if (v == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl$10", "compareFileNameTo"));
                }
                return VirtualDirectoryImpl.isAdoptedChild(v) ? -1 : 1;
            }
        });
        return -index - 1;
    }

    private static boolean isAdoptedChild(@NotNull VirtualFileSystemEntry v) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "isAdoptedChild"));
        }
        return v.getParent() == NULL_VIRTUAL_FILE;
    }

    private static int binSearch(@NotNull VirtualFileSystemEntry[] array, int start, int end, @NotNull String name, @NotNull Comparator comparator) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "binSearch"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "binSearch"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "binSearch"));
        }
        int low = start;
        int high = end - 1;
        assert (low >= 0 && low <= array.length);
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = comparator.compareFileNameTo(name, array[mid]);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public boolean isDirectory() {
        return true;
    }

    @NotNull
    public synchronized List<VirtualFile> getCachedChildren() {
        SubList<VirtualFileSystemEntry> subList = new SubList<VirtualFileSystemEntry>(this.myChildren, 0, this.getAdoptedChildrenStart());
        if (subList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "getCachedChildren"));
        }
        return subList;
    }

    public InputStream getInputStream() throws IOException {
        throw new IOException("getInputStream() must not be called against a directory: " + this.getUrl());
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new IOException("getOutputStream() must not be called against a directory: " + this.getUrl());
    }

    @Override
    public void markDirtyRecursively() {
        this.markDirty();
        this.markDirtyRecursivelyInternal();
    }

    private void markDirtyRecursivelyInternal() {
        for (VirtualFileSystemEntry child : this.getArraySafely()) {
            if (VirtualDirectoryImpl.isAdoptedChild(child)) break;
            child.markDirtyInternal();
            if (!(child instanceof VirtualDirectoryImpl)) continue;
            ((VirtualDirectoryImpl)child).markDirtyRecursivelyInternal();
        }
    }

    static {
        verboseToString = new Function<VirtualFileSystemEntry, String>(){

            public String fun(VirtualFileSystemEntry file) {
                return (Object)((Object)file) + " (name: '" + file.getName() + "', " + ((Object)((Object)file)).getClass() + ", parent: " + (Object)((Object)file.getParent()) + "; id: " + file.getId() + "; FS: " + file.getFileSystem() + "; delegate.attrs: " + file.getFileSystem().getAttributes((VirtualFile)file) + "; caseSensitive: " + file.getFileSystem().isCaseSensitive() + "; canonical: " + file.getFileSystem().getCanonicallyCasedName((VirtualFile)file) + ") ";
            }
        };
    }

    private static interface Comparator {
        public int compareFileNameTo(@NotNull String var1, @NotNull VirtualFileSystemEntry var2);
    }

    private static class AdoptedChild
    extends VirtualFileImpl {
        private final String myName;

        private AdoptedChild(String name) {
            super(-1, NULL_VIRTUAL_FILE, -42, -1);
            this.myName = name;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl$AdoptedChild", "getName"));
            }
            return string;
        }

        @Override
        public void setNewName(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl$AdoptedChild", "setNewName"));
            }
            throw new IncorrectOperationException();
        }

        @Override
        public int compareNameTo(@NotNull String name, boolean ignoreCase) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl$AdoptedChild", "compareNameTo"));
            }
            return AdoptedChild.compareNames(this.myName, name, ignoreCase);
        }

        @Override
        protected char[] appendPathOnFileSystem(int accumulatedPathLength, int[] positionRef) {
            char[] chars = this.getParent().appendPathOnFileSystem(accumulatedPathLength + 1 + this.myName.length(), positionRef);
            if (positionRef[0] > 0 && chars[positionRef[0] - 1] != '/') {
                int n = positionRef[0];
                positionRef[0] = n + 1;
                chars[n] = 47;
            }
            positionRef[0] = VirtualFileSystemEntry.copyString(chars, positionRef[0], this.myName);
            return chars;
        }
    }
}

