/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.IntSLRUCache;
import com.intellij.util.containers.IntObjectLinkedMap;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.text.StringFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileNameCache {
    private static final PersistentStringEnumerator ourNames = FSRecords.getNames();
    private static final IntSLRUCache<IntObjectLinkedMap.MapEntry<Object>>[] ourNameCache = new IntSLRUCache[16];

    public static int storeName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "storeName"));
        }
        int idx = FSRecords.getNameId(name);
        FileNameCache.cacheData(name, idx, FileNameCache.calcStripeIdFromNameId(idx));
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static IntObjectLinkedMap.MapEntry<Object> cacheData(String name, int id, int stripe) {
        if (name == null) {
            ourNames.markCorrupted();
            throw new RuntimeException("VFS name enumerator corrupted");
        }
        Object rawName = FileNameCache.convertToBytesIfAsciiString(name);
        IntObjectLinkedMap.MapEntry<Object> entry = new IntObjectLinkedMap.MapEntry<Object>(id, rawName);
        IntSLRUCache<IntObjectLinkedMap.MapEntry<Object>> intSLRUCache = ourNameCache[stripe];
        // MONITORENTER : intSLRUCache
        IntObjectLinkedMap.MapEntry<Object> mapEntry = ourNameCache[stripe].cacheEntry(entry);
        // MONITOREXIT : intSLRUCache
        if (mapEntry != null) return mapEntry;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "cacheData"));
    }

    private static int calcStripeIdFromNameId(int id) {
        int h = id;
        h -= h << 6;
        h ^= h >> 17;
        h -= h << 9;
        h ^= h << 4;
        h -= h << 3;
        h ^= h << 10;
        h ^= h >> 15;
        return h % ourNameCache.length;
    }

    @NotNull
    private static Object convertToBytesIfAsciiString(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "convertToBytesIfAsciiString"));
        }
        int length = name.length();
        if (length == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "convertToBytesIfAsciiString"));
            }
            return "";
        }
        if (!IOUtil.isAscii((String)name)) {
            String string = new String(name);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "convertToBytesIfAsciiString"));
            }
            return string;
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)name.charAt(i);
        }
        if (bytes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "convertToBytesIfAsciiString"));
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static IntObjectLinkedMap.MapEntry<Object> getEntry(int id) {
        int stripe = FileNameCache.calcStripeIdFromNameId(id);
        IntSLRUCache<IntObjectLinkedMap.MapEntry<Object>> intSLRUCache = ourNameCache[stripe];
        synchronized (intSLRUCache) {
            IntObjectLinkedMap.MapEntry<Object> entry = ourNameCache[stripe].getCachedEntry(id);
            if (entry != null) {
                IntObjectLinkedMap.MapEntry<Object> mapEntry = entry;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                if (mapEntry == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "getEntry"));
                }
                return mapEntry;
            }
        }
        IntObjectLinkedMap.MapEntry<Object> mapEntry = FileNameCache.cacheData(FSRecords.getNameByNameId(id), id, stripe);
        if (mapEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "getEntry"));
        }
        return mapEntry;
    }

    @NotNull
    public static String getVFileName(int nameId) {
        IntObjectLinkedMap.MapEntry<Object> entry = FileNameCache.getEntry(nameId);
        Object name = entry.value;
        if (name instanceof String) {
            String string = (String)name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "getVFileName"));
            }
            return string;
        }
        byte[] bytes = (byte[])name;
        int length = bytes.length;
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)bytes[i];
        }
        String string = StringFactory.createShared((char[])chars);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "getVFileName"));
        }
        return string;
    }

    static int compareNameTo(int nameId, @NotNull String name, boolean ignoreCase) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "compareNameTo"));
        }
        IntObjectLinkedMap.MapEntry<Object> entry = FileNameCache.getEntry(nameId);
        Object rawName = entry.value;
        if (rawName instanceof String) {
            String thisName = (String)rawName;
            return VirtualFileSystemEntry.compareNames(thisName, name, ignoreCase);
        }
        byte[] bytes = (byte[])rawName;
        int bytesLength = bytes.length;
        int d = bytesLength - name.length();
        if (d != 0) {
            return d;
        }
        return FileNameCache.compareBytes(bytes, name, bytesLength, ignoreCase);
    }

    private static int compareBytes(@NotNull byte[] name1, @NotNull String name2, int len, boolean ignoreCase) {
        if (name1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "compareBytes"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "compareBytes"));
        }
        for (int i = 0; i < len; ++i) {
            char c1 = (char)name1[i];
            char c2 = name2.charAt(i);
            int d = StringUtil.compare((char)c1, (char)c2, (boolean)ignoreCase);
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    @NotNull
    static char[] appendPathOnFileSystem(int nameId, @Nullable VirtualFileSystemEntry parent, int accumulatedPathLength, @NotNull int[] positionRef) {
        char[] chars;
        boolean appendSlash;
        int nameLength;
        if (positionRef == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "appendPathOnFileSystem"));
        }
        IntObjectLinkedMap.MapEntry<Object> entry = FileNameCache.getEntry(nameId);
        Object o = entry.value;
        int n = nameLength = o instanceof String ? ((String)o).length() : ((byte[])o).length;
        boolean bl = SystemInfo.isWindows && parent == null && nameLength == 2 && (o instanceof String ? ((String)o).charAt(1) : (char)((byte[])o)[1]) == ':' ? true : (appendSlash = false);
        if (parent != null) {
            chars = parent.appendPathOnFileSystem(accumulatedPathLength + 1 + nameLength, positionRef);
            if (positionRef[0] > 0 && chars[positionRef[0] - 1] != '/') {
                int n2 = positionRef[0];
                positionRef[0] = n2 + 1;
                chars[n2] = 47;
            }
        } else {
            int rootPathLength = accumulatedPathLength + nameLength;
            if (appendSlash) {
                ++rootPathLength;
            }
            chars = new char[rootPathLength];
        }
        if (o instanceof String) {
            positionRef[0] = VirtualFileSystemEntry.copyString(chars, positionRef[0], (String)o);
        } else {
            byte[] bytes = (byte[])o;
            int pos = positionRef[0];
            int len = bytes.length;
            for (int i = 0; i < len; ++i) {
                chars[pos++] = (char)bytes[i];
            }
            positionRef[0] = pos;
        }
        if (appendSlash) {
            int n3 = positionRef[0];
            positionRef[0] = n3 + 1;
            chars[n3] = 47;
        }
        if (chars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FileNameCache", "appendPathOnFileSystem"));
        }
        return chars;
    }

    static {
        int protectedSize = 40000 / ourNameCache.length;
        int probationalSize = 20000 / ourNameCache.length;
        for (int i = 0; i < ourNameCache.length; ++i) {
            FileNameCache.ourNameCache[i] = new IntSLRUCache(protectedSize, probationalSize);
        }
    }
}

