/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.VfsImplUtil");
    @NonNls
    private static final String FILE_SEPARATORS = "/" + File.separator;

    private VfsImplUtil() {
    }

    @Nullable
    public static NewVirtualFile findFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull @NonNls String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "findFileByPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "findFileByPath"));
        }
        Pair<NewVirtualFile, Iterable<String>> data = VfsImplUtil.prepare(vfs, path);
        if (data == null) {
            return null;
        }
        NewVirtualFile file = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            NewVirtualFile canonicalFile;
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            file = "..".equals(pathElement) ? (file.is(VFileProperty.SYMLINK) ? ((canonicalFile = file.getCanonicalFile()) != null ? canonicalFile.getParent() : null) : file.getParent()) : file.findChild(pathElement);
            if (file != null) continue;
            return null;
        }
        return file;
    }

    @Nullable
    public static NewVirtualFile findFileByPathIfCached(@NotNull NewVirtualFileSystem vfs, @NotNull @NonNls String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "findFileByPathIfCached"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "findFileByPathIfCached"));
        }
        Pair<NewVirtualFile, Iterable<String>> data = VfsImplUtil.prepare(vfs, path);
        if (data == null) {
            return null;
        }
        NewVirtualFile file = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            if ("..".equals(pathElement)) {
                if (file.is(VFileProperty.SYMLINK)) {
                    String canonicalPath = file.getCanonicalPath();
                    NewVirtualFile canonicalFile = canonicalPath != null ? VfsImplUtil.findFileByPathIfCached(vfs, canonicalPath) : null;
                    file = canonicalFile != null ? canonicalFile.getParent() : null;
                } else {
                    file = file.getParent();
                }
            } else {
                file = file.findChildIfCached(pathElement);
            }
            if (file != null) continue;
            return null;
        }
        return file;
    }

    @Nullable
    public static NewVirtualFile refreshAndFindFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull @NonNls String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "refreshAndFindFileByPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "refreshAndFindFileByPath"));
        }
        Pair<NewVirtualFile, Iterable<String>> data = VfsImplUtil.prepare(vfs, path);
        if (data == null) {
            return null;
        }
        NewVirtualFile file = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            if ("..".equals(pathElement)) {
                if (file.is(VFileProperty.SYMLINK)) {
                    String canonicalPath = file.getCanonicalPath();
                    NewVirtualFile canonicalFile = canonicalPath != null ? VfsImplUtil.refreshAndFindFileByPath(vfs, canonicalPath) : null;
                    file = canonicalFile != null ? canonicalFile.getParent() : null;
                } else {
                    file = file.getParent();
                }
            } else {
                file = file.refreshAndFindChild(pathElement);
            }
            if (file != null) continue;
            return null;
        }
        return file;
    }

    @Nullable
    private static Pair<NewVirtualFile, Iterable<String>> prepare(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "prepare"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "prepare"));
        }
        String normalizedPath = VfsImplUtil.normalize(vfs, path);
        if (StringUtil.isEmptyOrSpaces((String)normalizedPath)) {
            return null;
        }
        String basePath = vfs.extractRootPath(normalizedPath);
        if (basePath.length() > normalizedPath.length()) {
            LOG.error(vfs + " failed to extract root path '" + basePath + "' from '" + normalizedPath + "' (original '" + path + "')");
            return null;
        }
        NewVirtualFile root = ManagingFS.getInstance().findRoot(basePath, vfs);
        if (root == null || !root.exists()) {
            return null;
        }
        Iterable parts = StringUtil.tokenize((String)normalizedPath.substring(basePath.length()), (String)FILE_SEPARATORS);
        return Pair.create((Object)root, (Object)parts);
    }

    @Nullable
    public static String normalize(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "normalize"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "normalize"));
        }
        return vfs.normalize(path);
    }
}

