/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalFileSystemImpl
extends LocalFileSystemBase
implements ApplicationComponent {
    private static final String FS_ROOT = "/";
    private final Object myLock;
    private final List<WatchRequestImpl> myRootsToWatch;
    private TreeNode myNormalizedTree;
    private final ManagingFS myManagingFS;
    private final FileWatcher myWatcher;

    public LocalFileSystemImpl(@NotNull ManagingFS managingFS) {
        if (managingFS == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "<init>"));
        }
        this.myLock = new Object();
        this.myRootsToWatch = new ArrayList<WatchRequestImpl>();
        this.myNormalizedTree = null;
        this.myManagingFS = managingFS;
        this.myWatcher = new FileWatcher(this.myManagingFS);
        if (this.myWatcher.isOperational()) {
            new StoreRefreshStatusThread().start();
        }
    }

    @NotNull
    public FileWatcher getFileWatcher() {
        FileWatcher fileWatcher = this.myWatcher;
        if (fileWatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "getFileWatcher"));
        }
        return fileWatcher;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.myWatcher.dispose();
    }

    @NotNull
    public String getComponentName() {
        if ("LocalFileSystem" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "getComponentName"));
        }
        return "LocalFileSystem";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WatchRequestImpl[] normalizeRootsForRefresh() {
        final ArrayList result = new ArrayList();
        Object object = this.myLock;
        synchronized (object) {
            TreeNode rootNode = new TreeNode();
            for (WatchRequestImpl request : this.myRootsToWatch) {
                request.myDominated = false;
                String rootPath = request.getRootPath();
                TreeNode currentNode = rootNode;
                for (String subPath : LocalFileSystemImpl.splitPath(rootPath)) {
                    TreeNode nextNode = (TreeNode)currentNode.nodes.get(subPath);
                    if (nextNode != null) {
                        currentNode = nextNode;
                        if (currentNode.watchRequest == null || !currentNode.watchRequest.isToWatchRecursively()) continue;
                        request.myDominated = true;
                        break;
                    }
                    TreeNode newNode = new TreeNode();
                    currentNode.nodes.put(subPath, newNode);
                    currentNode = newNode;
                }
                if (currentNode.watchRequest == null) {
                    currentNode.watchRequest = request;
                } else if (!currentNode.watchRequest.isToWatchRecursively()) {
                    currentNode.watchRequest.myDominated = true;
                    currentNode.watchRequest = request;
                } else {
                    request.myDominated = true;
                }
                if (!currentNode.watchRequest.isToWatchRecursively() || currentNode.nodes.isEmpty()) continue;
                LocalFileSystemImpl.visitTree(currentNode, new Consumer<TreeNode>(){

                    public void consume(TreeNode node) {
                        if (node.watchRequest != null) {
                            node.watchRequest.myDominated = true;
                        }
                    }
                });
                currentNode.nodes.clear();
            }
            LocalFileSystemImpl.visitTree(rootNode, new Consumer<TreeNode>(){

                public void consume(TreeNode node) {
                    if (node.watchRequest != null) {
                        result.add(node.watchRequest);
                    }
                }
            });
            this.myNormalizedTree = rootNode;
        }
        return result.toArray(new WatchRequestImpl[result.size()]);
    }

    @NotNull
    private static List<String> splitPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "splitPath"));
        }
        if (path.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "splitPath"));
            }
            return list;
        }
        if (FS_ROOT.equals(path)) {
            List<String> list = Collections.singletonList(FS_ROOT);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "splitPath"));
            }
            return list;
        }
        List parts = StringUtil.split((String)path, (String)FS_ROOT);
        if (StringUtil.startsWithChar((CharSequence)path, (char)'/')) {
            parts.add(0, FS_ROOT);
        }
        List list = parts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "splitPath"));
        }
        return list;
    }

    private static void visitTree(TreeNode rootNode, Consumer<TreeNode> consumer) {
        for (TreeNode node : rootNode.nodes.values()) {
            consumer.consume((Object)node);
            LocalFileSystemImpl.visitTree(node, consumer);
        }
    }

    private boolean isAlreadyWatched(WatchRequestImpl request) {
        if (this.myNormalizedTree == null) {
            this.normalizeRootsForRefresh();
        }
        String rootPath = request.getRootPath();
        TreeNode currentNode = this.myNormalizedTree;
        for (String subPath : LocalFileSystemImpl.splitPath(rootPath)) {
            TreeNode nextNode = (TreeNode)currentNode.nodes.get(subPath);
            if (nextNode == null) {
                return false;
            }
            currentNode = nextNode;
            if (currentNode.watchRequest == null || !currentNode.watchRequest.isToWatchRecursively()) continue;
            return true;
        }
        return !request.isToWatchRecursively() && currentNode.watchRequest != null;
    }

    private void storeRefreshStatusToFiles() {
        if (this.myWatcher.isOperational()) {
            FileWatcher.DirtyPaths dirtyPaths = this.myWatcher.getDirtyPaths();
            this.markPathsDirty(dirtyPaths.dirtyPaths);
            this.markFlatDirsDirty(dirtyPaths.dirtyDirectories);
            this.markRecursiveDirsDirty(dirtyPaths.dirtyPathsRecursive);
        }
    }

    private void markPathsDirty(List<String> dirtyPaths) {
        for (String dirtyPath : dirtyPaths) {
            VirtualFile file = this.findFileByPathIfCached(dirtyPath);
            if (!(file instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)file).markDirty();
        }
    }

    private void markFlatDirsDirty(List<String> dirtyPaths) {
        for (String dirtyPath : dirtyPaths) {
            VirtualFile file = this.findFileOrParentIfCached(dirtyPath);
            if (!(file instanceof NewVirtualFile)) continue;
            NewVirtualFile nvf = (NewVirtualFile)file;
            nvf.markDirty();
            for (VirtualFile child : nvf.getCachedChildren()) {
                ((NewVirtualFile)child).markDirty();
            }
        }
    }

    private void markRecursiveDirsDirty(List<String> dirtyPaths) {
        for (String dirtyPath : dirtyPaths) {
            VirtualFile file = this.findFileOrParentIfCached(dirtyPath);
            if (!(file instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)file).markDirtyRecursively();
        }
    }

    private VirtualFile findFileOrParentIfCached(String path) {
        String parentPath;
        VirtualFile file = this.findFileByPathIfCached(path);
        if (file == null && (parentPath = new File(path).getParent()) != null) {
            file = this.findFileByPathIfCached(parentPath);
        }
        return file;
    }

    public void markSuspiciousFilesDirty(List<VirtualFile> files) {
        this.storeRefreshStatusToFiles();
        if (this.myWatcher.isOperational()) {
            for (String root : this.myWatcher.getManualWatchRoots()) {
                VirtualFile suspiciousRoot = this.findFileByPathIfCached(root);
                if (suspiciousRoot == null) continue;
                ((NewVirtualFile)suspiciousRoot).markDirtyRecursively();
            }
        } else {
            for (VirtualFile file : files) {
                if (file.getFileSystem() != this) continue;
                ((NewVirtualFile)file).markDirtyRecursively();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpFileWatcher() {
        Application application = ApplicationManager.getApplication();
        if (application.isDisposeInProgress() || !this.myWatcher.isOperational()) {
            return;
        }
        application.assertReadAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            WatchRequestImpl[] watchRequests = this.normalizeRootsForRefresh();
            ArrayList<String> myRecursiveRoots = new ArrayList<String>();
            ArrayList<String> myFlatRoots = new ArrayList<String>();
            for (WatchRequestImpl watchRequest : watchRequests) {
                if (watchRequest.isToWatchRecursively()) {
                    myRecursiveRoots.add(watchRequest.myFSRootPath);
                    continue;
                }
                myFlatRoots.add(watchRequest.myFSRootPath);
            }
            this.myWatcher.setWatchRoots(myRecursiveRoots, myFlatRoots);
        }
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> addRootsToWatch(@NotNull Collection<String> rootPaths, boolean watchRecursively) {
        if (rootPaths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "addRootsToWatch"));
        }
        if (rootPaths.isEmpty() || !this.myWatcher.isOperational()) {
            Set<LocalFileSystem.WatchRequest> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "addRootsToWatch"));
            }
            return set;
        }
        if (watchRecursively) {
            Set<LocalFileSystem.WatchRequest> set = this.replaceWatchedRoots(Collections.<LocalFileSystem.WatchRequest>emptySet(), rootPaths, null);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "addRootsToWatch"));
            }
            return set;
        }
        Set<LocalFileSystem.WatchRequest> set = this.replaceWatchedRoots(Collections.<LocalFileSystem.WatchRequest>emptySet(), null, rootPaths);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "addRootsToWatch"));
        }
        return set;
    }

    public void removeWatchedRoots(final @NotNull Collection<LocalFileSystem.WatchRequest> watchRequests) {
        if (watchRequests == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "removeWatchedRoots"));
        }
        if (watchRequests.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = LocalFileSystemImpl.this.myLock;
                synchronized (object) {
                    boolean update = LocalFileSystemImpl.this.doRemoveWatchedRoots(watchRequests);
                    if (update) {
                        LocalFileSystemImpl.this.myNormalizedTree = null;
                        LocalFileSystemImpl.this.setUpFileWatcher();
                    }
                }
            }
        });
    }

    public Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests, @Nullable Collection<String> _recursiveRoots, @Nullable Collection<String> _flatRoots) {
        Collection<String> flatRoots;
        if (watchRequests == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "replaceWatchedRoots"));
        }
        final Collection<String> recursiveRoots = _recursiveRoots != null ? _recursiveRoots : Collections.emptyList();
        Collection<String> collection = flatRoots = _flatRoots != null ? _flatRoots : Collections.emptyList();
        if (recursiveRoots.isEmpty() && flatRoots.isEmpty() || !this.myWatcher.isOperational()) {
            this.removeWatchedRoots(watchRequests);
            return Collections.emptySet();
        }
        HashSet result = new HashSet();
        HashSet filesToSync = new HashSet();
        ApplicationManager.getApplication().runReadAction(new Runnable((Set)result, (Set)filesToSync, watchRequests){
            final /* synthetic */ Set val$result;
            final /* synthetic */ Set val$filesToSync;
            final /* synthetic */ Collection val$watchRequests;
            {
                this.val$result = set;
                this.val$filesToSync = set2;
                this.val$watchRequests = collection3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = LocalFileSystemImpl.this.myLock;
                synchronized (object) {
                    boolean update;
                    boolean bl = update = LocalFileSystemImpl.this.doAddRootsToWatch(recursiveRoots, flatRoots, this.val$result, this.val$filesToSync) || LocalFileSystemImpl.this.doRemoveWatchedRoots(this.val$watchRequests);
                    if (update) {
                        LocalFileSystemImpl.this.myNormalizedTree = null;
                        LocalFileSystemImpl.this.setUpFileWatcher();
                    }
                }
            }
        });
        this.syncFiles((Set<VirtualFile>)filesToSync);
        return result;
    }

    private boolean doAddRootsToWatch(@NotNull Collection<String> recursiveRoots, @NotNull Collection<String> flatRoots, @NotNull Set<LocalFileSystem.WatchRequest> results, @NotNull Set<VirtualFile> filesToSync) {
        boolean alreadyWatched;
        WatchRequestImpl request;
        if (recursiveRoots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "doAddRootsToWatch"));
        }
        if (flatRoots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "doAddRootsToWatch"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "doAddRootsToWatch"));
        }
        if (filesToSync == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "doAddRootsToWatch"));
        }
        boolean update = false;
        for (String root : recursiveRoots) {
            request = LocalFileSystemImpl.watch(root, true);
            if (request == null) continue;
            alreadyWatched = this.isAlreadyWatched(request);
            request.myDominated = alreadyWatched;
            this.myRootsToWatch.add(request);
            results.add(request);
            update |= !alreadyWatched;
        }
        for (String root : flatRoots) {
            VirtualFile existingFile;
            request = LocalFileSystemImpl.watch(root, false);
            if (request == null) continue;
            alreadyWatched = this.isAlreadyWatched(request);
            if (!alreadyWatched && (existingFile = this.findFileByPathIfCached(root)) != null && existingFile.isDirectory() && existingFile instanceof NewVirtualFile) {
                filesToSync.addAll(((NewVirtualFile)existingFile).getCachedChildren());
            }
            request.myDominated = alreadyWatched;
            this.myRootsToWatch.add(request);
            results.add(request);
            update |= !alreadyWatched;
        }
        return update;
    }

    @Nullable
    private static WatchRequestImpl watch(String root, boolean recursively) {
        try {
            return new WatchRequestImpl(root, recursively);
        }
        catch (FileNotFoundException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private void syncFiles(@NotNull Set<VirtualFile> filesToSync) {
        if (filesToSync == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "syncFiles"));
        }
        if (filesToSync.isEmpty() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        for (VirtualFile file : filesToSync) {
            if (!(file instanceof NewVirtualFile) || !(file.getFileSystem() instanceof LocalFileSystem)) continue;
            ((NewVirtualFile)file).markDirtyRecursively();
        }
        this.refreshFiles(filesToSync, true, false, null);
    }

    private boolean doRemoveWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests) {
        if (watchRequests == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl", "doRemoveWatchedRoots"));
        }
        boolean update = false;
        for (LocalFileSystem.WatchRequest watchRequest : watchRequests) {
            WatchRequestImpl impl = (WatchRequestImpl)watchRequest;
            boolean wasWatched = this.myRootsToWatch.remove(impl) && !impl.myDominated;
            update |= wasWatched;
        }
        return update;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void refreshWithoutFileWatcher(final boolean asynchronous) {
        Runnable heavyRefresh = new Runnable(){

            @Override
            public void run() {
                for (VirtualFile root : LocalFileSystemImpl.this.myManagingFS.getRoots((NewVirtualFileSystem)LocalFileSystemImpl.this)) {
                    ((NewVirtualFile)root).markDirtyRecursively();
                }
                LocalFileSystemImpl.this.refresh(asynchronous);
            }
        };
        if (asynchronous && this.myWatcher.isOperational()) {
            RefreshQueue.getInstance().refresh(true, true, heavyRefresh, this.myManagingFS.getRoots((NewVirtualFileSystem)this));
        } else {
            heavyRefresh.run();
        }
    }

    @NonNls
    public String toString() {
        return "LocalFileSystem";
    }

    public void cleanupForNextTest() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        });
        PersistentFS.getInstance().clearIdCache();
        this.myRootsToWatch.clear();
    }

    private class StoreRefreshStatusThread
    extends Thread {
        private static final long PERIOD = 1000L;

        public StoreRefreshStatusThread() {
            super(StoreRefreshStatusThread.class.getSimpleName());
            this.setPriority(1);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Application application;
            while ((application = ApplicationManager.getApplication()) != null && !application.isDisposed()) {
                LocalFileSystemImpl.this.storeRefreshStatusToFiles();
                TimeoutUtil.sleep((long)1000L);
            }
        }
    }

    private static class TreeNode {
        private WatchRequestImpl watchRequest = null;
        private Map<String, TreeNode> nodes = new THashMap(1, FileUtil.PATH_HASHING_STRATEGY);

        private TreeNode() {
        }
    }

    private static class WatchRequestImpl
    implements LocalFileSystem.WatchRequest {
        private final boolean myToWatchRecursively;
        private String myFSRootPath;
        private boolean myDominated;

        public WatchRequestImpl(String rootPath, boolean toWatchRecursively) throws FileNotFoundException {
            int index = rootPath.indexOf("!/");
            if (index >= 0) {
                rootPath = rootPath.substring(0, index);
            }
            File rootFile = new File(FileUtil.toSystemDependentName((String)rootPath));
            if (index > 0 || !FileUtil.isRootPath((File)rootFile) && !rootFile.isDirectory()) {
                File parentFile = rootFile.getParentFile();
                if (parentFile == null) {
                    throw new FileNotFoundException(rootPath);
                }
                if (!parentFile.getPath().equals(PathManager.getSystemPath()) || !rootFile.mkdir()) {
                    rootFile = parentFile;
                }
            }
            this.myFSRootPath = rootFile.getAbsolutePath();
            this.myToWatchRecursively = toWatchRecursively;
        }

        @NotNull
        public String getRootPath() {
            String string = FileUtil.toSystemIndependentName((String)this.myFSRootPath);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl$WatchRequestImpl", "getRootPath"));
            }
            return string;
        }

        public boolean isToWatchRecursively() {
            return this.myToWatchRecursively;
        }

        public String toString() {
            return this.getRootPath();
        }
    }
}

