/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFile;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.jar.JarHandler;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ConcurrentHashSet;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarFileSystemImpl
extends JarFileSystem
implements ApplicationComponent {
    private static final JarFileSystemImplLock LOCK = new JarFileSystemImplLock();
    private final Set<String> myNoCopyJarPaths;
    private File myNoCopyJarDir;
    private final Map<String, JarHandler> myHandlers = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
    private String[] jarPathsCache;

    public JarFileSystemImpl(MessageBus bus) {
        boolean noCopy = SystemProperties.getBooleanProperty((String)"idea.jars.nocopy", (!SystemInfo.isWindows ? 1 : 0) != 0);
        this.myNoCopyJarPaths = noCopy ? null : new ConcurrentHashSet(FileUtil.PATH_HASHING_STRATEGY);
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl$1", "after"));
                }
                ArrayList<VirtualFile> rootsToRefresh = new ArrayList<VirtualFile>();
                for (VFileEvent vFileEvent : events) {
                    String[] jarPaths;
                    if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem)) continue;
                    String path = vFileEvent.getPath();
                    JarFileSystemImplLock jarFileSystemImplLock = LOCK;
                    synchronized (jarFileSystemImplLock) {
                        jarPaths = JarFileSystemImpl.this.jarPathsCache;
                        if (jarPaths == null) {
                            jarPaths = ArrayUtil.toStringArray(JarFileSystemImpl.this.myHandlers.keySet());
                            JarFileSystemImpl.access$202(JarFileSystemImpl.this, jarPaths);
                        }
                    }
                    for (String jarPath : jarPaths) {
                        VirtualFile jarRootToRefresh;
                        String jarFile = jarPath.substring(0, jarPath.length() - "!/".length());
                        if (!FileUtil.startsWith((String)jarFile, (String)path) || (jarRootToRefresh = JarFileSystemImpl.this.markDirty(jarPath)) == null) continue;
                        rootsToRefresh.add(jarRootToRefresh);
                    }
                }
                if (!rootsToRefresh.isEmpty()) {
                    for (VirtualFile virtualFile : rootsToRefresh) {
                        if (!virtualFile.isValid()) continue;
                        ((NewVirtualFile)virtualFile).markDirtyRecursively();
                    }
                    RefreshQueue.getInstance().refresh(!ApplicationManager.getApplication().isUnitTestMode(), true, null, rootsToRefresh);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFile markDirty(@NotNull String path) {
        JarHandler handler;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "markDirty"));
        }
        JarFileSystemImplLock jarFileSystemImplLock = LOCK;
        synchronized (jarFileSystemImplLock) {
            handler = this.myHandlers.remove(path);
            this.jarPathsCache = null;
        }
        if (handler != null) {
            return handler.markDirty();
        }
        return null;
    }

    @NotNull
    public String getComponentName() {
        if ("JarFileSystem" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getComponentName"));
        }
        return "JarFileSystem";
    }

    public void initComponent() {
        boolean isRunningFromDist = new File(PathManager.getLibPath() + File.separatorChar + "openapi.jar").exists();
        if (isRunningFromDist) {
            this.myNoCopyJarDir = new File(new File(PathManager.getLibPath()).getParent());
        }
    }

    public void disposeComponent() {
    }

    public void setNoCopyJarForPath(String pathInJar) {
        if (this.myNoCopyJarPaths == null || pathInJar == null) {
            return;
        }
        int index = pathInJar.indexOf("!/");
        if (index < 0) {
            return;
        }
        String path = pathInJar.substring(0, index);
        path = path.replace('/', File.separatorChar);
        this.myNoCopyJarPaths.add(path);
    }

    @Nullable
    public VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        return StandardFileSystems.getVirtualFileForJar((VirtualFile)entryVFile);
    }

    public JarFile getJarFile(@NotNull VirtualFile entryVFile) throws IOException {
        if (entryVFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getJarFile"));
        }
        JarHandler handler = this.getHandler(entryVFile);
        return handler.getJar();
    }

    @Nullable
    public File getMirroredFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getMirroredFile"));
        }
        VirtualFile jar = this.getJarRootForLocalFile(vFile);
        JarHandler handler = jar != null ? this.getHandler(jar) : null;
        return handler != null ? handler.getMirrorFile(new File(vFile.getPath())) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarHandler getHandler(@NotNull VirtualFile entryVFile) {
        JarHandler freshHandler;
        JarHandler handler;
        if (entryVFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getHandler"));
        }
        String jarRootPath = this.extractRootPath(entryVFile.getPath());
        JarFileSystemImplLock jarFileSystemImplLock = LOCK;
        synchronized (jarFileSystemImplLock) {
            handler = this.myHandlers.get(jarRootPath);
            if (handler == null) {
                freshHandler = handler = new JarHandler(this, jarRootPath.substring(0, jarRootPath.length() - "!/".length()));
                this.myHandlers.put(jarRootPath, handler);
                this.jarPathsCache = null;
            } else {
                freshHandler = null;
            }
        }
        if (freshHandler != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    freshHandler.refreshLocalFileForJar();
                }
            }, ModalityState.defaultModalityState());
        }
        return handler;
    }

    @NotNull
    public String getProtocol() {
        if ("jar" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getProtocol"));
        }
        return "jar";
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "extractPresentableUrl"));
        }
        String string = super.extractPresentableUrl(StringUtil.trimEnd((String)path, (String)"!/"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "extractPresentableUrl"));
        }
        return string;
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "extractRootPath"));
        }
        int jarSeparatorIndex = path.indexOf("!/");
        assert (jarSeparatorIndex >= 0) : "Path passed to JarFileSystem must have jar separator '!/': " + path;
        String string = path.substring(0, jarSeparatorIndex + "!/".length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "extractRootPath"));
        }
        return string;
    }

    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "exists"));
        }
        return this.getHandler(fileOrDirectory).exists(fileOrDirectory);
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getInputStream"));
        }
        InputStream inputStream = this.getHandler(file).getInputStream(file);
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getInputStream"));
        }
        return inputStream;
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "contentsToByteArray"));
        }
        byte[] byArray = this.getHandler(file).contentsToByteArray(file);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "contentsToByteArray"));
        }
        return byArray;
    }

    public long getLength(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getLength"));
        }
        return this.getHandler(file).getLength(file);
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file, Object requestor, long modStamp, long l) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getOutputStream"));
        }
        throw new IOException("Read-only: " + file.getPresentableUrl());
    }

    public boolean isMakeCopyOfJar(@NotNull File originalJar) {
        if (originalJar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "isMakeCopyOfJar"));
        }
        if (this.myNoCopyJarPaths == null || this.myNoCopyJarPaths.contains(originalJar.getPath())) {
            return false;
        }
        return this.myNoCopyJarDir == null || !FileUtil.isAncestor((File)this.myNoCopyJarDir, (File)originalJar, (boolean)false);
    }

    public long getTimeStamp(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getTimeStamp"));
        }
        return this.getHandler(file).getTimeStamp(file);
    }

    public boolean isDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "isDirectory"));
        }
        return this.getHandler(file).isDirectory(file);
    }

    public boolean isWritable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "isWritable"));
        }
        return false;
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "list"));
        }
        String[] stringArray = this.getHandler(file).list(file);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "list"));
        }
        return stringArray;
    }

    public void setTimeStamp(@NotNull VirtualFile file, long modStamp) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "setTimeStamp"));
        }
        throw new IOException("Read-only: " + file.getPresentableUrl());
    }

    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "setWritable"));
        }
        throw new IOException("Read-only: " + file.getPresentableUrl());
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "createChildDirectory"));
        }
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "createChildDirectory"));
        }
        throw new IOException(VfsBundle.message((String)"jar.modification.not.supported.error", (Object[])new Object[]{vDir.getUrl()}));
    }

    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "createChildFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "createChildFile"));
        }
        throw new IOException(VfsBundle.message((String)"jar.modification.not.supported.error", (Object[])new Object[]{vDir.getUrl()}));
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "deleteFile"));
        }
    }

    public void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "moveFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "moveFile"));
        }
        throw new IOException(VfsBundle.message((String)"jar.modification.not.supported.error", (Object[])new Object[]{vFile.getUrl()}));
    }

    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "copyFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "copyFile"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "copyFile"));
        }
        throw new IOException(VfsBundle.message((String)"jar.modification.not.supported.error", (Object[])new Object[]{vFile.getUrl()}));
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "renameFile"));
        }
        throw new IOException(VfsBundle.message((String)"jar.modification.not.supported.error", (Object[])new Object[]{vFile.getUrl()}));
    }

    public int getRank() {
        return 2;
    }

    public void refresh(boolean asynchronous) {
        RefreshQueue.getInstance().refresh(asynchronous, true, null, ManagingFS.getInstance().getRoots((NewVirtualFileSystem)this));
    }

    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "findFileByPath"));
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "findFileByPathIfCached"));
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path);
    }

    protected String normalize(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "normalize"));
        }
        int jarSeparatorIndex = path.indexOf("!/");
        if (jarSeparatorIndex > 0) {
            String root = path.substring(0, jarSeparatorIndex);
            return FileUtil.normalize((String)root) + path.substring(jarSeparatorIndex);
        }
        return super.normalize(path);
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "refreshAndFindFileByPath"));
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path);
    }

    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl", "getAttributes"));
        }
        JarHandler handler = this.getHandler(file);
        if (handler == null) {
            return null;
        }
        if (file.getParent() == null) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            VirtualFile originalFile = localFileSystem.findFileByIoFile(handler.getOriginalFile());
            if (originalFile == null) {
                return null;
            }
            FileAttributes attributes = localFileSystem.getAttributes(originalFile);
            if (attributes == null) {
                return null;
            }
            return new FileAttributes(true, false, false, false, attributes.length, attributes.lastModified, attributes.isWritable());
        }
        return handler.getAttributes(file);
    }

    static /* synthetic */ String[] access$202(JarFileSystemImpl x0, String[] x1) {
        x0.jarPathsCache = x1;
        return x1;
    }

    private static final class JarFileSystemImplLock {
        private JarFileSystemImplLock() {
        }
    }
}

