/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpVirtualFileListener;
import com.intellij.openapi.vfs.impl.http.DefaultRemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.HttpFileSystemBase;
import com.intellij.openapi.vfs.impl.http.HttpFileSystemImpl;
import com.intellij.openapi.vfs.impl.http.HttpsFileSystem;
import com.intellij.openapi.vfs.impl.http.LocalFileStorage;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfoImpl;
import com.intellij.openapi.vfs.impl.http.RemoteFileManager;
import com.intellij.openapi.vfs.impl.http.VirtualFileImpl;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Url;
import gnu.trove.THashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RemoteFileManagerImpl
extends RemoteFileManager
implements Disposable {
    private final LocalFileStorage myStorage;
    private final Map<Pair<Boolean, Url>, VirtualFileImpl> myRemoteFiles = new THashMap();
    private final EventDispatcher<HttpVirtualFileListener> myDispatcher = EventDispatcher.create(HttpVirtualFileListener.class);
    private final List<RemoteContentProvider> myProviders = new ArrayList<RemoteContentProvider>();
    private final DefaultRemoteContentProvider myDefaultRemoteContentProvider;

    public RemoteFileManagerImpl() {
        this.myStorage = new LocalFileStorage();
        this.myDefaultRemoteContentProvider = new DefaultRemoteContentProvider();
    }

    @NotNull
    public RemoteContentProvider findContentProvider(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "findContentProvider"));
        }
        for (RemoteContentProvider provider : this.myProviders) {
            if (!provider.canProvideContent(url)) continue;
            RemoteContentProvider remoteContentProvider = provider;
            if (remoteContentProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "findContentProvider"));
            }
            return remoteContentProvider;
        }
        DefaultRemoteContentProvider defaultRemoteContentProvider = this.myDefaultRemoteContentProvider;
        if (defaultRemoteContentProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "findContentProvider"));
        }
        return defaultRemoteContentProvider;
    }

    public synchronized VirtualFileImpl getOrCreateFile(@NotNull Url url, @NotNull String path, boolean directory) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "getOrCreateFile"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "getOrCreateFile"));
        }
        Pair key = Pair.create((Object)directory, (Object)url);
        VirtualFileImpl file = this.myRemoteFiles.get(key);
        if (file == null) {
            if (!directory) {
                RemoteFileInfoImpl fileInfo = new RemoteFileInfoImpl(url, this);
                file = new VirtualFileImpl(RemoteFileManagerImpl.getHttpFileSystem(url), path, fileInfo);
                fileInfo.addDownloadingListener(new MyDownloadingListener(file));
            } else {
                file = new VirtualFileImpl(RemoteFileManagerImpl.getHttpFileSystem(url), path, null);
            }
            this.myRemoteFiles.put((Pair<Boolean, Url>)key, file);
        }
        return file;
    }

    private static HttpFileSystemBase getHttpFileSystem(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "getHttpFileSystem"));
        }
        return "https".equals(url.getScheme()) ? HttpsFileSystem.getHttpsInstance() : HttpFileSystemImpl.getInstanceImpl();
    }

    @Override
    public void addRemoteContentProvider(final @NotNull RemoteContentProvider provider, @NotNull Disposable parentDisposable) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "addRemoteContentProvider"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "addRemoteContentProvider"));
        }
        this.addRemoteContentProvider(provider);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                RemoteFileManagerImpl.this.removeRemoteContentProvider(provider);
            }
        });
    }

    @Override
    public void addRemoteContentProvider(@NotNull RemoteContentProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "addRemoteContentProvider"));
        }
        this.myProviders.add(provider);
    }

    @Override
    public void removeRemoteContentProvider(@NotNull RemoteContentProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "removeRemoteContentProvider"));
        }
        this.myProviders.remove(provider);
    }

    @Override
    public void addFileListener(@NotNull HttpVirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "addFileListener"));
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void addFileListener(final @NotNull HttpVirtualFileListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "addFileListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "addFileListener"));
        }
        this.addFileListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                RemoteFileManagerImpl.this.removeFileListener(listener);
            }
        });
    }

    @Override
    public void removeFileListener(@NotNull HttpVirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "removeFileListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void fireFileDownloaded(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl", "fireFileDownloaded"));
        }
        ((HttpVirtualFileListener)this.myDispatcher.getMulticaster()).fileDownloaded(file);
    }

    public LocalFileStorage getStorage() {
        return this.myStorage;
    }

    public void dispose() {
        this.myStorage.deleteDownloadedFiles();
    }

    private class MyDownloadingListener
    extends FileDownloadingAdapter {
        private final VirtualFileImpl myFile;

        public MyDownloadingListener(VirtualFileImpl file) {
            this.myFile = file;
        }

        @Override
        public void fileDownloaded(VirtualFile localFile) {
            RemoteFileManagerImpl.this.fireFileDownloaded(this.myFile);
        }
    }
}

