/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class FilePointerPartNode {
    private static final FilePointerPartNode[] EMPTY_ARRAY = new FilePointerPartNode[0];
    @NotNull
    private String part;
    @NotNull
    private FilePointerPartNode[] children;
    private FilePointerPartNode parent;
    VirtualFilePointerImpl leaf;
    volatile Pair<VirtualFile, String> myFileAndUrl;
    private volatile long myLastUpdated;
    volatile int useCount;
    private int pointersUnder;
    private static volatile boolean DEBUG = ApplicationManager.getApplication().isUnitTestMode();

    FilePointerPartNode(@NotNull String part, FilePointerPartNode parent, Pair<VirtualFile, String> fileAndUrl) {
        if (part == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "<init>"));
        }
        this.myLastUpdated = -1L;
        this.pointersUnder = 1;
        this.part = part;
        this.parent = parent;
        this.children = EMPTY_ARRAY;
        this.myFileAndUrl = fileAndUrl;
    }

    public String toString() {
        return this.part + (this.children.length == 0 ? "" : " -> " + this.children.length);
    }

    boolean getPointersUnder(@NotNull String path, int start, @NotNull List<FilePointerPartNode> out) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "getPointersUnder"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "getPointersUnder"));
        }
        this.checkStructure();
        if (this.pointersUnder == 0) {
            return false;
        }
        int index = this.indexOfFirstDifferentChar(path, start);
        if (index - start == this.part.length() || index == path.length()) {
            if (index == path.length() && this.leaf != null) {
                out.add(this);
            }
            for (FilePointerPartNode child : this.children) {
                child.getPointersUnder(path, index, out);
            }
        }
        return false;
    }

    void checkStructure() {
        if (!DEBUG) {
            return;
        }
        int childSum = 0;
        for (FilePointerPartNode child : this.children) {
            childSum += child.pointersUnder;
            child.checkStructure();
            assert (child.parent == this);
        }
        if (this.leaf != null) {
            ++childSum;
        }
        assert (this.useCount == 0 == (this.leaf == null)) : this.useCount + " - " + (Object)((Object)this.leaf);
        assert (this.pointersUnder == childSum) : "expected: " + this.pointersUnder + "; actual: " + childSum;
    }

    @NotNull
    FilePointerPartNode findPointerOrCreate(@NotNull String path, int start, @NotNull Pair<VirtualFile, String> fileAndUrl) {
        FilePointerPartNode[] filePointerPartNodeArray;
        String pathRest;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "findPointerOrCreate"));
        }
        if (fileAndUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "findPointerOrCreate"));
        }
        int index = this.indexOfFirstDifferentChar(path, start);
        if (index == path.length() && index - start == this.part.length()) {
            if (this.leaf == null) {
                ++this.pointersUnder;
            }
            FilePointerPartNode filePointerPartNode = this;
            if (filePointerPartNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "findPointerOrCreate"));
            }
            return filePointerPartNode;
        }
        if (index - start == this.part.length()) {
            for (FilePointerPartNode child : this.children) {
                int i = child.indexOfFirstDifferentChar(path, index);
                if (i == index || i <= index + 1 && path.charAt(index) == '/') continue;
                FilePointerPartNode node = child.findPointerOrCreate(path, index, fileAndUrl);
                if (node.leaf == null) {
                    ++this.pointersUnder;
                }
                FilePointerPartNode filePointerPartNode = node;
                if (filePointerPartNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "findPointerOrCreate"));
                }
                return filePointerPartNode;
            }
            String pathRest2 = path.substring(index);
            FilePointerPartNode newNode = new FilePointerPartNode(pathRest2, this, fileAndUrl);
            this.children = (FilePointerPartNode[])ArrayUtil.append((Object[])this.children, (Object)newNode);
            ++this.pointersUnder;
            FilePointerPartNode filePointerPartNode = newNode;
            if (filePointerPartNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "findPointerOrCreate"));
            }
            return filePointerPartNode;
        }
        if (index > start && index != path.length() && path.charAt(index - 1) == '/') {
            --index;
        }
        FilePointerPartNode newNode = (pathRest = path.substring(index)).isEmpty() ? this : new FilePointerPartNode(pathRest, this, fileAndUrl);
        String commonPredecessor = StringUtil.first((String)this.part, (int)(index - start), (boolean)false);
        FilePointerPartNode splittedAway = new FilePointerPartNode(this.part.substring(index - start), this, this.myFileAndUrl);
        splittedAway.children = this.children;
        for (FilePointerPartNode child : this.children) {
            child.parent = splittedAway;
        }
        splittedAway.pointersUnder = this.pointersUnder;
        splittedAway.useCount = this.useCount;
        splittedAway.associate(this.leaf, this.myFileAndUrl);
        this.associate(null, null);
        this.useCount = 0;
        this.part = commonPredecessor;
        if (newNode == this) {
            FilePointerPartNode[] filePointerPartNodeArray2 = new FilePointerPartNode[1];
            filePointerPartNodeArray = filePointerPartNodeArray2;
            filePointerPartNodeArray2[0] = splittedAway;
        } else {
            FilePointerPartNode[] filePointerPartNodeArray3 = new FilePointerPartNode[2];
            filePointerPartNodeArray3[0] = splittedAway;
            filePointerPartNodeArray = filePointerPartNodeArray3;
            filePointerPartNodeArray3[1] = newNode;
        }
        this.children = filePointerPartNodeArray;
        ++this.pointersUnder;
        FilePointerPartNode filePointerPartNode = newNode;
        if (filePointerPartNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "findPointerOrCreate"));
        }
        return filePointerPartNode;
    }

    boolean remove() {
        assert (this.leaf != null) : this.toString();
        this.associate(null, null);
        this.useCount = 0;
        this.myLastUpdated = -1L;
        FilePointerPartNode node = this;
        while (node.parent != null) {
            --node.pointersUnder;
            node = node.parent;
        }
        if (--node.pointersUnder == 0) {
            node.children = EMPTY_ARRAY;
            return true;
        }
        return false;
    }

    private int indexOfFirstDifferentChar(@NotNull String path, int start) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "indexOfFirstDifferentChar"));
        }
        return FilePointerPartNode.indexOfFirstDifferentChar(path, start, this.part, 0, !SystemInfo.isFileSystemCaseSensitive);
    }

    @NotNull
    Pair<VirtualFile, String> update() {
        Pair result;
        boolean fileIsValid;
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        long lastUpdated = this.myLastUpdated;
        Pair<VirtualFile, String> fileAndUrl = this.myFileAndUrl;
        long fsModCount = fileManager.getModificationCount();
        if (lastUpdated == fsModCount) {
            Pair<VirtualFile, String> pair = fileAndUrl;
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "update"));
            }
            return pair;
        }
        VirtualFile file = (VirtualFile)fileAndUrl.first;
        String url = (String)fileAndUrl.second;
        if (url == null) {
            url = file.getUrl();
            if (!file.isValid()) {
                file = null;
            }
        }
        boolean bl = fileIsValid = file != null && file.isValid();
        if (file != null && !fileIsValid) {
            file = null;
        }
        if (file == null) {
            file = fileManager.findFileByUrl(url);
            boolean bl2 = fileIsValid = file != null && file.isValid();
        }
        if (file != null) {
            if (fileIsValid) {
                url = file.getUrl();
            } else {
                file = null;
            }
        }
        assert (url != null);
        this.myFileAndUrl = result = Pair.create((Object)file, (Object)url);
        this.myLastUpdated = fsModCount;
        Pair pair = result;
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "update"));
        }
        return pair;
    }

    private static int indexOfFirstDifferentChar(@NotNull String s1, int start1, @NotNull String s2, int start2, boolean ignoreCase) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "indexOfFirstDifferentChar"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "indexOfFirstDifferentChar"));
        }
        int len1 = s1.length();
        int len2 = s2.length();
        while (start1 < len1 && start2 < len2) {
            char c1 = s1.charAt(start1);
            char c2 = s2.charAt(start2);
            if (ignoreCase ? !StringUtil.charsEqualIgnoreCase((char)c1, (char)c2) : c1 != c2) {
                return start1;
            }
            ++start1;
            ++start2;
        }
        return start1;
    }

    void associate(VirtualFilePointerImpl pointer, Pair<VirtualFile, String> fileAndUrl) {
        if (pointer != null) {
            pointer.myNode = this;
        }
        this.leaf = pointer;
        this.myFileAndUrl = fileAndUrl;
        this.myLastUpdated = -1L;
    }

    int incrementUsageCount(int delta) {
        return this.useCount += delta;
    }

    int getPointersUnder() {
        return this.pointersUnder;
    }

    public static void pushDebug(boolean newDebug, @NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "pushDebug"));
        }
        final boolean oldDebug = DEBUG;
        DEBUG = newDebug;
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                DEBUG = oldDebug;
            }
        });
    }
}

