/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.concurrency.Semaphore;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshVFsSynchronously {
    private RefreshVFsSynchronously() {
    }

    public static void updateAllChanged(@NotNull UpdatedFiles updatedFiles) {
        if (updatedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/update/RefreshVFsSynchronously", "updateAllChanged"));
        }
        FilesToRefreshCollector callback = new FilesToRefreshCollector();
        UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(updatedFiles, callback);
        for (File file : callback.getToRefreshDeletedOrReplaced()) {
            RefreshVFsSynchronously.refreshDeletedOrReplaced(file);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LocalFileSystem.getInstance().refreshIoFiles(callback.getToRefresh(), false, false, null);
            return;
        }
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        try {
            LocalFileSystem.getInstance().refreshIoFiles(callback.getToRefresh(), true, false, new Runnable(){

                @Override
                public void run() {
                    semaphore.up();
                }
            });
        }
        catch (Throwable t) {
            semaphore.up();
            throw new RuntimeException(t);
        }
        semaphore.waitFor();
    }

    @Nullable
    public static VirtualFile findCreatedFile(File root) {
        RefreshVFsSynchronously.refresh(root);
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        return lfs.findFileByIoFile(root);
    }

    private static void refresh(File root) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile vFile = lfs.refreshAndFindFileByIoFile(root);
        if (vFile != null) {
            vFile.refresh(false, false);
            return;
        }
    }

    private static void refreshDeletedOrReplaced(File root) {
        File parent = root.getParentFile();
        VirtualFile vf = null;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile rootVf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(root);
        if (parent != null) {
            vf = localFileSystem.refreshAndFindFileByIoFile(parent);
        }
        if (vf == null) {
            vf = rootVf;
        }
        if (vf != null) {
            ((NewVirtualFile)vf).markDirtyRecursively();
            vf.refresh(false, true);
        }
    }

    public static void updateChangesForRollback(List<Change> changes) {
        RefreshVFsSynchronously.updateChangesImpl(changes, RollbackChangeWrapper.ourInstance);
    }

    public static void updateChanges(List<Change> changes) {
        RefreshVFsSynchronously.updateChangesImpl(changes, DirectChangeWrapper.ourInstance);
    }

    private static void updateChangesImpl(List<Change> changes, ChangeWrapper wrapper) {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.setIndeterminate(false);
        }
        double num = changes.size();
        int cnt = 0;
        for (Change change : changes) {
            if (!wrapper.beforeNull(change) && (wrapper.movedOrRenamedOrReplaced(change) || wrapper.afterNull(change))) {
                RefreshVFsSynchronously.refreshDeletedOrReplaced(wrapper.getBeforeFile(change));
            } else if (!wrapper.beforeNull(change)) {
                RefreshVFsSynchronously.refresh(wrapper.getBeforeFile(change));
            }
            if (!(wrapper.afterNull(change) || !wrapper.beforeNull(change) && Comparing.equal((Object)change.getAfterRevision().getFile(), (Object)change.getBeforeRevision().getFile()))) {
                RefreshVFsSynchronously.refresh(wrapper.getAfterFile(change));
            }
            if (pi == null) continue;
            pi.setFraction((double)(++cnt) / num);
            pi.setText2("Refreshing: " + change.toString());
        }
    }

    private static class FilesToRefreshCollector
    implements UpdateFilesHelper.Callback {
        private final Collection<File> myToRefresh = new THashSet();
        private final Collection<File> myToRefreshDeletedOrReplaced = new THashSet();

        private FilesToRefreshCollector() {
        }

        @Override
        public void onFile(String filePath, String groupId) {
            File file = new File(filePath);
            if ("REMOVED_FROM_REPOSITORY".equals(groupId) || "MERGED_WITH_TREE_CONFLICT".endsWith(groupId)) {
                this.myToRefreshDeletedOrReplaced.add(file);
            } else {
                this.myToRefresh.add(file);
            }
        }

        @NotNull
        public Collection<File> getToRefresh() {
            Collection<File> collection = this.myToRefresh;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/RefreshVFsSynchronously$FilesToRefreshCollector", "getToRefresh"));
            }
            return collection;
        }

        @NotNull
        public Collection<File> getToRefreshDeletedOrReplaced() {
            Collection<File> collection = this.myToRefreshDeletedOrReplaced;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/RefreshVFsSynchronously$FilesToRefreshCollector", "getToRefreshDeletedOrReplaced"));
            }
            return collection;
        }
    }

    private static interface ChangeWrapper {
        public boolean beforeNull(Change var1);

        public boolean afterNull(Change var1);

        @Nullable
        public File getBeforeFile(Change var1);

        @Nullable
        public File getAfterFile(Change var1);

        public boolean movedOrRenamedOrReplaced(Change var1);
    }

    private static class DirectChangeWrapper
    implements ChangeWrapper {
        private static final DirectChangeWrapper ourInstance = new DirectChangeWrapper();

        private DirectChangeWrapper() {
        }

        @Override
        public boolean beforeNull(Change change) {
            return change.getBeforeRevision() == null;
        }

        @Override
        public boolean afterNull(Change change) {
            return change.getAfterRevision() == null;
        }

        @Override
        @Nullable
        public File getBeforeFile(Change change) {
            return this.beforeNull(change) ? null : change.getBeforeRevision().getFile().getIOFile();
        }

        @Override
        @Nullable
        public File getAfterFile(Change change) {
            return this.afterNull(change) ? null : change.getAfterRevision().getFile().getIOFile();
        }

        @Override
        public boolean movedOrRenamedOrReplaced(Change change) {
            return change.isMoved() || change.isRenamed() || change.isIsReplaced();
        }
    }

    private static class RollbackChangeWrapper
    implements ChangeWrapper {
        private static final RollbackChangeWrapper ourInstance = new RollbackChangeWrapper();

        private RollbackChangeWrapper() {
        }

        @Override
        public boolean beforeNull(Change change) {
            return change.getAfterRevision() == null;
        }

        @Override
        public boolean afterNull(Change change) {
            return change.getBeforeRevision() == null;
        }

        @Override
        public File getBeforeFile(Change change) {
            return this.beforeNull(change) ? null : change.getAfterRevision().getFile().getIOFile();
        }

        @Override
        public File getAfterFile(Change change) {
            return this.afterNull(change) ? null : change.getBeforeRevision().getFile().getIOFile();
        }

        @Override
        public boolean movedOrRenamedOrReplaced(Change change) {
            return change.isMoved() || change.isRenamed() || change.isIsReplaced();
        }
    }
}

