/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.roots.VcsRootProblemNotifier;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBus;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class VcsRootScanner
implements BulkFileListener,
ModuleRootListener,
VcsListener {
    @NotNull
    private final VcsRootProblemNotifier myRootProblemNotifier;
    @NotNull
    private final VcsRootChecker[] myCheckers;
    private volatile boolean myProjectIsInitialized;
    private volatile boolean myMappingsAreReady;
    @NotNull
    private final Alarm myAlarm;
    private static final long WAIT_BEFORE_SCAN = TimeUnit.SECONDS.toMillis(1L);

    public static void start(@NotNull Project project, @NotNull VcsRootChecker[] checkers) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/roots/VcsRootScanner", "start"));
        }
        if (checkers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/roots/VcsRootScanner", "start"));
        }
        new VcsRootScanner(project, checkers);
    }

    private VcsRootScanner(@NotNull Project project, @NotNull VcsRootChecker[] checkers) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/roots/VcsRootScanner", "<init>"));
        }
        if (checkers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/roots/VcsRootScanner", "<init>"));
        }
        this.myRootProblemNotifier = VcsRootProblemNotifier.getInstance(project);
        this.myCheckers = checkers;
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

            public void run() {
                VcsRootScanner.this.myProjectIsInitialized = true;
                VcsRootScanner.this.scanIfReady();
            }
        });
        MessageBus messageBus = project.getMessageBus();
        messageBus.connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
        messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        messageBus.connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)this);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/roots/VcsRootScanner", "before"));
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/roots/VcsRootScanner", "after"));
        }
        block0: for (VFileEvent vFileEvent : events) {
            String filePath = vFileEvent.getPath();
            for (VcsRootChecker checker : this.myCheckers) {
                if (!checker.isVcsDir(filePath)) continue;
                this.scanIfReady();
                continue block0;
            }
        }
    }

    public void beforeRootsChange(ModuleRootEvent event) {
    }

    public void rootsChanged(ModuleRootEvent event) {
        this.scanIfReady();
    }

    public void directoryMappingChanged() {
        this.myMappingsAreReady = true;
        this.scanIfReady();
    }

    private void scanIfReady() {
        if (this.readyToScan()) {
            this.scheduleScan();
        }
    }

    private boolean readyToScan() {
        return this.myMappingsAreReady && this.myProjectIsInitialized;
    }

    private void scheduleScan() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                VcsRootScanner.this.myRootProblemNotifier.rescanAndNotifyIfNeeded();
            }
        }, WAIT_BEFORE_SCAN);
    }
}

