/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootDetectorImpl
implements VcsRootDetector {
    private static final int MAXIMUM_SCAN_DEPTH = 2;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectRootManager myProjectManager;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final VcsRootChecker[] myCheckers;

    public VcsRootDetectorImpl(@NotNull Project project, @NotNull ProjectRootManager projectRootManager, @NotNull ProjectLevelVcsManager projectLevelVcsManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "<init>"));
        }
        if (projectRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "<init>"));
        }
        if (projectLevelVcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "<init>"));
        }
        this.myProject = project;
        this.myProjectManager = projectRootManager;
        this.myVcsManager = projectLevelVcsManager;
        this.myCheckers = (VcsRootChecker[])Extensions.getExtensions((ExtensionPointName)VcsRootChecker.EXTENSION_POINT_NAME);
    }

    @NotNull
    public Collection<VcsRoot> detect() {
        Collection<VcsRoot> collection = this.detect(this.myProject.getBaseDir());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "detect"));
        }
        return collection;
    }

    @NotNull
    public Collection<VcsRoot> detect(@Nullable VirtualFile startDir) {
        if (startDir == null || this.myCheckers.length == 0) {
            List<VcsRoot> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "detect"));
            }
            return list;
        }
        Set<VcsRoot> roots = this.scanForRootsInsideDir(startDir);
        roots.addAll(this.scanForRootsInContentRoots());
        for (VcsRoot root : roots) {
            if (!startDir.equals(root.getPath())) continue;
            Set<VcsRoot> set = roots;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "detect"));
            }
            return set;
        }
        List<VcsRoot> rootsAbove = this.scanForSingleRootAboveDir(startDir);
        roots.addAll(rootsAbove);
        Set<VcsRoot> set = roots;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "detect"));
        }
        return set;
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInContentRoots() {
        VirtualFile[] roots;
        HashSet<VcsRoot> vcsRoots = new HashSet<VcsRoot>();
        for (VirtualFile contentRoot : roots = this.myProjectManager.getContentRoots()) {
            Set<VcsRoot> rootsInsideRoot = this.scanForRootsInsideDir(contentRoot);
            boolean shouldScanAbove = true;
            for (VcsRoot root : rootsInsideRoot) {
                if (!contentRoot.equals(root.getPath())) continue;
                shouldScanAbove = false;
            }
            if (shouldScanAbove) {
                List<VcsRoot> rootsAbove = this.scanForSingleRootAboveDir(contentRoot);
                rootsInsideRoot.addAll(rootsAbove);
            }
            vcsRoots.addAll(rootsInsideRoot);
        }
        HashSet<VcsRoot> hashSet = vcsRoots;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInContentRoots"));
        }
        return hashSet;
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInsideDir(@NotNull VirtualFile dir, int depth) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInsideDir"));
        }
        HashSet<VcsRoot> roots = new HashSet<VcsRoot>();
        if (depth > 2) {
            HashSet<VcsRoot> hashSet = roots;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInsideDir"));
            }
            return hashSet;
        }
        if (this.myProject.isDisposed() || !dir.isDirectory()) {
            HashSet<VcsRoot> hashSet = roots;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInsideDir"));
            }
            return hashSet;
        }
        List<AbstractVcs> vcsList = this.getVcsListFor(dir);
        for (AbstractVcs vcs : vcsList) {
            roots.add(new VcsRoot(vcs, dir));
        }
        for (VirtualFile child : dir.getChildren()) {
            roots.addAll(this.scanForRootsInsideDir(child, depth + 1));
        }
        HashSet<VcsRoot> hashSet = roots;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInsideDir"));
        }
        return hashSet;
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInsideDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInsideDir"));
        }
        Set<VcsRoot> set = this.scanForRootsInsideDir(dir, 0);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInsideDir"));
        }
        return set;
    }

    @NotNull
    private List<VcsRoot> scanForSingleRootAboveDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForSingleRootAboveDir"));
        }
        ArrayList<VcsRoot> roots = new ArrayList<VcsRoot>();
        if (this.myProject.isDisposed()) {
            ArrayList<VcsRoot> arrayList = roots;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForSingleRootAboveDir"));
            }
            return arrayList;
        }
        for (VirtualFile par = dir.getParent(); par != null; par = par.getParent()) {
            List<AbstractVcs> vcsList = this.getVcsListFor(par);
            for (AbstractVcs vcs : vcsList) {
                roots.add(new VcsRoot(vcs, par));
            }
            if (roots.isEmpty()) continue;
            ArrayList<VcsRoot> arrayList = roots;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForSingleRootAboveDir"));
            }
            return arrayList;
        }
        ArrayList<VcsRoot> arrayList = roots;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForSingleRootAboveDir"));
        }
        return arrayList;
    }

    @NotNull
    private List<AbstractVcs> getVcsListFor(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "getVcsListFor"));
        }
        ArrayList<AbstractVcs> vcsList = new ArrayList<AbstractVcs>();
        for (VcsRootChecker checker : this.myCheckers) {
            if (!checker.isRoot(dir.getPath())) continue;
            vcsList.add(this.myVcsManager.findVcsByName(checker.getSupportedVcs().getName()));
        }
        ArrayList<AbstractVcs> arrayList = vcsList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "getVcsListFor"));
        }
        return arrayList;
    }
}

