/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class VcsManagerPerModuleConfiguration
implements JDOMExternalizable,
ModuleComponent {
    private final Module myModule;
    public String ACTIVE_VCS_NAME = "";
    public boolean USE_PROJECT_VCS = true;

    public static VcsManagerPerModuleConfiguration getInstance(Module module) {
        return (VcsManagerPerModuleConfiguration)module.getComponent(VcsManagerPerModuleConfiguration.class);
    }

    public VcsManagerPerModuleConfiguration(Module module) {
        this.myModule = module;
    }

    public void moduleAdded() {
    }

    public void projectClosed() {
    }

    public void projectOpened() {
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("VcsManagerConfiguration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/VcsManagerPerModuleConfiguration", "getComponentName"));
        }
        return "VcsManagerConfiguration";
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        final ProjectLevelVcsManagerImpl vcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManagerEx.getInstanceEx(this.myModule.getProject());
        if (!this.USE_PROJECT_VCS) {
            final VirtualFile[] roots = ModuleRootManager.getInstance((Module)this.myModule).getContentRoots();
            StartupManager.getInstance((Project)this.myModule.getProject()).runWhenProjectIsInitialized(new Runnable(){

                @Override
                public void run() {
                    for (VirtualFile file : roots) {
                        vcsManager.setDirectoryMapping(file.getPath(), VcsManagerPerModuleConfiguration.this.ACTIVE_VCS_NAME);
                    }
                    vcsManager.cleanupMappings();
                }
            });
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        throw new WriteExternalException();
    }
}

