/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class VcsInitialization {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.VcsInitialization");
    private final Project myProject;
    private final List<Pair<VcsInitObject, Runnable>> myList;
    private final Object myLock = new Object();
    private boolean myInitStarted;

    public VcsInitialization(Project project) {
        this.myProject = project;
        this.myList = new LinkedList<Pair<VcsInitObject, Runnable>>();
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                if (VcsInitialization.this.myProject.isDisposed()) {
                    return;
                }
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!VcsInitialization.this.myProject.isDisposed()) {
                            VcsInitialization.this.execute();
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(VcsInitObject vcsInitObject, Runnable runnable) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myInitStarted) {
                if (!vcsInitObject.isCanBeLast()) {
                    LOG.info("Registering startup activity AFTER initialization ", new Throwable());
                }
                ApplicationManager.getApplication().invokeLater(runnable);
                return;
            }
            this.myList.add((Pair<VcsInitObject, Runnable>)new Pair((Object)vcsInitObject, (Object)runnable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        List<Pair<VcsInitObject, Runnable>> list;
        Object object = this.myLock;
        synchronized (object) {
            list = this.myList;
            this.myInitStarted = true;
        }
        Collections.sort(list, new Comparator<Pair<VcsInitObject, Runnable>>(){

            @Override
            public int compare(Pair<VcsInitObject, Runnable> o1, Pair<VcsInitObject, Runnable> o2) {
                return new Integer(((VcsInitObject)((Object)o1.getFirst())).getOrder()).compareTo(new Integer(((VcsInitObject)((Object)o2.getFirst())).getOrder()));
            }
        });
        for (Pair<VcsInitObject, Runnable> pair : list) {
            ((Runnable)pair.getSecond()).run();
        }
    }
}

