/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsEventsListenerManager;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootSettings;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowConfirmationOptionImpl;
import com.intellij.openapi.vcs.VcsShowOptionsSettingImpl;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.VirtualFileFilter;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListenerImpl;
import com.intellij.openapi.vcs.checkout.CompositeCheckoutListener;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsEnvironmentsProxyCreator;
import com.intellij.openapi.vcs.impl.VcsEventsListenerManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsInitialization;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.MappingsToRoots;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vcs.impl.projectlevelman.OptionsAndConfirmations;
import com.intellij.openapi.vcs.impl.projectlevelman.ProjectLevelVcsManagerSerialization;
import com.intellij.openapi.vcs.roots.VcsRootScanner;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.UpdatedFilesListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentsUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.Convertor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EditorAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectLevelVcsManagerImpl
extends ProjectLevelVcsManagerEx
implements ProjectComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl");
    @NonNls
    public static final String SETTINGS_EDITED_MANUALLY = "settingsEditedManually";
    private final ProjectLevelVcsManagerSerialization mySerialization;
    private final OptionsAndConfirmations myOptionsAndConfirmations;
    private final NewMappings myMappings;
    private final Project myProject;
    private final MessageBus myMessageBus;
    private final MappingsToRoots myMappingsToRoots;
    private ContentManager myContentManager;
    private EditorAdapter myEditorAdapter;
    private final VcsInitialization myInitialization;
    @NonNls
    private static final String ELEMENT_MAPPING = "mapping";
    @NonNls
    private static final String ATTRIBUTE_DIRECTORY = "directory";
    @NonNls
    private static final String ATTRIBUTE_VCS = "vcs";
    @NonNls
    private static final String ATTRIBUTE_DEFAULT_PROJECT = "defaultProject";
    @NonNls
    private static final String ELEMENT_ROOT_SETTINGS = "rootSettings";
    @NonNls
    private static final String ATTRIBUTE_CLASS = "class";
    private boolean myMappingsLoaded = false;
    private boolean myHaveLegacyVcsConfiguration = false;
    private final DefaultVcsRootPolicy myDefaultVcsRootPolicy;
    private volatile int myBackgroundOperationCounter = 0;
    private final Map<VcsBackgroundableActions, BackgroundableActionEnabledHandler> myBackgroundableActionHandlerMap;
    private final List<Pair<String, TextAttributes>> myPendingOutput = new ArrayList<Pair<String, TextAttributes>>();
    private VcsEventsListenerManagerImpl myVcsEventListenerManager;
    private final VcsHistoryCache myVcsHistoryCache;
    private final ContentRevisionCache myContentRevisionCache;
    private final MessageBusConnection myConnect;
    private final FileIndexFacade myExcludedIndex;
    private final VcsFileListenerContextHelper myVcsFileListenerContextHelper;
    private final VcsAnnotationLocalChangesListenerImpl myAnnotationLocalChangesListener;
    private final Map<VcsListener, MessageBusConnection> myAdapters = new HashMap<VcsListener, MessageBusConnection>();

    public ProjectLevelVcsManagerImpl(Project project, FileStatusManager manager, MessageBus messageBus, FileIndexFacade excludedFileIndex) {
        this.myProject = project;
        this.myMessageBus = messageBus;
        this.mySerialization = new ProjectLevelVcsManagerSerialization();
        this.myOptionsAndConfirmations = new OptionsAndConfirmations();
        this.myDefaultVcsRootPolicy = DefaultVcsRootPolicy.getInstance(project);
        this.myBackgroundableActionHandlerMap = new EnumMap<VcsBackgroundableActions, BackgroundableActionEnabledHandler>(VcsBackgroundableActions.class);
        this.myInitialization = new VcsInitialization(this.myProject);
        this.myMappings = new NewMappings(this.myProject, this.myMessageBus, this, manager, excludedFileIndex);
        this.myMappingsToRoots = new MappingsToRoots(this.myMappings, this.myProject);
        if (!this.myProject.isDefault()) {
            this.myVcsEventListenerManager = new VcsEventsListenerManagerImpl();
        }
        this.myVcsHistoryCache = new VcsHistoryCache();
        this.myContentRevisionCache = new ContentRevisionCache();
        this.myConnect = this.myMessageBus.connect();
        this.myVcsFileListenerContextHelper = VcsFileListenerContextHelper.getInstance((Project)this.myProject);
        VcsListener vcsListener = new VcsListener(){

            public void directoryMappingChanged() {
                ProjectLevelVcsManagerImpl.this.myVcsHistoryCache.clear();
                ProjectLevelVcsManagerImpl.this.myVcsFileListenerContextHelper.possiblySwitchActivation(ProjectLevelVcsManagerImpl.this.hasActiveVcss());
            }
        };
        this.myExcludedIndex = excludedFileIndex;
        this.myConnect.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
        this.myConnect.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, (Object)vcsListener);
        this.myConnect.subscribe(UpdatedFilesListener.UPDATED_FILES, (Object)new UpdatedFilesListener(){

            public void consume(Set<String> strings) {
                ProjectLevelVcsManagerImpl.this.myContentRevisionCache.clearCurrent(strings);
            }
        });
        this.myAnnotationLocalChangesListener = new VcsAnnotationLocalChangesListenerImpl(this.myProject, this);
    }

    public void initComponent() {
        this.myOptionsAndConfirmations.init(new Convertor<String, VcsShowConfirmationOption.Value>(){

            public VcsShowConfirmationOption.Value convert(String o) {
                return ProjectLevelVcsManagerImpl.this.mySerialization.getInitOptionValue(o);
            }
        });
    }

    public void registerVcs(AbstractVcs vcs) {
        AllVcses.getInstance(this.myProject).registerManually(vcs);
    }

    @Nullable
    public AbstractVcs findVcsByName(String name) {
        if (name == null) {
            return null;
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        return AllVcses.getInstance(this.myProject).getByName(name);
    }

    @Nullable
    public VcsDescriptor getDescriptor(String name) {
        if (name == null) {
            return null;
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        return AllVcses.getInstance(this.myProject).getDescriptor(name);
    }

    public void iterateVfUnderVcsRoot(VirtualFile file, Processor<VirtualFile> processor) {
        VcsRootIterator.iterateVfUnderVcsRoot(this.myProject, file, processor);
    }

    public VcsDescriptor[] getAllVcss() {
        return AllVcses.getInstance(this.myProject).getAll();
    }

    public boolean haveVcses() {
        return !AllVcses.getInstance(this.myProject).isEmpty();
    }

    public void disposeComponent() {
        this.releaseEditor();
        this.myMappings.disposeMe();
        this.myConnect.disconnect();
        Disposer.dispose((Disposable)this.myAnnotationLocalChangesListener);
        this.myContentManager = null;
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (toolWindowManager != null && toolWindowManager.getToolWindow(ToolWindowId.VCS) != null) {
            toolWindowManager.unregisterToolWindow(ToolWindowId.VCS);
        }
    }

    @NotNull
    public VcsAnnotationLocalChangesListener getAnnotationLocalChangesListener() {
        VcsAnnotationLocalChangesListenerImpl vcsAnnotationLocalChangesListenerImpl = this.myAnnotationLocalChangesListener;
        if (vcsAnnotationLocalChangesListenerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getAnnotationLocalChangesListener"));
        }
        return vcsAnnotationLocalChangesListenerImpl;
    }

    public void projectOpened() {
        StartupManager manager = StartupManager.getInstance((Project)this.myProject);
        manager.registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                VcsRootChecker[] checkers;
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)ProjectLevelVcsManagerImpl.this.myProject);
                if (toolWindowManager != null) {
                    ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.VCS, true, ToolWindowAnchor.BOTTOM, (Disposable)ProjectLevelVcsManagerImpl.this.myProject, true);
                    ProjectLevelVcsManagerImpl.this.myContentManager = toolWindow.getContentManager();
                    toolWindow.setIcon(AllIcons.Toolwindows.VcsSmallTab);
                    toolWindow.installWatcher(ProjectLevelVcsManagerImpl.this.myContentManager);
                } else {
                    ProjectLevelVcsManagerImpl.this.myContentManager = ContentFactory.SERVICE.getInstance().createContentManager(true, ProjectLevelVcsManagerImpl.this.myProject);
                }
                if (!ApplicationManager.getApplication().isUnitTestMode() && (checkers = (VcsRootChecker[])Extensions.getExtensions((ExtensionPointName)VcsRootChecker.EXTENSION_POINT_NAME)).length != 0) {
                    VcsRootScanner.start(ProjectLevelVcsManagerImpl.this.myProject, checkers);
                }
            }
        });
    }

    public void projectClosed() {
        this.releaseEditor();
    }

    @NotNull
    public String getComponentName() {
        if ("ProjectLevelVcsManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getComponentName"));
        }
        return "ProjectLevelVcsManager";
    }

    public boolean checkAllFilesAreUnder(AbstractVcs abstractVcs, VirtualFile[] files) {
        if (files == null) {
            return false;
        }
        for (VirtualFile file : files) {
            if (this.getVcsFor(file) == abstractVcs) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public AbstractVcs getVcsFor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getVcsFor"));
        }
        String vcsName = this.myMappings.getVcsFor(file);
        if (vcsName == null || vcsName.isEmpty()) {
            return null;
        }
        return AllVcses.getInstance(this.myProject).getByName(vcsName);
    }

    @Nullable
    public AbstractVcs getVcsFor(FilePath file) {
        final VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)file);
        return (AbstractVcs)ApplicationManager.getApplication().runReadAction((Computable)new Computable<AbstractVcs>(){

            @Nullable
            public AbstractVcs compute() {
                if (!ApplicationManager.getApplication().isUnitTestMode() && !ProjectLevelVcsManagerImpl.this.myProject.isInitialized()) {
                    return null;
                }
                if (ProjectLevelVcsManagerImpl.this.myProject.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                if (vFile != null) {
                    return ProjectLevelVcsManagerImpl.this.getVcsFor(vFile);
                }
                return null;
            }
        });
    }

    @Nullable
    public VirtualFile getVcsRootFor(@Nullable VirtualFile file) {
        VcsDirectoryMapping mapping = this.myMappings.getMappingFor(file);
        if (mapping == null) {
            return null;
        }
        String directory = mapping.getDirectory();
        if (directory.isEmpty()) {
            return this.myDefaultVcsRootPolicy.getVcsRootFor(file);
        }
        return LocalFileSystem.getInstance().findFileByPath(directory);
    }

    @Nullable
    public VcsRoot getVcsRootObjectFor(VirtualFile file) {
        VcsDirectoryMapping mapping = this.myMappings.getMappingFor(file);
        if (mapping == null) {
            return null;
        }
        String directory = mapping.getDirectory();
        AbstractVcs vcs = this.findVcsByName(mapping.getVcs());
        if (directory.isEmpty()) {
            return new VcsRoot(vcs, this.myDefaultVcsRootPolicy.getVcsRootFor(file));
        }
        return new VcsRoot(vcs, LocalFileSystem.getInstance().findFileByPath(directory));
    }

    @Nullable
    public VirtualFile getVcsRootFor(FilePath file) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)file);
        if (vFile != null) {
            return this.getVcsRootFor(vFile);
        }
        return null;
    }

    public VcsRoot getVcsRootObjectFor(FilePath file) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)file);
        if (vFile != null) {
            return this.getVcsRootObjectFor(vFile);
        }
        return null;
    }

    public void unregisterVcs(AbstractVcs vcs) {
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myMappings.haveActiveVcs(vcs.getName())) {
            LOG.warn("Active vcs '" + vcs.getName() + "' is being unregistered. Remove from mappings first.");
        }
        this.myMappings.beingUnregistered(vcs.getName());
        AllVcses.getInstance(this.myProject).unregisterManually(vcs);
    }

    @Override
    public ContentManager getContentManager() {
        return this.myContentManager;
    }

    public boolean checkVcsIsActive(AbstractVcs vcs) {
        return this.checkVcsIsActive(vcs.getName());
    }

    public boolean checkVcsIsActive(String vcsName) {
        return this.myMappings.haveActiveVcs(vcsName);
    }

    public AbstractVcs[] getAllActiveVcss() {
        return this.myMappings.getActiveVcses();
    }

    public boolean hasActiveVcss() {
        return this.myMappings.hasActiveVcss();
    }

    public boolean hasAnyMappings() {
        return !this.myMappings.isEmpty();
    }

    public void addMessageToConsoleWindow(final String message, final TextAttributes attributes) {
        if (!Registry.is((String)"vcs.showConsole")) {
            return;
        }
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProjectLevelVcsManagerImpl.this.myProject.isDisposed() || ProjectLevelVcsManagerImpl.this.myProject.isDefault()) {
                    return;
                }
                ContentManager contentManager = ProjectLevelVcsManagerImpl.this.getContentManager();
                if (contentManager == null) {
                    ProjectLevelVcsManagerImpl.this.myPendingOutput.add(new Pair((Object)message, (Object)attributes));
                } else {
                    ProjectLevelVcsManagerImpl.this.getOrCreateConsoleContent(contentManager);
                    ProjectLevelVcsManagerImpl.this.myEditorAdapter.appendString(message, attributes);
                }
            }
        }, ModalityState.defaultModalityState());
    }

    private Content getOrCreateConsoleContent(ContentManager contentManager) {
        String displayName = VcsBundle.message((String)"vcs.console.toolwindow.display.name", (Object[])new Object[0]);
        Content content = contentManager.findContent(displayName);
        if (content == null) {
            this.releaseEditor();
            EditorFactory editorFactory = EditorFactory.getInstance();
            Editor editor = editorFactory.createViewer(editorFactory.createDocument((CharSequence)""), this.myProject);
            EditorSettings editorSettings = editor.getSettings();
            editorSettings.setLineMarkerAreaShown(false);
            editorSettings.setIndentGuidesShown(false);
            editorSettings.setLineNumbersShown(false);
            editorSettings.setFoldingOutlineShown(false);
            ((EditorEx)editor).getScrollPane().setBorder(null);
            this.myEditorAdapter = new EditorAdapter(editor, this.myProject, false);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)editor.getComponent(), "Center");
            content = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel, displayName, true);
            contentManager.addContent(content);
            for (Pair<String, TextAttributes> pair : this.myPendingOutput) {
                this.myEditorAdapter.appendString((String)pair.first, (TextAttributes)pair.second);
            }
            this.myPendingOutput.clear();
        }
        return content;
    }

    private void releaseEditor() {
        Editor editor;
        if (this.myEditorAdapter != null && !(editor = this.myEditorAdapter.getEditor()).isDisposed()) {
            EditorFactory.getInstance().releaseEditor(editor);
        }
    }

    @Override
    @NotNull
    public VcsShowSettingOption getOptions(VcsConfiguration.StandardOption option) {
        VcsShowSettingOption vcsShowSettingOption = this.myOptionsAndConfirmations.getOptions(option);
        if (vcsShowSettingOption == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getOptions"));
        }
        return vcsShowSettingOption;
    }

    @Override
    public List<VcsShowOptionsSettingImpl> getAllOptions() {
        return this.myOptionsAndConfirmations.getAllOptions();
    }

    @NotNull
    public VcsShowSettingOption getStandardOption(@NotNull VcsConfiguration.StandardOption option, @NotNull AbstractVcs vcs) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getStandardOption"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getStandardOption"));
        }
        VcsShowOptionsSettingImpl options = (VcsShowOptionsSettingImpl)this.getOptions(option);
        options.addApplicableVcs(vcs);
        VcsShowOptionsSettingImpl vcsShowOptionsSettingImpl = options;
        if (vcsShowOptionsSettingImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getStandardOption"));
        }
        return vcsShowOptionsSettingImpl;
    }

    @NotNull
    public VcsShowSettingOption getOrCreateCustomOption(@NotNull String vcsActionName, @NotNull AbstractVcs vcs) {
        if (vcsActionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getOrCreateCustomOption"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getOrCreateCustomOption"));
        }
        VcsShowSettingOption vcsShowSettingOption = this.myOptionsAndConfirmations.getOrCreateCustomOption(vcsActionName, vcs);
        if (vcsShowSettingOption == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getOrCreateCustomOption"));
        }
        return vcsShowSettingOption;
    }

    public void showProjectOperationInfo(UpdatedFiles updatedFiles, String displayActionName) {
        this.showUpdateProjectInfo(updatedFiles, displayActionName, ActionInfo.STATUS, false);
    }

    @Override
    public UpdateInfoTree showUpdateProjectInfo(UpdatedFiles updatedFiles, String displayActionName, ActionInfo actionInfo, boolean canceled) {
        if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
            return null;
        }
        ContentManager contentManager = this.getContentManager();
        if (contentManager == null) {
            return null;
        }
        UpdateInfoTree updateInfoTree = new UpdateInfoTree(contentManager, this.myProject, updatedFiles, displayActionName, actionInfo);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)updateInfoTree), canceled ? VcsBundle.message((String)"toolwindow.title.update.action.canceled.info", (Object[])new Object[]{displayActionName}) : VcsBundle.message((String)"toolwindow.title.update.action.info", (Object[])new Object[]{displayActionName}), true);
        Disposer.register((Disposable)content, (Disposable)updateInfoTree);
        ContentsUtil.addContent((ContentManager)contentManager, (Content)content, (boolean)true);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.VCS).activate(null);
        updateInfoTree.expandRootChildren();
        return updateInfoTree;
    }

    public void cleanupMappings() {
        this.myMappings.cleanupMappings();
    }

    public List<VcsDirectoryMapping> getDirectoryMappings() {
        return this.myMappings.getDirectoryMappings();
    }

    public List<VcsDirectoryMapping> getDirectoryMappings(AbstractVcs vcs) {
        return this.myMappings.getDirectoryMappings(vcs.getName());
    }

    @Nullable
    public VcsDirectoryMapping getDirectoryMappingFor(FilePath path) {
        VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)path);
        if (vFile != null) {
            return this.myMappings.getMappingFor(vFile);
        }
        return null;
    }

    public boolean hasExplicitMapping(FilePath f) {
        VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)f);
        return vFile != null && this.hasExplicitMapping(vFile);
    }

    public boolean hasExplicitMapping(VirtualFile vFile) {
        VcsDirectoryMapping mapping = this.myMappings.getMappingFor(vFile);
        return mapping != null && !mapping.isDefaultMapping();
    }

    public void setDirectoryMapping(String path, String activeVcsName) {
        if (this.myMappingsLoaded) {
            return;
        }
        this.myHaveLegacyVcsConfiguration = true;
        this.myMappings.setMapping(FileUtil.toSystemIndependentName((String)path), activeVcsName);
    }

    public void setAutoDirectoryMapping(String path, String activeVcsName) {
        List<VirtualFile> defaultRoots = this.myMappings.getDefaultRoots();
        if (defaultRoots.size() == 1 && StringUtil.isEmpty((String)this.myMappings.haveDefaultMapping())) {
            this.myMappings.removeDirectoryMapping(new VcsDirectoryMapping("", ""));
        }
        this.myMappings.setMapping(path, activeVcsName);
    }

    public void removeDirectoryMapping(VcsDirectoryMapping mapping) {
        this.myMappings.removeDirectoryMapping(mapping);
    }

    public void setDirectoryMappings(List<VcsDirectoryMapping> items) {
        this.myHaveLegacyVcsConfiguration = true;
        this.myMappings.setDirectoryMappings(items);
    }

    public void iterateVcsRoot(VirtualFile root, Processor<FilePath> iterator) {
        VcsRootIterator.iterateVcsRoot(this.myProject, root, iterator);
    }

    public void iterateVcsRoot(VirtualFile root, Processor<FilePath> iterator, @Nullable VirtualFileFilter directoryFilter) {
        VcsRootIterator.iterateVcsRoot(this.myProject, root, iterator, directoryFilter);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.mySerialization.readExternalUtil(element, this.myOptionsAndConfirmations);
        Attribute attribute = element.getAttribute(SETTINGS_EDITED_MANUALLY);
        if (attribute != null) {
            try {
                this.myHaveLegacyVcsConfiguration = attribute.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.mySerialization.writeExternalUtil(element, this.myOptionsAndConfirmations);
        element.setAttribute(SETTINGS_EDITED_MANUALLY, String.valueOf(this.myHaveLegacyVcsConfiguration));
    }

    @NotNull
    public VcsShowConfirmationOption getStandardConfirmation(@NotNull VcsConfiguration.StandardConfirmation option, AbstractVcs vcs) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getStandardConfirmation"));
        }
        VcsShowConfirmationOptionImpl result = this.getConfirmation(option);
        if (vcs != null) {
            result.addApplicableVcs(vcs);
        }
        VcsShowConfirmationOptionImpl vcsShowConfirmationOptionImpl = result;
        if (vcsShowConfirmationOptionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getStandardConfirmation"));
        }
        return vcsShowConfirmationOptionImpl;
    }

    @Override
    public List<VcsShowConfirmationOptionImpl> getAllConfirmations() {
        return this.myOptionsAndConfirmations.getAllConfirmations();
    }

    @Override
    @NotNull
    public VcsShowConfirmationOptionImpl getConfirmation(VcsConfiguration.StandardConfirmation option) {
        VcsShowConfirmationOptionImpl vcsShowConfirmationOptionImpl = this.myOptionsAndConfirmations.getConfirmation(option);
        if (vcsShowConfirmationOptionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getConfirmation"));
        }
        return vcsShowConfirmationOptionImpl;
    }

    public void addVcsListener(VcsListener listener) {
        MessageBusConnection connection = this.myMessageBus.connect();
        connection.subscribe(VCS_CONFIGURATION_CHANGED, (Object)listener);
        this.myAdapters.put(listener, connection);
    }

    public void removeVcsListener(VcsListener listener) {
        MessageBusConnection connection = this.myAdapters.remove(listener);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public void startBackgroundVcsOperation() {
        ++this.myBackgroundOperationCounter;
    }

    public void stopBackgroundVcsOperation() {
        assert (!ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
        LOG.assertTrue(this.myBackgroundOperationCounter > 0, (Object)"myBackgroundOperationCounter > 0");
        --this.myBackgroundOperationCounter;
    }

    public boolean isBackgroundVcsOperationRunning() {
        return this.myBackgroundOperationCounter > 0;
    }

    public List<VirtualFile> getRootsUnderVcsWithoutFiltering(AbstractVcs vcs) {
        return this.myMappings.getMappingsAsFilesUnderVcs(vcs);
    }

    @NotNull
    public VirtualFile[] getRootsUnderVcs(AbstractVcs vcs) {
        VirtualFile[] virtualFileArray = this.myMappingsToRoots.getRootsUnderVcs(vcs);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getRootsUnderVcs"));
        }
        return virtualFileArray;
    }

    public List<VirtualFile> getDetailedVcsMappings(AbstractVcs vcs) {
        return this.myMappingsToRoots.getDetailedVcsMappings(vcs);
    }

    public VirtualFile[] getAllVersionedRoots() {
        AbstractVcs[] vcses;
        ArrayList vFiles = new ArrayList();
        for (AbstractVcs vcs : vcses = this.myMappings.getActiveVcses()) {
            Collections.addAll(vFiles, this.getRootsUnderVcs(vcs));
        }
        return VfsUtilCore.toVirtualFileArray(vFiles);
    }

    @NotNull
    public VcsRoot[] getAllVcsRoots() {
        AbstractVcs[] vcses;
        ArrayList<VcsRoot> vcsRoots = new ArrayList<VcsRoot>();
        for (AbstractVcs vcs : vcses = this.myMappings.getActiveVcses()) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = this.getRootsUnderVcs(vcs)) {
                vcsRoots.add(new VcsRoot(vcs, root));
            }
        }
        VcsRoot[] vcsRootArray = vcsRoots.toArray(new VcsRoot[vcsRoots.size()]);
        if (vcsRootArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getAllVcsRoots"));
        }
        return vcsRootArray;
    }

    public void updateActiveVcss() {
    }

    @Override
    public void notifyDirectoryMappingChanged() {
        ((VcsListener)this.myMessageBus.syncPublisher(VCS_CONFIGURATION_CHANGED)).directoryMappingChanged();
    }

    public void readDirectoryMappings(Element element) {
        this.myMappings.clear();
        ArrayList<VcsDirectoryMapping> mappingsList = new ArrayList<VcsDirectoryMapping>();
        List list = element.getChildren(ELEMENT_MAPPING);
        boolean haveNonEmptyMappings = false;
        for (Object childObj : list) {
            VcsRootSettings rootSettings;
            Element child = (Element)childObj;
            String vcs = child.getAttributeValue(ATTRIBUTE_VCS);
            if (vcs != null && !vcs.isEmpty()) {
                haveNonEmptyMappings = true;
            }
            VcsDirectoryMapping mapping = new VcsDirectoryMapping(child.getAttributeValue(ATTRIBUTE_DIRECTORY), vcs);
            mappingsList.add(mapping);
            Element rootSettingsElement = child.getChild(ELEMENT_ROOT_SETTINGS);
            if (rootSettingsElement == null) continue;
            String className = rootSettingsElement.getAttributeValue(ATTRIBUTE_CLASS);
            AbstractVcs vcsInstance = this.findVcsByName(mapping.getVcs());
            if (vcsInstance == null || className == null || (rootSettings = vcsInstance.createEmptyVcsRootSettings()) == null) continue;
            try {
                rootSettings.readExternal(rootSettingsElement);
                mapping.setRootSettings(rootSettings);
            }
            catch (InvalidDataException e) {
                LOG.error("Failed to load VCS root settings class " + className + " for VCS " + vcsInstance.getClass().getName(), (Throwable)e);
            }
        }
        boolean defaultProject = Boolean.TRUE.toString().equals(element.getAttributeValue(ATTRIBUTE_DEFAULT_PROJECT));
        if (haveNonEmptyMappings || !defaultProject) {
            this.myMappingsLoaded = true;
        }
        this.myMappings.setDirectoryMappings(mappingsList);
    }

    public void writeDirectoryMappings(Element element) {
        if (this.myProject.isDefault()) {
            element.setAttribute(ATTRIBUTE_DEFAULT_PROJECT, Boolean.TRUE.toString());
        }
        for (VcsDirectoryMapping mapping : this.getDirectoryMappings()) {
            Element child = new Element(ELEMENT_MAPPING);
            child.setAttribute(ATTRIBUTE_DIRECTORY, mapping.getDirectory());
            child.setAttribute(ATTRIBUTE_VCS, mapping.getVcs());
            VcsRootSettings rootSettings = mapping.getRootSettings();
            if (rootSettings != null) {
                Element rootSettingsElement = new Element(ELEMENT_ROOT_SETTINGS);
                rootSettingsElement.setAttribute(ATTRIBUTE_CLASS, rootSettings.getClass().getName());
                try {
                    rootSettings.writeExternal(rootSettingsElement);
                    child.addContent(rootSettingsElement);
                }
                catch (WriteExternalException e) {
                    // empty catch block
                }
            }
            element.addContent(child);
        }
    }

    public boolean needAutodetectMappings() {
        return !this.myHaveLegacyVcsConfiguration && !this.myMappingsLoaded;
    }

    @Nullable
    public AbstractVcs findVersioningVcs(VirtualFile file) {
        VcsDescriptor[] vcsDescriptors = this.getAllVcss();
        VcsDescriptor probableVcs = null;
        for (VcsDescriptor vcsDescriptor : vcsDescriptors) {
            if (!vcsDescriptor.probablyUnderVcs(file)) continue;
            if (probableVcs != null) {
                return null;
            }
            probableVcs = vcsDescriptor;
        }
        return probableVcs == null ? null : this.findVcsByName(probableVcs.getName());
    }

    public CheckoutProvider.Listener getCompositeCheckoutListener() {
        return new CompositeCheckoutListener(this.myProject);
    }

    public VcsEventsListenerManager getVcsEventsListenerManager() {
        return this.myVcsEventListenerManager;
    }

    @Override
    public void fireDirectoryMappingsChanged() {
        if (this.myProject.isOpen() && !this.myProject.isDisposed()) {
            this.myMappings.mappingsChanged();
        }
    }

    @Override
    public String haveDefaultMapping() {
        return this.myMappings.haveDefaultMapping();
    }

    protected VcsEnvironmentsProxyCreator getProxyCreator() {
        return this.myVcsEventListenerManager;
    }

    public BackgroundableActionEnabledHandler getBackgroundableActionHandler(VcsBackgroundableActions action) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        BackgroundableActionEnabledHandler result = this.myBackgroundableActionHandlerMap.get((Object)action);
        if (result == null) {
            result = new BackgroundableActionEnabledHandler();
            this.myBackgroundableActionHandlerMap.put(action, result);
        }
        return result;
    }

    public void addInitializationRequest(final VcsInitObject vcsInitObject, final Runnable runnable) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                ProjectLevelVcsManagerImpl.this.myInitialization.add(vcsInitObject, runnable);
            }
        });
    }

    public boolean isFileInContent(final VirtualFile vf) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return vf != null && (ProjectLevelVcsManagerImpl.this.myExcludedIndex.isInContent(vf) || ProjectLevelVcsManagerImpl.this.isFileInBaseDir(vf) || vf.equals(ProjectLevelVcsManagerImpl.this.myProject.getBaseDir()) || ProjectLevelVcsManagerImpl.this.hasExplicitMapping(vf) || ProjectLevelVcsManagerImpl.this.isInDirectoryBasedRoot(vf)) && !ProjectLevelVcsManagerImpl.this.myExcludedIndex.isExcludedFile(vf);
            }
        });
    }

    public boolean dvcsUsedInProject() {
        AbstractVcs[] allActiveVcss;
        for (AbstractVcs activeVcs : allActiveVcss = this.getAllActiveVcss()) {
            if (!VcsType.distributed.equals((Object)activeVcs.getType())) continue;
            return true;
        }
        return false;
    }

    private boolean isInDirectoryBasedRoot(VirtualFile file) {
        if (file == null) {
            return false;
        }
        StorageScheme storageScheme = ((ProjectEx)this.myProject).getStateStore().getStorageScheme();
        if (StorageScheme.DIRECTORY_BASED.equals((Object)storageScheme)) {
            VirtualFile baseDir = this.myProject.getBaseDir();
            if (baseDir == null) {
                return false;
            }
            VirtualFile ideaDir = baseDir.findChild(".idea");
            return ideaDir != null && ideaDir.isValid() && ideaDir.isDirectory() && VfsUtilCore.isAncestor((VirtualFile)ideaDir, (VirtualFile)file, (boolean)false);
        }
        return false;
    }

    private boolean isFileInBaseDir(VirtualFile file) {
        VirtualFile parent = file.getParent();
        return !file.isDirectory() && parent != null && parent.equals(this.myProject.getBaseDir());
    }

    public static List<VirtualFile> getRootsUnder(List<VirtualFile> roots, VirtualFile underWhat) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(roots.size());
        for (VirtualFile root : roots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)underWhat, (VirtualFile)root, (boolean)false)) continue;
            result.add(root);
        }
        return result;
    }

    public VcsHistoryCache getVcsHistoryCache() {
        return this.myVcsHistoryCache;
    }

    public ContentRevisionCache getContentRevisionCache() {
        return this.myContentRevisionCache;
    }
}

