/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.FragmentContent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.BaseLineStatusRangeAction;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class ShowLineStatusRangeDiffAction
extends BaseLineStatusRangeAction {
    public ShowLineStatusRangeDiffAction(LineStatusTracker lineStatusTracker, Range range, Editor editor) {
        super(VcsBundle.message((String)"action.name.show.difference", (Object[])new Object[0]), AllIcons.Actions.Diff, lineStatusTracker, range);
    }

    @Override
    public boolean isEnabled() {
        return this.isModifiedRange() || this.isDeletedRange();
    }

    private boolean isDeletedRange() {
        return 3 == this.myRange.getType();
    }

    private boolean isModifiedRange() {
        return 1 == this.myRange.getType();
    }

    public void actionPerformed(AnActionEvent e) {
        DiffManager.getInstance().getDiffTool().show(this.createDiffData());
    }

    private DiffRequest createDiffData() {
        return new DiffRequest(this.myLineStatusTracker.getProject()){

            @NotNull
            public DiffContent[] getContents() {
                DiffContent[] diffContentArray = new DiffContent[]{ShowLineStatusRangeDiffAction.this.createDiffContent(ShowLineStatusRangeDiffAction.this.myLineStatusTracker.getUpToDateDocument(), ShowLineStatusRangeDiffAction.this.myLineStatusTracker.getUpToDateRangeWithEndSymbol(ShowLineStatusRangeDiffAction.this.myRange), null), ShowLineStatusRangeDiffAction.this.createDiffContent(ShowLineStatusRangeDiffAction.this.myLineStatusTracker.getDocument(), ShowLineStatusRangeDiffAction.this.myLineStatusTracker.getCurrentTextRangeWithEndSymbol(ShowLineStatusRangeDiffAction.this.myRange), ShowLineStatusRangeDiffAction.this.myLineStatusTracker.getVirtualFile())};
                if (diffContentArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction$1", "getContents"));
                }
                return diffContentArray;
            }

            public String[] getContentTitles() {
                return new String[]{VcsBundle.message((String)"diff.content.title.up.to.date", (Object[])new Object[0]), VcsBundle.message((String)"diff.content.title.current.range", (Object[])new Object[0])};
            }

            public String getWindowTitle() {
                return VcsBundle.message((String)"dialog.title.diff.for.range", (Object[])new Object[0]);
            }
        };
    }

    private DiffContent createDiffContent(Document uDocument, TextRange textRange, VirtualFile file) {
        Project project = this.myLineStatusTracker.getProject();
        DocumentContent diffContent = new DocumentContent(project, uDocument);
        return new FragmentContent((DiffContent)diffContent, textRange, project, file);
    }
}

