/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vcs.ex.DocumentWrapper;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.ArrayUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.LinkedList;
import java.util.List;

public class RangesBuilder {
    private List<Range> myRanges = new LinkedList<Range>();

    public RangesBuilder(Document current, Document upToDate) throws FilesTooBigForDiffException {
        this(new DocumentWrapper(current).getLines(), new DocumentWrapper(upToDate).getLines(), 0, 0);
    }

    public RangesBuilder(List<String> current, List<String> upToDate, int shift, int uShift) throws FilesTooBigForDiffException {
        Diff.Change ch = Diff.buildChanges((Object[])ArrayUtil.toStringArray(upToDate), (Object[])ArrayUtil.toStringArray(current));
        while (ch != null) {
            Range range = Range.createOn(ch, shift, uShift);
            this.myRanges.add(range);
            ch = ch.link;
        }
    }

    public List<Range> getRanges() {
        return this.myRanges;
    }
}

