/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.diff.Diff;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Range {
    private static final Logger LOG = Logger.getInstance(Range.class);
    public static final byte MODIFIED = 1;
    public static final byte INSERTED = 2;
    public static final byte DELETED = 3;
    private int myOffset1;
    private int myOffset2;
    private final int myUpToDateOffset1;
    private final int myUpToDateOffset2;
    private final byte myType;
    @Nullable
    private RangeHighlighter myRangeHighlighter;

    public static Range createOn(@NotNull Diff.Change change, int shift, int upToDateShift) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/ex/Range", "createOn"));
        }
        byte type = Range.getChangeTypeFrom(change);
        int offset1 = shift + change.line1;
        int offset2 = offset1 + change.inserted;
        int uOffset1 = upToDateShift + change.line0;
        int uOffset2 = uOffset1 + change.deleted;
        return new Range(offset1, offset2, uOffset1, uOffset2, type);
    }

    private static byte getChangeTypeFrom(@NotNull Diff.Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/ex/Range", "getChangeTypeFrom"));
        }
        if (change.deleted > 0 && change.inserted > 0) {
            return 1;
        }
        if (change.deleted > 0) {
            return 3;
        }
        if (change.inserted > 0) {
            return 2;
        }
        LOG.error("Unknown change type");
        return 0;
    }

    public Range(int offset1, int offset2, int uOffset1, int uOffset2, byte type) {
        this.myOffset1 = offset1;
        this.myOffset2 = offset2;
        this.myUpToDateOffset1 = uOffset1;
        this.myUpToDateOffset2 = uOffset2;
        this.myType = type;
    }

    public int hashCode() {
        return this.myUpToDateOffset1 ^ this.myUpToDateOffset2 ^ this.myType ^ this.myOffset1 ^ this.myOffset2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Range)) {
            return false;
        }
        Range other = (Range)object;
        return this.myUpToDateOffset1 == other.myUpToDateOffset1 && this.myUpToDateOffset2 == other.myUpToDateOffset2 && this.myOffset1 == other.myOffset1 && this.myOffset2 == other.myOffset2 && this.myType == other.myType;
    }

    public String toString() {
        return String.format("%s, %s, %s, %s, %s", this.myOffset1, this.myOffset2, this.myUpToDateOffset1, this.myUpToDateOffset2, this.getTypeName());
    }

    @NonNls
    private String getTypeName() {
        switch (this.myType) {
            case 1: {
                return "MODIFIED";
            }
            case 2: {
                return "INSERTED";
            }
            case 3: {
                return "DELETED";
            }
        }
        return "UNKNOWN";
    }

    public byte getType() {
        return this.myType;
    }

    public int getUpToDateRangeLength() {
        return this.myUpToDateOffset2 - this.myUpToDateOffset1;
    }

    public void shift(int shift) {
        this.myOffset1 += shift;
        this.myOffset2 += shift;
    }

    public int getOffset1() {
        return this.myOffset1;
    }

    public int getOffset2() {
        return this.myOffset2;
    }

    public int getUOffset1() {
        return this.myUpToDateOffset1;
    }

    public int getUOffset2() {
        return this.myUpToDateOffset2;
    }

    public boolean canBeMergedWith(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/ex/Range", "canBeMergedWith"));
        }
        return this.myOffset2 == range.myOffset1;
    }

    @NotNull
    public Range mergeWith(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/ex/Range", "mergeWith"));
        }
        Range range2 = new Range(this.myOffset1, range.myOffset2, this.myUpToDateOffset1, range.myUpToDateOffset2, this.mergedStatusWith(range));
        if (range2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/Range", "mergeWith"));
        }
        return range2;
    }

    private byte mergedStatusWith(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/ex/Range", "mergedStatusWith"));
        }
        byte type = this.myType;
        if (this.myType != range.myType) {
            type = 1;
        }
        return type;
    }

    public boolean hasHighlighter() {
        return this.myRangeHighlighter != null;
    }

    public void setHighlighter(RangeHighlighter highlighter) {
        this.myRangeHighlighter = highlighter;
    }

    @Nullable
    public RangeHighlighter getHighlighter() {
        return this.myRangeHighlighter;
    }

    public boolean contains(int offset1, int offset2) {
        return this.getOffset1() <= offset1 && this.getOffset2() >= offset2;
    }

    public boolean containsLine(int line) {
        if (this.myType == 3) {
            return this.myOffset1 - 1 <= line && this.myOffset2 >= line;
        }
        return this.myOffset1 <= line && this.myOffset2 >= line;
    }

    public boolean isAfter(int line) {
        if (this.myType == 3) {
            return this.getOffset1() - 1 > line;
        }
        return this.getOffset1() > line;
    }
}

