/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;

public class DocumentWrapper {
    private final Document myDocument;

    public DocumentWrapper(Document document) {
        this.myDocument = document;
    }

    public int getLineNum(int offset) {
        return this.myDocument.getLineNumber(offset);
    }

    public List<String> getLines() {
        return this.getLines(0, this.myDocument.getLineCount() - 1);
    }

    public List<String> getLines(int from, int to) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = from; i <= to && i < this.myDocument.getLineCount(); ++i) {
            String line = this.getLine(i);
            result.add(line);
        }
        return result;
    }

    private String getLine(int i) {
        TextRange range = new TextRange(this.myDocument.getLineStartOffset(i), this.myDocument.getLineEndOffset(i));
        if (range.getLength() < 0) assert (false) : this.myDocument;
        return this.myDocument.getText(range);
    }
}

