/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.newEditor.OptionsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

class VcsUpdateInfoScopeFilterConfigurable
implements Configurable,
NamedScopesHolder.ScopeListener {
    private final JCheckBox myCheckbox;
    private final JComboBox myComboBox;
    private final Project myProject;
    private final VcsConfiguration myVcsConfiguration;
    private final NamedScopesHolder[] myNamedScopeHolders;

    VcsUpdateInfoScopeFilterConfigurable(Project project, VcsConfiguration vcsConfiguration) {
        this.myProject = project;
        this.myVcsConfiguration = vcsConfiguration;
        this.myCheckbox = new JCheckBox(VcsBundle.getString((String)"settings.filter.update.project.info.by.scope"));
        this.myComboBox = new JComboBox();
        this.myComboBox.setEnabled(this.myCheckbox.isSelected());
        this.myCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VcsUpdateInfoScopeFilterConfigurable.this.myComboBox.setEnabled(VcsUpdateInfoScopeFilterConfigurable.this.myCheckbox.isSelected());
            }
        });
        for (NamedScopesHolder holder : this.myNamedScopeHolders = NamedScopesHolder.getAllNamedScopeHolders((Project)this.myProject)) {
            holder.addScopeListener((NamedScopesHolder.ScopeListener)this);
        }
    }

    public void scopesChanged() {
        this.reset();
    }

    @Nls
    public String getDisplayName() {
        return VcsBundle.getString((String)"settings.filter.update.project.info.by.scope");
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        final JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add(this.myCheckbox);
        panel.add(this.myComboBox);
        panel.add(Box.createHorizontalStrut(10));
        panel.add((Component)new LinkLabel("Edit scopes", null, new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                SearchableConfigurable configurable;
                OptionsEditor optionsEditor = (OptionsEditor)OptionsEditor.KEY.getData(DataManager.getInstance().getDataContext((Component)panel));
                if (optionsEditor != null && (configurable = optionsEditor.findConfigurableById(new ScopeChooserConfigurable(VcsUpdateInfoScopeFilterConfigurable.this.myProject).getId())) != null) {
                    optionsEditor.select((Configurable)configurable);
                }
            }
        }));
        return panel;
    }

    public boolean isModified() {
        return !Comparing.equal((String)this.myVcsConfiguration.UPDATE_FILTER_SCOPE_NAME, (String)this.getScopeFilterName());
    }

    public void apply() throws ConfigurationException {
        this.myVcsConfiguration.UPDATE_FILTER_SCOPE_NAME = this.getScopeFilterName();
    }

    public void reset() {
        this.myComboBox.removeAllItems();
        boolean selection = false;
        for (NamedScopesHolder holder : this.myNamedScopeHolders) {
            for (NamedScope scope : holder.getEditableScopes()) {
                this.myComboBox.addItem(scope.getName());
                if (selection || !scope.getName().equals(this.myVcsConfiguration.UPDATE_FILTER_SCOPE_NAME)) continue;
                selection = true;
            }
        }
        if (selection) {
            this.myComboBox.setSelectedItem(this.myVcsConfiguration.UPDATE_FILTER_SCOPE_NAME);
        }
        this.myCheckbox.setSelected(selection);
    }

    public void disposeUIResources() {
        for (NamedScopesHolder holder : this.myNamedScopeHolders) {
            holder.removeScopeListener((NamedScopesHolder.ScopeListener)this);
        }
    }

    private String getScopeFilterName() {
        if (!this.myCheckbox.isSelected()) {
            return null;
        }
        return (String)this.myComboBox.getSelectedItem();
    }
}

