/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import com.intellij.openapi.vcs.checkout.ProjectCheckoutListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import java.io.File;
import javax.swing.Icon;

public class ProjectImporterCheckoutListener
implements CheckoutListener {
    public boolean processCheckedOutDirectory(Project project, File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            for (File file : files) {
                ProjectOpenProcessor openProcessor;
                VirtualFile virtualFile;
                if (file.isDirectory() || (virtualFile = localFileSystem.findFileByIoFile(file)) == null || (openProcessor = ProjectOpenProcessor.getImportProvider((VirtualFile)virtualFile)) == null) continue;
                int rc = Messages.showYesNoDialog((Project)project, (String)VcsBundle.message((String)"checkout.open.project.prompt", (Object[])new Object[]{ProjectCheckoutListener.getProductNameWithArticle(), file.getPath()}), (String)VcsBundle.message((String)"checkout.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (rc == 0) {
                    openProcessor.doOpenProject(virtualFile, project, false);
                }
                return true;
            }
        }
        return false;
    }

    public void processOpenedProject(Project lastOpenedProject) {
    }
}

