/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.Icon;
import org.apache.oro.io.GlobFilenameFilter;

public class ProjectCheckoutListener
implements CheckoutListener {
    public boolean processCheckedOutDirectory(Project project, File directory) {
        File[] files = directory.listFiles((FilenameFilter)new GlobFilenameFilter("*.ipr"));
        if (files != null && files.length > 0) {
            int rc = Messages.showYesNoDialog((Project)project, (String)VcsBundle.message((String)"checkout.open.project.prompt", (Object[])new Object[]{ProjectCheckoutListener.getProductNameWithArticle(), files[0].getPath()}), (String)VcsBundle.message((String)"checkout.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (rc == 0) {
                ProjectUtil.openProject(files[0].getPath(), project, false);
            }
            return true;
        }
        return false;
    }

    public void processOpenedProject(Project lastOpenedProject) {
    }

    static String getProductNameWithArticle() {
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        String productName = PlatformUtils.isIdeaUltimate() ? namesInfo.getFullProductName() : namesInfo.getProductName();
        String article = StringUtil.isVowel((char)Character.toLowerCase(productName.charAt(0))) ? "an " : "a ";
        return article + productName;
    }
}

