/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.CustomChangelistTodosTreeBuilder;
import com.intellij.ide.todo.SetTodoFilterAction;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeBuilderFactory;
import com.intellij.ide.todo.TodoView;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandlerWorker;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.Nullable;

public class TodoCheckinHandler
extends CheckinHandler {
    private final Project myProject;
    private final CheckinProjectPanel myCheckinProjectPanel;
    private final VcsConfiguration myConfiguration;
    private TodoFilter myTodoFilter;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.checkin.TodoCheckinHandler");

    public TodoCheckinHandler(CheckinProjectPanel checkinProjectPanel) {
        this.myProject = checkinProjectPanel.getProject();
        this.myCheckinProjectPanel = checkinProjectPanel;
        this.myConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
    }

    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        final JCheckBox checkBox = new JCheckBox(VcsBundle.message((String)"before.checkin.new.todo.check", (Object[])new Object[]{""}));
        return new RefreshableOnComponent(){

            public JComponent getComponent() {
                JPanel panel = new JPanel(new BorderLayout(4, 0));
                panel.add((Component)checkBox, "West");
                this.setFilterText(((TodoCheckinHandler)TodoCheckinHandler.this).myConfiguration.myTodoPanelSettings.getTodoFilterName());
                if (((TodoCheckinHandler)TodoCheckinHandler.this).myConfiguration.myTodoPanelSettings.getTodoFilterName() != null) {
                    TodoCheckinHandler.this.myTodoFilter = TodoConfiguration.getInstance().getTodoFilter(((TodoCheckinHandler)TodoCheckinHandler.this).myConfiguration.myTodoPanelSettings.getTodoFilterName());
                }
                Consumer<TodoFilter> consumer = new Consumer<TodoFilter>(){

                    public void consume(TodoFilter todoFilter) {
                        TodoCheckinHandler.this.myTodoFilter = todoFilter;
                        String name = todoFilter == null ? null : todoFilter.getName();
                        ((TodoCheckinHandler)TodoCheckinHandler.this).myConfiguration.myTodoPanelSettings.setTodoFilterName(name);
                        this.setFilterText(name);
                    }
                };
                LinkLabel linkLabel = new LinkLabel("Configure", null);
                linkLabel.setListener(new LinkListener((Consumer)consumer, linkLabel){
                    final /* synthetic */ Consumer val$consumer;
                    final /* synthetic */ LinkLabel val$linkLabel;
                    {
                        this.val$consumer = consumer;
                        this.val$linkLabel = linkLabel;
                    }

                    public void linkSelected(LinkLabel aSource, Object aLinkData) {
                        DefaultActionGroup group = SetTodoFilterAction.createPopupActionGroup(TodoCheckinHandler.this.myProject, ((TodoCheckinHandler)TodoCheckinHandler.this).myConfiguration.myTodoPanelSettings, (Consumer<TodoFilter>)this.val$consumer);
                        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("TodoViewToolbar", (ActionGroup)group);
                        popupMenu.getComponent().show((Component)this.val$linkLabel, 0, this.val$linkLabel.getHeight());
                    }
                }, null);
                panel.add((Component)linkLabel, "Center");
                TodoCheckinHandler.this.refreshEnable(checkBox);
                return panel;
            }

            private void setFilterText(String filterName) {
                if (filterName == null) {
                    checkBox.setText(VcsBundle.message((String)"before.checkin.new.todo.check", (Object[])new Object[]{IdeBundle.message((String)"action.todo.show.all", (Object[])new Object[0])}));
                } else {
                    checkBox.setText(VcsBundle.message((String)"before.checkin.new.todo.check", (Object[])new Object[]{"Filter: " + filterName}));
                }
            }

            public void refresh() {
            }

            public void saveState() {
                ((TodoCheckinHandler)TodoCheckinHandler.this).myConfiguration.CHECK_NEW_TODO = checkBox.isSelected();
            }

            public void restoreState() {
                checkBox.setSelected(((TodoCheckinHandler)TodoCheckinHandler.this).myConfiguration.CHECK_NEW_TODO);
            }
        };
    }

    private void refreshEnable(JCheckBox checkBox) {
        if (DumbService.getInstance((Project)this.myProject).isDumb()) {
            checkBox.setEnabled(false);
            checkBox.setToolTipText("TODO check is impossible until indices are up-to-date");
        } else {
            checkBox.setEnabled(true);
            checkBox.setToolTipText("");
        }
    }

    public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
        if (!this.myConfiguration.CHECK_NEW_TODO) {
            return CheckinHandler.ReturnResult.COMMIT;
        }
        if (DumbService.getInstance((Project)this.myProject).isDumb()) {
            String todoName = VcsBundle.message((String)"before.checkin.new.todo.check.title", (Object[])new Object[0]);
            if (Messages.showOkCancelDialog((Project)this.myProject, (String)(todoName + " can't be performed while " + ApplicationNamesInfo.getInstance().getFullProductName() + " updates the indices in background.\n" + "You can commit the changes without running checks, or you can wait until indices are built."), (String)(todoName + " is not possible right now"), (String)"&Wait", (String)"&Commit", null) == 0) {
                return CheckinHandler.ReturnResult.CANCEL;
            }
            return CheckinHandler.ReturnResult.COMMIT;
        }
        Collection changes = this.myCheckinProjectPanel.getSelectedChanges();
        final TodoCheckinHandlerWorker worker = new TodoCheckinHandlerWorker(this.myProject, changes, this.myTodoFilter, true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                worker.execute();
            }
        };
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, "Looking for new and edited TODO items...", true, this.myProject);
        if (completed && worker.getAddedOrEditedTodos().isEmpty() && worker.getInChangedTodos().isEmpty() && worker.getSkipped().isEmpty()) {
            return CheckinHandler.ReturnResult.COMMIT;
        }
        if (!completed) {
            return CheckinHandler.ReturnResult.CANCEL;
        }
        return this.showResults(worker, executor);
    }

    private CheckinHandler.ReturnResult showResults(TodoCheckinHandlerWorker worker, CommitExecutor executor) {
        int commitOption;
        String[] buttons;
        boolean thereAreTodoFound;
        String commitButtonText;
        String string = commitButtonText = executor != null ? executor.getActionText() : this.myCheckinProjectPanel.getCommitActionName();
        if (commitButtonText.endsWith("...")) {
            commitButtonText = commitButtonText.substring(0, commitButtonText.length() - 3);
        }
        String text = TodoCheckinHandler.createMessage(worker);
        boolean bl = thereAreTodoFound = worker.getAddedOrEditedTodos().size() + worker.getInChangedTodos().size() > 0;
        if (thereAreTodoFound) {
            buttons = new String[]{VcsBundle.message((String)"todo.in.new.review.button", (Object[])new Object[0]), commitButtonText, CommonBundle.getCancelButtonText()};
            commitOption = 1;
        } else {
            buttons = new String[]{commitButtonText, CommonBundle.getCancelButtonText()};
            commitOption = 0;
        }
        int answer = Messages.showDialog((Project)this.myProject, (String)text, (String)"TODO", null, (String[])buttons, (int)0, (int)1, (Icon)UIUtil.getWarningIcon());
        if (thereAreTodoFound && answer == 0) {
            this.showTodo(worker);
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }
        if (answer == commitOption) {
            return CheckinHandler.ReturnResult.COMMIT;
        }
        return CheckinHandler.ReturnResult.CANCEL;
    }

    private void showTodo(final TodoCheckinHandlerWorker worker) {
        TodoView todoView = (TodoView)ServiceManager.getService((Project)this.myProject, TodoView.class);
        final String title = "For commit (" + DateFormatUtil.formatDateTime((long)System.currentTimeMillis()) + ")";
        todoView.addCustomTodoView(new TodoTreeBuilderFactory(){

            @Override
            public TodoTreeBuilder createTreeBuilder(JTree tree, DefaultTreeModel treeModel, Project project) {
                return new CustomChangelistTodosTreeBuilder(tree, treeModel, TodoCheckinHandler.this.myProject, title, worker.inOneList());
            }
        }, title, new TodoPanelSettings(this.myConfiguration.myTodoPanelSettings));
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolWindow window;
                ToolWindowManager manager = ToolWindowManager.getInstance((Project)TodoCheckinHandler.this.myProject);
                if (manager != null && (window = manager.getToolWindow("TODO")) != null) {
                    window.show(new Runnable(){

                        @Override
                        public void run() {
                            ContentManager cm = window.getContentManager();
                            Content[] contents = cm.getContents();
                            if (contents.length > 0) {
                                cm.setSelectedContent(contents[contents.length - 1], true);
                            }
                        }
                    });
                }
            }
        }, ModalityState.NON_MODAL, this.myProject.getDisposed());
    }

    private static String createMessage(TodoCheckinHandlerWorker worker) {
        int added = worker.getAddedOrEditedTodos().size();
        int changed = worker.getInChangedTodos().size();
        int skipped = worker.getSkipped().size();
        if (added == 0 && changed == 0) {
            return VcsBundle.message((String)"todo.handler.only.skipped", (Object[])new Object[]{skipped});
        }
        if (changed == 0) {
            return VcsBundle.message((String)"todo.handler.only.added", (Object[])new Object[]{added, skipped});
        }
        if (added == 0) {
            return VcsBundle.message((String)"todo.handler.only.in.changed", (Object[])new Object[]{changed, skipped});
        }
        return VcsBundle.message((String)"todo.handler.only.both", (Object[])new Object[]{added, changed, skipped});
    }
}

