/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.checkin.BeforeCheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RearrangeBeforeCheckinHandler
extends CheckinHandler
implements CheckinMetaHandler {
    public static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.rearrange.code.before.commit", (Object[])new Object[0]);
    private final Project myProject;
    private final CheckinProjectPanel myPanel;

    public RearrangeBeforeCheckinHandler(@NotNull Project project, @NotNull CheckinProjectPanel panel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/checkin/RearrangeBeforeCheckinHandler", "<init>"));
        }
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/checkin/RearrangeBeforeCheckinHandler", "<init>"));
        }
        this.myProject = project;
        this.myPanel = panel;
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        final JCheckBox rearrangeBox = new JCheckBox(VcsBundle.message((String)"checkbox.checkin.options.rearrange.code", (Object[])new Object[0]));
        return new RefreshableOnComponent(){

            public JComponent getComponent() {
                JPanel panel = new JPanel(new GridLayout(1, 0));
                panel.add(rearrangeBox);
                return panel;
            }

            public void refresh() {
            }

            public void saveState() {
                ((RearrangeBeforeCheckinHandler)RearrangeBeforeCheckinHandler.this).getSettings().REARRANGE_BEFORE_PROJECT_COMMIT = rearrangeBox.isSelected();
            }

            public void restoreState() {
                rearrangeBox.setSelected(((RearrangeBeforeCheckinHandler)RearrangeBeforeCheckinHandler.this).getSettings().REARRANGE_BEFORE_PROJECT_COMMIT);
            }
        };
    }

    private VcsConfiguration getSettings() {
        return VcsConfiguration.getInstance((Project)this.myProject);
    }

    public void runCheckinHandlers(final Runnable finishAction) {
        Runnable performCheckoutAction = new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
                finishAction.run();
            }
        };
        if (VcsConfiguration.getInstance((Project)this.myProject).REARRANGE_BEFORE_PROJECT_COMMIT) {
            new RearrangeCodeProcessor(this.myProject, BeforeCheckinHandlerUtil.getPsiFiles(this.myProject, this.myPanel.getVirtualFiles()), COMMAND_NAME, performCheckoutAction).run();
        } else {
            performCheckoutAction.run();
        }
    }
}

