/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class BeforeCheckinHandlerUtil {
    private BeforeCheckinHandlerUtil() {
    }

    public static PsiFile[] getPsiFiles(Project project, Collection<VirtualFile> selectedFiles) {
        VirtualFile baseDir;
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        VirtualFile projectFileDir = null;
        StorageScheme storageScheme = ((ProjectEx)project).getStateStore().getStorageScheme();
        if (StorageScheme.DIRECTORY_BASED.equals((Object)storageScheme) && (baseDir = project.getBaseDir()) != null) {
            projectFileDir = baseDir.findChild(".idea");
        }
        for (VirtualFile file : selectedFiles) {
            PsiFile psiFile;
            if (!file.isValid() || BeforeCheckinHandlerUtil.isUnderProjectFileDir(projectFileDir, file) || !BeforeCheckinHandlerUtil.isFileUnderSourceRoot(project, file) || (psiFile = psiManager.findFile(file)) == null) continue;
            result.add(psiFile);
        }
        return PsiUtilCore.toPsiFileArray(result);
    }

    private static boolean isUnderProjectFileDir(@Nullable VirtualFile projectFileDir, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/checkin/BeforeCheckinHandlerUtil", "isUnderProjectFileDir"));
        }
        return projectFileDir != null && VfsUtilCore.isAncestor((VirtualFile)projectFileDir, (VirtualFile)file, (boolean)false);
    }

    private static boolean isFileUnderSourceRoot(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/checkin/BeforeCheckinHandlerUtil", "isFileUnderSourceRoot"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/checkin/BeforeCheckinHandlerUtil", "isFileUnderSourceRoot"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (StdFileTypes.JAVA == file.getFileType()) {
            return index.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES) && !index.isInLibrarySource(file);
        }
        return index.isInContent(file) && !index.isInLibrarySource(file);
    }
}

