/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserModuleNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.Nullable;

public class ChangesModuleGroupingPolicy
implements ChangesGroupingPolicy {
    private final Project myProject;
    private final DefaultTreeModel myModel;
    private final HashMap<Module, ChangesBrowserNode> myModuleCache = new HashMap();
    public static final String PROJECT_ROOT_TAG = "<Project Root>";

    public ChangesModuleGroupingPolicy(Project project, DefaultTreeModel model) {
        this.myProject = project;
        this.myModel = model;
    }

    @Override
    @Nullable
    public ChangesBrowserNode getParentNodeFor(StaticFilePath node, ChangesBrowserNode rootNode) {
        if (this.myProject.isDefault()) {
            return null;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile vFile = node.getVf();
        if (vFile == null) {
            vFile = LocalFileSystem.getInstance().findFileByIoFile(new File(node.getPath()));
        }
        if (vFile != null && Comparing.equal((Object)vFile, (Object)index.getContentRootForFile(vFile))) {
            Module module = index.getModuleForFile(vFile);
            return this.getNodeForModule(module, rootNode);
        }
        return null;
    }

    @Override
    public void clear() {
        this.myModuleCache.clear();
    }

    private ChangesBrowserNode getNodeForModule(Module module, ChangesBrowserNode root) {
        ChangesBrowserNode node = this.myModuleCache.get(module);
        if (node == null) {
            node = module == null ? ChangesBrowserNode.create(this.myProject, PROJECT_ROOT_TAG) : new ChangesBrowserModuleNode(module);
            this.myModel.insertNodeInto(node, root, root.getChildCount());
            this.myModuleCache.put(module, node);
        }
        return node;
    }
}

