/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.changes.patch.FilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.PatchBaseDirectoryDetector;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MatchPatchPaths {
    private final int ourBigFileBound = 100000;
    private final Project myProject;
    private final VirtualFile myBaseDir;

    public MatchPatchPaths(Project project) {
        this.myProject = project;
        this.myBaseDir = this.myProject.getBaseDir();
    }

    public List<FilePatchInProgress> execute(List<TextFilePatch> list) {
        PatchBaseDirectoryDetector directoryDetector = PatchBaseDirectoryDetector.getInstance(this.myProject);
        Application application = ApplicationManager.getApplication();
        ArrayList<PatchAndVariants> candidates = new ArrayList<PatchAndVariants>(list.size());
        ArrayList<TextFilePatch> newOrWithoutMatches = new ArrayList<TextFilePatch>();
        this.findCandidates(list, directoryDetector, application, candidates, newOrWithoutMatches);
        MultiMap result = new MultiMap();
        this.filterExactMatches(candidates, (MultiMap<VirtualFile, FilePatchInProgress>)result);
        this.selectByContext(candidates, (MultiMap<VirtualFile, FilePatchInProgress>)result);
        this.workWithNotExisting(directoryDetector, newOrWithoutMatches, (MultiMap<VirtualFile, FilePatchInProgress>)result);
        return new ArrayList<FilePatchInProgress>(result.values());
    }

    private void workWithNotExisting(PatchBaseDirectoryDetector directoryDetector, List<TextFilePatch> newOrWithoutMatches, MultiMap<VirtualFile, FilePatchInProgress> result) {
        for (TextFilePatch patch : newOrWithoutMatches) {
            FilePatchInProgress patchInProgress;
            String[] strings = patch.getAfterName().replace('\\', '/').split("/");
            Pair<VirtualFile, Integer> best = null;
            for (int i = strings.length - 2; i >= 0; --i) {
                String name = strings[i];
                Collection<VirtualFile> files = directoryDetector.findFiles(name);
                if (files.isEmpty()) continue;
                for (VirtualFile file : files) {
                    Pair<VirtualFile, Integer> pair = this.compareNamesImpl(strings, file, i);
                    if (pair == null || (Integer)pair.getSecond() >= i || best != null && (Integer)pair.getSecond() >= (Integer)best.getSecond()) continue;
                    best = pair;
                }
            }
            if (best != null) {
                patchInProgress = new FilePatchInProgress(patch, null, this.myBaseDir);
                patchInProgress.setNewBase((VirtualFile)best.getFirst());
                int numDown = (Integer)best.getSecond();
                for (int i = 0; i < numDown; ++i) {
                    patchInProgress.up();
                }
                result.putValue(best.getFirst(), (Object)patchInProgress);
                continue;
            }
            patchInProgress = new FilePatchInProgress(patch, null, this.myBaseDir);
            result.putValue((Object)this.myBaseDir, (Object)patchInProgress);
        }
    }

    private void selectByContext(List<PatchAndVariants> candidates, MultiMap<VirtualFile, FilePatchInProgress> result) {
        for (PatchAndVariants candidate : candidates) {
            int maxLines = -100;
            FilePatchInProgress best = null;
            for (FilePatchInProgress variant : candidate.getVariants()) {
                int lines = this.getMatchingLines(variant);
                if (lines <= maxLines) continue;
                maxLines = lines;
                best = variant;
            }
            this.putSelected(result, candidate.getVariants(), best);
        }
    }

    private void filterExactMatches(List<PatchAndVariants> candidates, MultiMap<VirtualFile, FilePatchInProgress> result) {
        Iterator<PatchAndVariants> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            PatchAndVariants candidate = iterator.next();
            if (candidate.getVariants().size() == 1) {
                FilePatchInProgress oneCandidate = candidate.getVariants().get(0);
                result.putValue((Object)oneCandidate.getBase(), (Object)oneCandidate);
                iterator.remove();
                continue;
            }
            ArrayList<FilePatchInProgress> exact = new ArrayList<FilePatchInProgress>(candidate.getVariants().size());
            for (FilePatchInProgress patch : candidate.getVariants()) {
                if (patch.getCurrentStrip() != 0) continue;
                exact.add(patch);
            }
            if (exact.size() == 1) {
                FilePatchInProgress patchInProgress = (FilePatchInProgress)exact.get(0);
                this.putSelected(result, candidate.getVariants(), patchInProgress);
                iterator.remove();
                continue;
            }
            if (exact.isEmpty()) continue;
            candidate.getVariants().retainAll(exact);
        }
    }

    private void findCandidates(List<TextFilePatch> list, final PatchBaseDirectoryDetector directoryDetector, Application application, List<PatchAndVariants> candidates, List<TextFilePatch> newOrWithoutMatches) {
        for (final TextFilePatch patch : list) {
            VirtualFile relativeFile;
            final String fileName = patch.getBeforeFileName();
            if (patch.isNewFile() || patch.getBeforeName() == null) {
                newOrWithoutMatches.add(patch);
                continue;
            }
            Collection files = (Collection)application.runReadAction((Computable)new Computable<Collection<VirtualFile>>(){

                public Collection<VirtualFile> compute() {
                    return directoryDetector.findFiles(fileName);
                }
            });
            if (patch.getBeforeName() != null && patch.getBeforeName().startsWith("..") && (relativeFile = VfsUtil.findRelativeFile((VirtualFile)this.myBaseDir, (String[])patch.getBeforeName().replace('\\', '/').split("/"))) != null) {
                files.add(relativeFile);
            }
            if (files.isEmpty()) {
                newOrWithoutMatches.add(patch);
                continue;
            }
            List<FilePatchInProgress> variants = ObjectsConvertor.convert(files, new Convertor<VirtualFile, FilePatchInProgress>(){

                public FilePatchInProgress convert(VirtualFile o) {
                    return MatchPatchPaths.this.processMatch(patch, o);
                }
            }, ObjectsConvertor.NOT_NULL);
            if (variants.isEmpty()) {
                newOrWithoutMatches.add(patch);
                continue;
            }
            candidates.add(new PatchAndVariants(patch, variants));
        }
    }

    private void putSelected(MultiMap<VirtualFile, FilePatchInProgress> result, List<FilePatchInProgress> variants, FilePatchInProgress patchInProgress) {
        patchInProgress.setAutoBases(ObjectsConvertor.convert(variants, new Convertor<FilePatchInProgress, VirtualFile>(){

            public VirtualFile convert(FilePatchInProgress o) {
                return o.getBase();
            }
        }, ObjectsConvertor.NOT_NULL));
        result.putValue((Object)patchInProgress.getBase(), (Object)patchInProgress);
    }

    private int getMatchingLines(FilePatchInProgress patch) {
        String text;
        VirtualFile base = patch.getCurrentBase();
        if (base == null) {
            return -1;
        }
        try {
            text = base.getLength() > 100000L ? VfsUtil.loadText((VirtualFile)base, (int)100000) : VfsUtil.loadText((VirtualFile)base);
        }
        catch (IOException e) {
            return 0;
        }
        return new GenericPatchApplier(text, patch.getPatch().getHunks()).weightContextMatch(100, 5);
    }

    private Pair<VirtualFile, Integer> compareNames(String beforeName, VirtualFile file) {
        if (beforeName == null) {
            return null;
        }
        String[] parts = beforeName.replace('\\', '/').split("/");
        return this.compareNamesImpl(parts, file.getParent(), parts.length - 2);
    }

    private Pair<VirtualFile, Integer> compareNamesImpl(String[] parts, VirtualFile parent, int idx) {
        VirtualFile previous = parent;
        while (parent != null && idx >= 0) {
            if (!parent.getName().equals(parts[idx])) {
                return new Pair((Object)parent, (Object)(idx + 1));
            }
            previous = parent;
            parent = parent.getParent();
            --idx;
        }
        return new Pair((Object)parent, (Object)(idx + 1));
    }

    @Nullable
    private FilePatchInProgress processMatch(TextFilePatch patch, VirtualFile file) {
        String beforeName = patch.getBeforeName();
        Pair<VirtualFile, Integer> pair = this.compareNames(beforeName, file);
        if (pair == null) {
            return null;
        }
        VirtualFile parent = (VirtualFile)pair.getFirst();
        if (parent != null) {
            FilePatchInProgress result = new FilePatchInProgress(patch, null, this.myBaseDir);
            result.setNewBase(parent);
            int numDown = (Integer)pair.getSecond();
            for (int i = 0; i < numDown; ++i) {
                result.up();
            }
            return result;
        }
        return null;
    }

    private static class PatchAndVariants {
        private final TextFilePatch myPatch;
        private final List<FilePatchInProgress> myVariants;

        private PatchAndVariants(TextFilePatch patch, List<FilePatchInProgress> variants) {
            this.myPatch = patch;
            this.myVariants = variants;
        }

        public TextFilePatch getPatch() {
            return this.myPatch;
        }

        public List<FilePatchInProgress> getVariants() {
            return this.myVariants;
        }
    }
}

