/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.FilePatchInProgress;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsCatchingRunnable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ImportToShelfExecutor
implements ApplyPatchExecutor {
    public static final String IMPORT_TO_SHELF = "Import to shelf";
    private final Project myProject;

    public ImportToShelfExecutor(Project project) {
        this.myProject = project;
    }

    @Override
    public String getName() {
        return IMPORT_TO_SHELF;
    }

    @Override
    public void apply(final MultiMap<VirtualFile, FilePatchInProgress> patchGroups, LocalChangeList localList, final String fileName, final TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        VcsCatchingRunnable vcsCatchingRunnable = new VcsCatchingRunnable(){

            public void runImpl() throws VcsException {
                VirtualFile baseDir = ImportToShelfExecutor.this.myProject.getBaseDir();
                final File ioBase = new File(baseDir.getPath());
                ArrayList<FilePatch> allPatches = new ArrayList<FilePatch>();
                for (VirtualFile virtualFile : patchGroups.keySet()) {
                    final File ioCurrentBase = new File(virtualFile.getPath());
                    allPatches.addAll(ObjectsConvertor.convert(patchGroups.get((Object)virtualFile), new Convertor<FilePatchInProgress, TextFilePatch>(){

                        public TextFilePatch convert(FilePatchInProgress o) {
                            TextFilePatch was = o.getPatch();
                            was.setBeforeName(FileUtil.toSystemIndependentName((String)FileUtil.getRelativePath((File)ioBase, (File)new File(ioCurrentBase, was.getBeforeName()))));
                            was.setAfterName(FileUtil.toSystemIndependentName((String)FileUtil.getRelativePath((File)ioBase, (File)new File(ioCurrentBase, was.getAfterName()))));
                            return was;
                        }
                    }));
                }
                if (!allPatches.isEmpty()) {
                    PatchEP[] patchTransitExtensions = null;
                    if (additionalInfo != null) {
                        try {
                            HashMap extensions = new HashMap();
                            for (Map.Entry entry : ((Map)additionalInfo.get()).entrySet()) {
                                String filePath = (String)entry.getKey();
                                Map extToValue = (Map)entry.getValue();
                                for (Map.Entry innerEntry : extToValue.entrySet()) {
                                    TransitExtension patchEP = (TransitExtension)extensions.get(innerEntry.getKey());
                                    if (patchEP == null) {
                                        patchEP = new TransitExtension((String)innerEntry.getKey());
                                        extensions.put(innerEntry.getKey(), patchEP);
                                    }
                                    patchEP.put(filePath, (CharSequence)innerEntry.getValue());
                                }
                            }
                            Collection values = extensions.values();
                            patchTransitExtensions = values.toArray(new PatchEP[values.size()]);
                        }
                        catch (PatchSyntaxException e) {
                            VcsBalloonProblemNotifier.showOverChangesView(ImportToShelfExecutor.this.myProject, "Can not import additional patch info: " + e.getMessage(), MessageType.ERROR, new NamedRunnable[0]);
                        }
                    }
                    try {
                        ShelvedChangeList shelvedChangeList = ShelveChangesManager.getInstance(ImportToShelfExecutor.this.myProject).importFilePatches(fileName, allPatches, patchTransitExtensions);
                        ShelvedChangesViewManager.getInstance(ImportToShelfExecutor.this.myProject).activateView(shelvedChangeList);
                    }
                    catch (IOException e) {
                        throw new VcsException((Throwable)e);
                    }
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)vcsCatchingRunnable, "Import patch to shelf", true, this.myProject);
        if (!vcsCatchingRunnable.get().isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(vcsCatchingRunnable.get(), IMPORT_TO_SHELF);
        }
    }

    private static class TransitExtension
    implements PatchEP {
        private final String myName;
        private final Map<String, CharSequence> myMap;

        private TransitExtension(String name) {
            this.myName = name;
            this.myMap = new HashMap<String, CharSequence>();
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ImportToShelfExecutor$TransitExtension", "getName"));
            }
            return string;
        }

        public CharSequence provideContent(@NotNull String path, CommitContext commitContext) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/patch/ImportToShelfExecutor$TransitExtension", "provideContent"));
            }
            return this.myMap.get(path);
        }

        public void consumeContent(@NotNull String path, @NotNull CharSequence content, CommitContext commitContext) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/patch/ImportToShelfExecutor$TransitExtension", "consumeContent"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/changes/patch/ImportToShelfExecutor$TransitExtension", "consumeContent"));
            }
            throw new UnsupportedOperationException();
        }

        public void consumeContentBeforePatchApplied(@NotNull String path, @NotNull CharSequence content, CommitContext commitContext) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/patch/ImportToShelfExecutor$TransitExtension", "consumeContentBeforePatchApplied"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/changes/patch/ImportToShelfExecutor$TransitExtension", "consumeContentBeforePatchApplied"));
            }
            throw new UnsupportedOperationException();
        }

        public void put(String fileName, CharSequence value) {
            this.myMap.put(fileName, value);
        }
    }
}

