/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.ui.ColoredTreeCellRenderer;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeLinkMouseListener
extends LinkMouseListenerBase {
    private final ColoredTreeCellRenderer myRenderer;
    protected TreeNode myLastHitNode;

    public TreeLinkMouseListener(ColoredTreeCellRenderer renderer) {
        this.myRenderer = renderer;
    }

    protected void showTooltip(JTree tree, MouseEvent e, HaveTooltip launcher) {
        String newText;
        String text = tree.getToolTipText(e);
        String string = newText = launcher == null ? null : launcher.getTooltip();
        if (!Comparing.equal((String)text, (String)newText)) {
            tree.setToolTipText(newText);
        }
    }

    @Nullable
    protected Object getTagAt(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/issueLinks/TreeLinkMouseListener", "getTagAt"));
        }
        JTree tree = (JTree)e.getSource();
        Object tag = null;
        HaveTooltip haveTooltip = null;
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            Rectangle rectangle = tree.getPathBounds(path);
            assert (rectangle != null);
            int dx = e.getX() - rectangle.x;
            TreeNode treeNode = (TreeNode)path.getLastPathComponent();
            if (this.myLastHitNode != treeNode) {
                this.myLastHitNode = treeNode;
                this.myRenderer.getTreeCellRendererComponent(tree, (Object)treeNode, false, false, treeNode.isLeaf(), -1, false);
            }
            if ((tag = this.myRenderer.getFragmentTagAt(dx)) != null && treeNode instanceof HaveTooltip) {
                haveTooltip = (HaveTooltip)((Object)treeNode);
            }
        }
        this.showTooltip(tree, e, haveTooltip);
        return tag;
    }

    public static interface HaveTooltip {
        public String getTooltip();
    }
}

