/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.dbCommitted;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.dbCommitted.CacheJdbcConnection;
import com.intellij.openapi.vcs.changes.dbCommitted.RevisionId;
import com.intellij.openapi.vcs.changes.dbCommitted.SqliteTables;
import com.intellij.util.ThrowableConvertor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SelectListsQueryHelper {
    private final CacheJdbcConnection myConnection;
    private final long myLast;
    private final long myFirst;
    private final Long myLocationId;
    private final String mySubfolder;
    private final boolean myNumberFake;

    public SelectListsQueryHelper(CacheJdbcConnection connection, RevisionId existingLast, RevisionId existingFirst, RevisionId last, RevisionId first, Long locationId, String subfolder) {
        this.myConnection = connection;
        this.myNumberFake = last.isNumberFake() && first.isNumberFake() && (!last.isFake() || !first.isFake());
        this.myLast = this.operating(last, existingLast);
        this.myFirst = this.operating(first, existingFirst);
        this.myLocationId = locationId;
        this.mySubfolder = subfolder;
    }

    private long operating(RevisionId last, RevisionId existing) {
        assert (!existing.isFake());
        if (this.myNumberFake) {
            return last.isFake() ? existing.getTime() : last.getTime();
        }
        return last.isNumberFake() ? existing.getNumber() : last.getNumber();
    }

    public PreparedStatement createStatement() throws VcsException, SQLException {
        if (this.myNumberFake) {
            if (StringUtil.isEmptyOrSpaces((String)this.mySubfolder)) {
                return this.createDatesOnly();
            }
            return this.createDatesSubfolder();
        }
        if (StringUtil.isEmptyOrSpaces((String)this.mySubfolder)) {
            return this.createNumbersOnly();
        }
        return this.createNumbersSubfolder();
    }

    private PreparedStatement createNumbersSubfolder() throws VcsException, SQLException {
        PreparedStatement impl = this.createImpl("PREPARED_NUMBERS_SUBFOLDER", " R." + SqliteTables.REVISION.NUMBER_INT + ">=? AND R." + SqliteTables.REVISION.NUMBER_INT + "<=? AND P." + SqliteTables.PATHS.PATH + " LIKE ?");
        impl.setLong(2, this.myFirst);
        impl.setLong(3, this.myLast);
        impl.setString(4, this.mySubfolder + "%");
        return impl;
    }

    private PreparedStatement createNumbersOnly() throws VcsException, SQLException {
        PreparedStatement impl = this.createImpl("PREPARED_NUMBERS_ONLY", " R." + SqliteTables.REVISION.NUMBER_INT + ">=? AND R." + SqliteTables.REVISION.NUMBER_INT + "<=? ");
        impl.setLong(2, this.myFirst);
        impl.setLong(3, this.myLast);
        return impl;
    }

    private PreparedStatement createDatesSubfolder() throws VcsException, SQLException {
        PreparedStatement impl = this.createImpl("PREPARED_DATES_SUBFOLDER", " R." + SqliteTables.REVISION.DATE + ">=? AND R." + SqliteTables.REVISION.DATE + "<=? AND P." + SqliteTables.PATHS.PATH + " LIKE ?");
        impl.setLong(2, this.myFirst);
        impl.setLong(3, this.myLast);
        impl.setString(4, this.mySubfolder + "%");
        return impl;
    }

    private PreparedStatement createDatesOnly() throws VcsException, SQLException {
        PreparedStatement impl = this.createImpl("PREPARED_DATES_ONLY", " R." + SqliteTables.REVISION.DATE + ">=? AND R." + SqliteTables.REVISION.DATE + "<=? ");
        impl.setLong(2, this.myFirst);
        impl.setLong(3, this.myLast);
        return impl;
    }

    private PreparedStatement createImpl(String queryName, final String whereClause) throws VcsException, SQLException {
        PreparedStatement statement = this.myConnection.getOrCreatePreparedStatement(queryName, new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

            public PreparedStatement convert(Connection connection) throws SQLException {
                return connection.prepareStatement("SELECT " + SqliteTables.REVISION.RAW_DATA + " , " + SqliteTables.REVISION.NUMBER_INT + " FROM " + SqliteTables.REVISION.TABLE_NAME + " R INNER JOIN " + SqliteTables.PATHS_2_REVS.TABLE_NAME + " PR ON R." + SqliteTables.REVISION.ID + " = PR." + SqliteTables.PATHS_2_REVS.REVISION_FK + " , " + SqliteTables.PATHS.TABLE_NAME + " P ON PR." + SqliteTables.PATHS_2_REVS.PATH_FK + " = P." + SqliteTables.PATHS.ID + " WHERE R." + SqliteTables.REVISION.ROOT_FK + " = ? AND " + whereClause + " ORDER BY " + SqliteTables.REVISION.NUMBER_INT + " DESC");
            }
        });
        statement.setLong(1, this.myLocationId);
        return statement;
    }
}

