/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.dbCommitted;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.dbCommitted.RevisionId;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class KnownRepositoryLocations {
    private static final int ourMaxAuthorsCached = 400;
    private final Map<String, Long> myJustVcs;
    private final MultiMap<String, String> myMap = MultiMap.createSet();
    private final Map<Pair<String, String>, Long> myLocations = new HashMap<Pair<String, String>, Long>();
    private final Map<Long, RevisionId> myLastRevision = new HashMap<Long, RevisionId>();
    private final Map<Long, RevisionId> myFirstRevision = new HashMap<Long, RevisionId>();
    private final Map<String, Long> myAuthors;

    public KnownRepositoryLocations() {
        this.myJustVcs = new HashMap<String, Long>();
        this.myAuthors = new HashMap<String, Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> filterKnownAuthors(Set<String> names) {
        if (names.isEmpty()) {
            return Collections.emptyMap();
        }
        MultiMap<String, String> multiMap = this.myMap;
        synchronized (multiMap) {
            HashMap<String, Long> result = new HashMap<String, Long>();
            Iterator<String> iterator = names.iterator();
            while (iterator.hasNext()) {
                String name = iterator.next();
                Long pk = this.myAuthors.get(name);
                if (pk == null) continue;
                iterator.remove();
                result.put(name, pk);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKnownAuthor(String name, long pk) {
        MultiMap<String, String> multiMap = this.myMap;
        synchronized (multiMap) {
            if (this.myAuthors.size() > 400) {
                Iterator<Map.Entry<String, Long>> iterator = this.myAuthors.entrySet().iterator();
                for (int cnt = 10; iterator.hasNext() && cnt > 0; --cnt) {
                    Map.Entry<String, Long> next = iterator.next();
                    iterator.remove();
                }
            }
            this.myAuthors.put(name, pk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key) {
        MultiMap<String, String> multiMap = this.myMap;
        synchronized (multiMap) {
            return this.myJustVcs.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getVcsKey(String key) {
        MultiMap<String, String> multiMap = this.myMap;
        synchronized (multiMap) {
            Long aLong = this.myJustVcs.get(key);
            assert (aLong != null);
            return aLong;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key, String path) {
        MultiMap<String, String> multiMap = this.myMap;
        synchronized (multiMap) {
            Collection strings = this.myMap.get((Object)key);
            return strings != null && strings.contains(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVcs(String key, long id) {
        MultiMap<String, String> multiMap = this.myMap;
        synchronized (multiMap) {
            this.myJustVcs.put(key, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLocationId(String key, String path) {
        MultiMap<String, String> multiMap = this.myMap;
        synchronized (multiMap) {
            Long id = this.myLocations.get(new Pair((Object)key, (Object)path));
            assert (id != null);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String key, String path, long id) {
        MultiMap<String, String> multiMap = this.myMap;
        synchronized (multiMap) {
            this.myMap.putValue((Object)key, (Object)path);
            this.myLocations.put((Pair<String, String>)new Pair((Object)key, (Object)path), id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RevisionId getLastRevision(Long rootId) {
        MultiMap<String, String> multiMap = this.myMap;
        synchronized (multiMap) {
            return this.myLastRevision.get(rootId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastRevision(Long rootId, RevisionId number) {
        MultiMap<String, String> multiMap = this.myMap;
        synchronized (multiMap) {
            this.myLastRevision.put(rootId, number);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RevisionId getFirstRevision(Long rootId) {
        MultiMap<String, String> multiMap = this.myMap;
        synchronized (multiMap) {
            return this.myFirstRevision.get(rootId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirstRevision(Long rootId, RevisionId number) {
        MultiMap<String, String> multiMap = this.myMap;
        synchronized (multiMap) {
            this.myFirstRevision.put(rootId, number);
        }
    }
}

