/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictNotificationPanel;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;

public class ChangelistConflictNotificationProvider
extends EditorNotifications.Provider<ChangelistConflictNotificationPanel> {
    private static final Key<ChangelistConflictNotificationPanel> KEY = Key.create((String)"changelistConflicts");
    private final ChangelistConflictTracker myConflictTracker;

    public ChangelistConflictNotificationProvider(ChangeListManagerImpl changeListManager) {
        this.myConflictTracker = changeListManager.getConflictTracker();
    }

    public Key<ChangelistConflictNotificationPanel> getKey() {
        return KEY;
    }

    public ChangelistConflictNotificationPanel createNotificationPanel(VirtualFile file, FileEditor fileEditor) {
        return this.myConflictTracker.hasConflict(file) ? ChangelistConflictNotificationPanel.create(this.myConflictTracker, file) : null;
    }
}

