/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedList;
import java.util.List;

public class SelectedFilesHelper
implements Runnable {
    private final List<MyChecker> myCheckers;
    private final FileStatusManager myStatusManager;
    private final VirtualFile[] myData;
    private int myCnt;

    private SelectedFilesHelper(Project project, AnActionEvent e) {
        this.myStatusManager = FileStatusManager.getInstance((Project)project);
        this.myData = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        this.myCheckers = new LinkedList<MyChecker>();
    }

    private void add(MyChecker checker) {
        this.myCheckers.add(checker);
    }

    public static boolean hasChangedSelectedFiles(Project project, AnActionEvent e) {
        SelectedFilesHelper helper = new SelectedFilesHelper(project, e);
        helper.add(new MyChangedChecker(helper));
        return helper.execute();
    }

    public static boolean hasChangedOrUnversionedFiles(Project project, AnActionEvent e) {
        SelectedFilesHelper helper = new SelectedFilesHelper(project, e);
        helper.add(new MyChangedChecker(helper));
        helper.add(new MyUnversionedChecker(helper));
        return helper.execute();
    }

    private boolean execute() {
        if (this.myData != null && this.myData.length > 0) {
            this.myCnt = this.myCheckers.size();
            for (VirtualFile vf : this.myData) {
                FileStatus status = this.myStatusManager.getStatus(vf);
                for (MyChecker checker : this.myCheckers) {
                    checker.execute(status);
                }
                if (this.myCnt <= 0) break;
            }
            boolean result = false;
            for (MyChecker checker : this.myCheckers) {
                result |= checker.isFound();
            }
            return result;
        }
        return false;
    }

    @Override
    public void run() {
        --this.myCnt;
    }

    private static abstract class MyChecker {
        private boolean myFound;
        private final Runnable myFinishedListener;

        protected MyChecker(Runnable finishedListener) {
            this.myFinishedListener = finishedListener;
        }

        protected abstract boolean check(FileStatus var1);

        public void execute(FileStatus status) {
            if (this.myFound) {
                return;
            }
            if (this.check(status)) {
                this.myFound = true;
                this.myFinishedListener.run();
            }
        }

        public boolean isFound() {
            return this.myFound;
        }
    }

    private static class MyChangedChecker
    extends MyChecker {
        private MyChangedChecker(Runnable finishedListener) {
            super(finishedListener);
        }

        @Override
        protected boolean check(FileStatus status) {
            return !FileStatus.UNKNOWN.equals(status) && !FileStatus.NOT_CHANGED.equals(status) && !FileStatus.IGNORED.equals(status);
        }
    }

    private static class MyUnversionedChecker
    extends MyChecker {
        private MyUnversionedChecker(Runnable finishedListener) {
            super(finishedListener);
        }

        @Override
        protected boolean check(FileStatus status) {
            return FileStatus.UNKNOWN.equals(status);
        }
    }
}

