/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesViewRefresher;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.annotations.NotNull;

public class RefreshAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        RefreshAction.doRefresh(project);
    }

    public static void doRefresh(final Project project) {
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        RefreshAction.invokeCustomRefreshes(project);
        VirtualFileManager.getInstance().asyncRefresh(new Runnable(){

            @Override
            public void run() {
                if (!project.isDisposed()) {
                    VcsDirtyScopeManager.getInstance((Project)project).markEverythingDirty();
                }
            }
        });
    }

    private static void invokeCustomRefreshes(@NotNull Project project) {
        ChangesViewRefresher[] extensions;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/actions/RefreshAction", "invokeCustomRefreshes"));
        }
        for (ChangesViewRefresher refresher : extensions = (ChangesViewRefresher[])ChangesViewRefresher.EP_NAME.getExtensions()) {
            refresher.refresh(project);
        }
    }
}

