/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;

public abstract class AbstractCommitChangesAction
extends AbstractCommonCheckinAction {
    @Override
    protected FilePath[] getRoots(VcsContext context) {
        return AbstractCommitChangesAction.getAllContentRoots(context);
    }

    @Override
    protected boolean approximatelyHasRoots(VcsContext dataContext) {
        Project project = dataContext.getProject();
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
        return manager.hasAnyMappings();
    }

    @Override
    protected boolean filterRootsBeforeAction() {
        return false;
    }

    @Override
    protected void update(VcsContext vcsContext, Presentation presentation) {
        super.update(vcsContext, presentation);
        if (presentation.isVisible() && presentation.isEnabled()) {
            ChangeList[] selectedChangeLists = vcsContext.getSelectedChangeLists();
            Change[] selectedChanges = vcsContext.getSelectedChanges();
            if (((String)vcsContext.getPlace()).equals("ChangesViewPopup")) {
                if (selectedChangeLists != null && selectedChangeLists.length > 0) {
                    presentation.setEnabled(selectedChangeLists.length == 1);
                } else {
                    presentation.setEnabled(selectedChanges != null && selectedChanges.length > 0);
                }
            }
            if (presentation.isEnabled() && selectedChanges != null) {
                ChangeListManager changeListManager = ChangeListManager.getInstance((Project)vcsContext.getProject());
                for (Change c : selectedChanges) {
                    if (c.getFileStatus() != FileStatus.HIJACKED || changeListManager.getChangeList(c) != null) continue;
                    presentation.setEnabled(false);
                    break;
                }
            }
        }
    }
}

