/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ConstantZipperUpdater;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Alarm;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeVfsListener
implements ApplicationComponent,
BulkFileListener {
    private final ProjectLocator myProjectLocator = ProjectLocator.getInstance();
    private final MessageBusConnection myMessageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
    private boolean myForbid;
    private final ConstantZipperUpdater myZipperUpdater;
    private final List<FileAndDirsCollector> myQueue;
    private final Object myLock = new Object();
    private final Runnable myDirtReporter;

    public VcsDirtyScopeVfsListener() {
        this.myQueue = new ArrayList<FileAndDirsCollector>();
        this.myDirtReporter = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList list;
                Object object = VcsDirtyScopeVfsListener.this.myLock;
                synchronized (object) {
                    list = new ArrayList(VcsDirtyScopeVfsListener.this.myQueue);
                    VcsDirtyScopeVfsListener.this.myQueue.clear();
                }
                HashMap map = new HashMap();
                for (FileAndDirsCollector collector : list) {
                    Map<VcsDirtyScopeManager, Pair<HashSet<FilePath>, HashSet<FilePath>>> pairMap = collector.map;
                    for (Map.Entry<VcsDirtyScopeManager, Pair<HashSet<FilePath>, HashSet<FilePath>>> entry : pairMap.entrySet()) {
                        VcsDirtyScopeManager key = entry.getKey();
                        Pair existing = (Pair)map.get(key);
                        Pair<HashSet<FilePath>, HashSet<FilePath>> value = entry.getValue();
                        if (existing != null) {
                            ((HashSet)existing.getFirst()).addAll((Collection)value.getFirst());
                            ((HashSet)existing.getSecond()).addAll((Collection)value.getSecond());
                            continue;
                        }
                        map.put(key, value);
                    }
                }
                new FileAndDirsCollector().markDirty((Map)map);
            }
        };
        this.myZipperUpdater = new ConstantZipperUpdater(300, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication(), this.myDirtReporter);
    }

    public void setForbid(boolean forbid) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myForbid = forbid;
    }

    public void flushDirt() {
        this.myDirtReporter.run();
    }

    @NotNull
    public String getComponentName() {
        String string = VcsDirtyScopeVfsListener.class.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeVfsListener", "getComponentName"));
        }
        return string;
    }

    public void initComponent() {
        this.myMessageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
    }

    public void disposeComponent() {
        this.myMessageBusConnection.disconnect();
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/VcsDirtyScopeVfsListener", "before"));
        }
        if (this.myForbid) {
            return;
        }
        FileAndDirsCollector dirtyFilesAndDirs = new FileAndDirsCollector();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = VcsDirtyScopeVfsListener.getFileForEvent(vFileEvent);
            if (file == null) continue;
            if (vFileEvent instanceof VFileDeleteEvent) {
                if (!file.isInLocalFileSystem()) continue;
                dirtyFilesAndDirs.add(file, true);
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            dirtyFilesAndDirs.add(file, true);
        }
        this.markDirtyOnPooled(dirtyFilesAndDirs);
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/VcsDirtyScopeVfsListener", "after"));
        }
        if (this.myForbid) {
            return;
        }
        FileAndDirsCollector dirtyFilesAndDirs = new FileAndDirsCollector();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file;
            if (vFileEvent instanceof VFileDeleteEvent || (file = VcsDirtyScopeVfsListener.getFileForEvent(vFileEvent)) == null) continue;
            if (vFileEvent instanceof VFileContentChangeEvent || vFileEvent instanceof VFileCopyEvent || vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileMoveEvent) {
                dirtyFilesAndDirs.add(file, false);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)vFileEvent;
            if (pce.getPropertyName().equals("name")) {
                dirtyFilesAndDirs.add(file, false);
                dirtyFilesAndDirs.addToFiles(file.getParent(), false);
                continue;
            }
            dirtyFilesAndDirs.addToFiles(file, false);
        }
        this.markDirtyOnPooled(dirtyFilesAndDirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDirtyOnPooled(FileAndDirsCollector dirtyFilesAndDirs) {
        Object object = this.myLock;
        synchronized (object) {
            this.myQueue.add(dirtyFilesAndDirs);
        }
        this.myZipperUpdater.request();
    }

    @Nullable
    private static VirtualFile getFileForEvent(VFileEvent event) {
        return VcsUtil.getVirtualFile((String)event.getPath());
    }

    @NotNull
    private Collection<VcsDirtyScopeManager> getManagers(final VirtualFile file) {
        HashSet result = new HashSet();
        if (file == null) {
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeVfsListener", "getManagers"));
            }
            return hashSet;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable((Collection)result){
            final /* synthetic */ Collection val$result;
            {
                this.val$result = collection;
            }

            @Override
            public void run() {
                Collection projects = VcsDirtyScopeVfsListener.this.myProjectLocator.getProjectsForFile(file);
                for (Project project : projects) {
                    VcsDirtyScopeManager manager = VcsDirtyScopeManager.getInstance((Project)project);
                    if (manager == null || !project.isInitialized()) continue;
                    this.val$result.add(manager);
                }
            }
        });
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeVfsListener", "getManagers"));
        }
        return hashSet;
    }

    private class FileAndDirsCollector {
        Map<VcsDirtyScopeManager, Pair<HashSet<FilePath>, HashSet<FilePath>>> map = new HashMap();

        private FileAndDirsCollector() {
        }

        private void add(VirtualFile file, boolean addToFiles, boolean forDelete) {
            if (file == null) {
                return;
            }
            boolean isDirectory = file.isDirectory();
            FilePathImpl path = forDelete ? new FilePathImpl(new File(file.getPath()), isDirectory) : new FilePathImpl(file);
            Collection managers = VcsDirtyScopeVfsListener.this.getManagers(file);
            for (VcsDirtyScopeManager manager : managers) {
                Pair filesAndDirs = this.map.get(manager);
                if (filesAndDirs == null) {
                    filesAndDirs = Pair.create((Object)new HashSet(), (Object)new HashSet());
                    this.map.put(manager, (Pair<HashSet<FilePath>, HashSet<FilePath>>)filesAndDirs);
                }
                if (addToFiles || !isDirectory) {
                    ((HashSet)filesAndDirs.first).add((Object)path);
                    continue;
                }
                ((HashSet)filesAndDirs.second).add((Object)path);
            }
        }

        private void add(VirtualFile file, boolean forDelete) {
            this.add(file, false, forDelete);
        }

        private void addToFiles(VirtualFile file, boolean forDelete) {
            this.add(file, true, forDelete);
        }

        private void markDirty(Map<VcsDirtyScopeManager, Pair<HashSet<FilePath>, HashSet<FilePath>>> outerMap) {
            for (Map.Entry<VcsDirtyScopeManager, Pair<HashSet<FilePath>, HashSet<FilePath>>> entry : outerMap.entrySet()) {
                VcsDirtyScopeManager manager = entry.getKey();
                HashSet files = (HashSet)entry.getValue().first;
                HashSet dirs = (HashSet)entry.getValue().second;
                manager.filePathsDirty((Collection)files, (Collection)dirs);
            }
        }
    }
}

