/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.DirtBuilder;
import com.intellij.openapi.vcs.changes.DirtBuilderReader;
import com.intellij.openapi.vcs.changes.FilePathUnderVcs;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeImpl;
import com.intellij.openapi.vcs.changes.VcsGuess;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Scopes {
    private final Project myProject;
    private final VcsGuess myGuess;
    private boolean myEverythingDirty;
    private final Map<AbstractVcs, VcsDirtyScopeImpl> myScopes;

    public Scopes(Project project, VcsGuess guess) {
        this.myProject = project;
        this.myGuess = guess;
        this.myScopes = new HashMap<AbstractVcs, VcsDirtyScopeImpl>();
    }

    private void markEverythingDirty() {
        this.myScopes.clear();
        this.myEverythingDirty = true;
        DirtBuilder builder = new DirtBuilder(this.myGuess);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        List mappings = vcsManager.getDirectoryMappings();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (VcsDirectoryMapping mapping : mappings) {
            if (mapping.isDefaultMapping()) {
                DefaultVcsRootPolicy.getInstance(this.myProject).markDefaultRootsDirty(builder, this.myGuess);
                continue;
            }
            if (mapping.getVcs() == null) continue;
            String vcsName = mapping.getVcs();
            AbstractVcs vcs = vcsManager.findVcsByName(vcsName);
            VirtualFile file = lfs.findFileByPath(mapping.getDirectory());
            if (file == null) continue;
            builder.addDirtyDirRecursively(new VcsRoot(vcs, file));
        }
        DefaultVcsRootPolicy.getInstance(this.myProject).markDefaultRootsDirty(builder, this.myGuess);
        this.takeDirt(builder);
    }

    public void takeDirt(DirtBuilderReader dirt) {
        if (dirt.isEverythingDirty()) {
            this.markEverythingDirty();
            return;
        }
        Collection<FilePathUnderVcs> dirs = dirt.getDirsForVcs();
        Collection<FilePathUnderVcs> files = dirt.getFilesForVcs();
        MultiMap filesMap = new MultiMap();
        MultiMap dirsMap = new MultiMap();
        for (FilePathUnderVcs dir : dirs) {
            dirsMap.putValue((Object)dir.getVcs(), (Object)dir.getPath());
        }
        for (FilePathUnderVcs file : files) {
            filesMap.putValue((Object)file.getVcs(), (Object)file.getPath());
        }
        HashSet keys = new HashSet(filesMap.keySet());
        keys.addAll(dirsMap.keySet());
        for (AbstractVcs key : keys) {
            Collection<Object> dirPaths = dirsMap.get((Object)key);
            dirPaths = dirPaths == null ? Collections.emptyList() : dirPaths;
            List<FilePath> filePaths = filesMap.get((Object)key);
            filePaths = filePaths == null ? Collections.emptyList() : filePaths;
            this.getScope(key).addDirtyData(dirPaths, filePaths);
        }
    }

    public void addDirtyDirRecursively(@NotNull AbstractVcs vcs, @NotNull FilePath newcomer) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/Scopes", "addDirtyDirRecursively"));
        }
        if (newcomer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/changes/Scopes", "addDirtyDirRecursively"));
        }
        this.getScope(vcs).addDirtyDirRecursively(newcomer);
    }

    public void addDirtyFile(@NotNull AbstractVcs vcs, @NotNull FilePath newcomer) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/Scopes", "addDirtyFile"));
        }
        if (newcomer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/changes/Scopes", "addDirtyFile"));
        }
        this.getScope(vcs).addDirtyFile(newcomer);
    }

    @NotNull
    public VcsInvalidated retrieveAndClear() {
        ArrayList<VcsDirtyScopeImpl> scopesList = new ArrayList<VcsDirtyScopeImpl>(this.myScopes.values());
        VcsInvalidated result = new VcsInvalidated(scopesList, this.myEverythingDirty);
        this.myEverythingDirty = false;
        this.myScopes.clear();
        VcsInvalidated vcsInvalidated = result;
        if (vcsInvalidated == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/Scopes", "retrieveAndClear"));
        }
        return vcsInvalidated;
    }

    private VcsDirtyScopeImpl getScope(AbstractVcs vcs) {
        VcsDirtyScopeImpl scope = this.myScopes.get(vcs);
        if (scope == null) {
            scope = new VcsDirtyScopeImpl(vcs, this.myProject);
            this.myScopes.put(vcs, scope);
        }
        return scope;
    }
}

