/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.IgnoreSettingsType;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IgnoredFilesComponent {
    private final Set<IgnoredFileBean> myFilesToIgnore;
    private final Map<String, IgnoredFileBean> myFilesMap;

    public IgnoredFilesComponent(Project project, boolean registerListener) {
        this.myFilesToIgnore = new LinkedHashSet<IgnoredFileBean>();
        this.myFilesMap = new HashMap<String, IgnoredFileBean>();
        if (registerListener) {
            project.getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

                public void after(@NotNull List<? extends VFileEvent> events) {
                    if (events == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/IgnoredFilesComponent$1", "after"));
                    }
                    IgnoredFilesComponent.this.resetCaches();
                }
            });
        }
    }

    public IgnoredFilesComponent(IgnoredFilesComponent other) {
        this.myFilesToIgnore = new LinkedHashSet<IgnoredFileBean>(other.myFilesToIgnore);
        this.myFilesMap = new HashMap<String, IgnoredFileBean>(other.myFilesMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IgnoredFileBean ... filesToIgnore) {
        Set<IgnoredFileBean> set = this.myFilesToIgnore;
        synchronized (set) {
            Collections.addAll(this.myFilesToIgnore, filesToIgnore);
            this.addIgnoredFiles(filesToIgnore);
        }
    }

    private void addIgnoredFiles(IgnoredFileBean ... filesToIgnore) {
        for (IgnoredFileBean bean : filesToIgnore) {
            Project project;
            VirtualFile baseDir;
            if (!IgnoreSettingsType.FILE.equals((Object)bean.getType()) || (baseDir = (project = bean.getProject()).getBaseDir()) == null) continue;
            this.myFilesMap.put(FilePathsHelper.convertPath((String)baseDir.getPath(), (String)bean.getPath()), bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set<IgnoredFileBean> set = this.myFilesToIgnore;
        synchronized (set) {
            this.myFilesToIgnore.clear();
            this.myFilesMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Set<IgnoredFileBean> set = this.myFilesToIgnore;
        synchronized (set) {
            return this.myFilesToIgnore.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(IgnoredFileBean ... filesToIgnore) {
        Set<IgnoredFileBean> set = this.myFilesToIgnore;
        synchronized (set) {
            this.myFilesToIgnore.clear();
            Collections.addAll(this.myFilesToIgnore, filesToIgnore);
            this.myFilesMap.clear();
            this.addIgnoredFiles(filesToIgnore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgnoredFileBean[] getFilesToIgnore() {
        Set<IgnoredFileBean> set = this.myFilesToIgnore;
        synchronized (set) {
            return this.myFilesToIgnore.toArray(new IgnoredFileBean[this.myFilesToIgnore.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCaches() {
        Set<IgnoredFileBean> set = this.myFilesToIgnore;
        synchronized (set) {
            for (IgnoredFileBean bean : this.myFilesToIgnore) {
                bean.resetCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIgnoredFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/changes/IgnoredFilesComponent", "isIgnoredFile"));
        }
        Set<IgnoredFileBean> set = this.myFilesToIgnore;
        synchronized (set) {
            if (this.myFilesToIgnore.size() == 0) {
                return false;
            }
            String path = FilePathsHelper.convertPath((VirtualFile)file);
            IgnoredFileBean fileBean = this.myFilesMap.get(path);
            if (fileBean != null && fileBean.matchesFile(file)) {
                return true;
            }
            for (IgnoredFileBean bean : this.myFilesToIgnore) {
                if (!bean.matchesFile(file)) continue;
                return true;
            }
            return false;
        }
    }
}

