/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsQuickListContentProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsQuickListPopupAction
extends QuickSwitchSchemeAction
implements DumbAware {
    public VcsQuickListPopupAction() {
        this.myActionPlace = "ActionPlace.VcsQuickListPopupAction";
    }

    protected void fillActions(@Nullable Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillActions"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillActions"));
        }
        if (project == null) {
            return;
        }
        Pair<SupportedVCS, AbstractVcs> typeAndVcs = this.getActiveVCS(project, dataContext);
        AbstractVcs vcs = (AbstractVcs)typeAndVcs.getSecond();
        SupportedVCS popupType = (SupportedVCS)((Object)typeAndVcs.getFirst());
        switch (popupType) {
            case VCS: {
                this.fillVcsPopup(project, group, dataContext, vcs);
                break;
            }
            case NOT_IN_VCS: {
                this.fillNonInVcsActions(project, group, dataContext);
            }
        }
    }

    protected boolean isEnabled() {
        return true;
    }

    private void fillVcsPopup(@NotNull Project project, @NotNull DefaultActionGroup group, @Nullable DataContext dataContext, @Nullable AbstractVcs vcs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillVcsPopup"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillVcsPopup"));
        }
        if (vcs != null) {
            for (VcsQuickListContentProvider provider : (VcsQuickListContentProvider[])VcsQuickListContentProvider.EP_NAME.getExtensions()) {
                List actionsToReplace;
                if (!provider.replaceVcsActionsFor(vcs, dataContext) || (actionsToReplace = provider.getVcsActions(project, vcs, dataContext)) == null) continue;
                this.addActions(actionsToReplace, group);
                this.addLocalHistoryActions(group);
                return;
            }
        }
        this.fillGeneralVcsPopup(project, group, dataContext, vcs);
    }

    private void fillGeneralVcsPopup(@NotNull Project project, @NotNull DefaultActionGroup group, @Nullable DataContext dataContext, @Nullable AbstractVcs vcs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillGeneralVcsPopup"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillGeneralVcsPopup"));
        }
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        for (VcsQuickListContentProvider provider : (VcsQuickListContentProvider[])VcsQuickListContentProvider.EP_NAME.getExtensions()) {
            List providerActions = provider.getVcsActions(project, vcs, dataContext);
            if (providerActions == null) continue;
            actions.addAll(providerActions);
        }
        this.addSeparator(group, vcs != null ? vcs.getDisplayName() : null);
        this.addAction("ChangesView.AddUnversioned", group);
        this.addAction("CheckinProject", group);
        this.addAction("CheckinFiles", group);
        this.addAction("ChangesView.Rollback", group);
        this.addSeparator(group);
        this.addAction("Vcs.ShowTabbedFileHistory", group);
        this.addAction("Annotate", group);
        this.addAction("Compare.SameVersion", group);
        this.addSeparator(group);
        this.addActions(actions, group);
        this.addSeparator(group);
        this.addAction("ChangesView.Move", group);
        this.addLocalHistoryActions(group);
    }

    private void fillNonInVcsActions(@NotNull Project project, @NotNull DefaultActionGroup group, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillNonInVcsActions"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillNonInVcsActions"));
        }
        for (VcsQuickListContentProvider provider : (VcsQuickListContentProvider[])VcsQuickListContentProvider.EP_NAME.getExtensions()) {
            List actions = provider.getNotInVcsActions(project, dataContext);
            if (actions == null) continue;
            this.addActions(actions, group);
        }
        this.addSeparator(group);
        this.addAction("Start.Use.Vcs", group);
        this.addAction("Vcs.Checkout", group);
        this.addLocalHistoryActions(group);
    }

    private void addLocalHistoryActions(DefaultActionGroup group) {
        this.addSeparator(group, VcsBundle.message((String)"vcs.quicklist.pupup.section.local.history", (Object[])new Object[0]));
        this.addAction("LocalHistory.ShowHistory", group);
        this.addAction("LocalHistory.PutLabel", group);
    }

    private void addActions(@NotNull List<AnAction> actions, @NotNull DefaultActionGroup toGroup) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "addActions"));
        }
        if (toGroup == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "addActions"));
        }
        for (AnAction action : actions) {
            toGroup.addAction(action);
        }
    }

    private Pair<SupportedVCS, AbstractVcs> getActiveVCS(@NotNull Project project, @Nullable DataContext dataContext) {
        AbstractVcs vscForFile;
        VirtualFile file;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "getActiveVCS"));
        }
        AbstractVcs[] activeVcss = this.getActiveVCSs(project);
        if (activeVcss.length == 0) {
            return new Pair((Object)SupportedVCS.NOT_IN_VCS, null);
        }
        if (activeVcss.length == 1) {
            return new Pair((Object)SupportedVCS.VCS, (Object)activeVcss[0]);
        }
        VirtualFile virtualFile = file = dataContext != null ? (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext) : null;
        if (file != null && (vscForFile = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file)) != null) {
            return new Pair((Object)SupportedVCS.VCS, (Object)vscForFile);
        }
        return new Pair((Object)SupportedVCS.VCS, null);
    }

    private AbstractVcs[] getActiveVCSs(Project project) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        return vcsManager.getAllActiveVcss();
    }

    private void addAction(String actionId, DefaultActionGroup toGroup) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action != null) {
            toGroup.add(action);
        }
    }

    private void addSeparator(DefaultActionGroup toGroup) {
        this.addSeparator(toGroup, null);
    }

    private void addSeparator(DefaultActionGroup toGroup, @Nullable String title) {
        Separator separator = title == null ? new Separator() : new Separator(title);
        toGroup.add((AnAction)separator);
    }

    protected String getPopupTitle(AnActionEvent e) {
        return VcsBundle.message((String)"vcs.quicklist.popup.title", (Object[])new Object[0]);
    }

    public static enum SupportedVCS {
        VCS,
        NOT_IN_VCS;

    }
}

