/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;

public class CommonCheckinFilesAction
extends AbstractCommonCheckinAction {
    @Override
    protected String getActionName(VcsContext dataContext) {
        String checkinActionName = this.getCheckinActionName(dataContext);
        return this.modifyCheckinActionName(dataContext, checkinActionName);
    }

    private String modifyCheckinActionName(VcsContext dataContext, String checkinActionName) {
        FilePath[] roots = this.getRoots(dataContext);
        if (roots == null || roots.length == 0) {
            return checkinActionName;
        }
        FilePath first = roots[0];
        if (roots.length == 1) {
            if (first.isDirectory()) {
                return VcsBundle.message((String)"action.name.checkin.directory", (Object[])new Object[]{checkinActionName});
            }
            return VcsBundle.message((String)"action.name.checkin.file", (Object[])new Object[]{checkinActionName});
        }
        if (first.isDirectory()) {
            return VcsBundle.message((String)"action.name.checkin.directories", (Object[])new Object[]{checkinActionName});
        }
        return VcsBundle.message((String)"action.name.checkin.files", (Object[])new Object[]{checkinActionName});
    }

    @Override
    protected String getMnemonicsFreeActionName(VcsContext context) {
        return this.modifyCheckinActionName(context, VcsBundle.message((String)"vcs.command.name.checkin.no.mnemonics", (Object[])new Object[0]));
    }

    @Override
    protected LocalChangeList getInitiallySelectedChangeList(VcsContext context, Project project) {
        FilePath[] roots;
        final ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        for (FilePath root : roots = this.getRoots(context)) {
            VirtualFile file = root.getVirtualFile();
            if (file == null) continue;
            final Ref change = new Ref();
            if (!file.isDirectory()) {
                change.set((Object)changeListManager.getChange(file));
            } else {
                final FileIndexFacade index = (FileIndexFacade)PeriodicalTasksCloser.getInstance().safeGetService(project, FileIndexFacade.class);
                VirtualFileFilter filter = new VirtualFileFilter(){

                    public boolean accept(final VirtualFile file) {
                        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                            public Boolean compute() {
                                return !index.isExcludedFile(file);
                            }
                        });
                    }
                };
                VfsUtilCore.iterateChildrenRecursively((VirtualFile)file, (VirtualFileFilter)filter, (ContentIterator)new ContentIterator(){

                    public boolean processFile(VirtualFile fileOrDir) {
                        Change c = changeListManager.getChange(fileOrDir);
                        if (c != null) {
                            change.set((Object)c);
                            return false;
                        }
                        return true;
                    }
                });
            }
            if (change.isNull()) continue;
            return changeListManager.getChangeList((Change)change.get());
        }
        return changeListManager.getDefaultChangeList();
    }

    private String getCheckinActionName(VcsContext dataContext) {
        Project project = dataContext.getProject();
        if (project == null) {
            return VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]);
        }
        AbstractVcs vcs = CommonCheckinFilesAction.getCommonVcsFor(this.getRoots(dataContext), project);
        if (vcs == null) {
            return VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]);
        }
        CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
        if (checkinEnvironment == null) {
            return VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]);
        }
        return checkinEnvironment.getCheckinOperationName();
    }

    @Override
    protected boolean approximatelyHasRoots(VcsContext dataContext) {
        FilePath[] paths = dataContext.getSelectedFilePaths();
        if (paths.length == 0) {
            return false;
        }
        FileStatusManager fsm = FileStatusManager.getInstance((Project)dataContext.getProject());
        for (FilePath path : paths) {
            FileStatus status;
            VirtualFile file = path.getVirtualFile();
            if (file == null || !this.isApplicableRoot(file, status = fsm.getStatus(file), dataContext)) continue;
            return true;
        }
        return false;
    }

    protected boolean isApplicableRoot(VirtualFile file, FileStatus status, VcsContext dataContext) {
        return status != FileStatus.UNKNOWN && status != FileStatus.IGNORED;
    }

    @Override
    protected FilePath[] getRoots(VcsContext context) {
        return context.getSelectedFilePaths();
    }

    @Override
    protected boolean filterRootsBeforeAction() {
        return true;
    }
}

