/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.openapi.updateSettings.impl.AbstractUpdateDialog;
import com.intellij.openapi.updateSettings.impl.DetectedPluginsPanel;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.ui.TableUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

class PluginUpdateInfoDialog
extends AbstractUpdateDialog {
    private final List<PluginDownloader> myUploadedPlugins;

    protected PluginUpdateInfoDialog(@NotNull List<PluginDownloader> updatePlugins, boolean enableLink) {
        if (updatePlugins == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/updateSettings/impl/PluginUpdateInfoDialog", "<init>"));
        }
        super(enableLink);
        this.myUploadedPlugins = updatePlugins;
        this.init();
    }

    protected JComponent createCenterPanel() {
        return new PluginUpdateInfoPanel().myPanel;
    }

    @Override
    protected String getOkButtonText() {
        return IdeBundle.message((String)"update.plugins.update.action", (Object[])new Object[0]);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/PluginUpdateInfoDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doOKAction() {
        if (this.downloadPlugins() && PluginManagerConfigurable.showRestartIDEADialog() == 0) {
            this.restart();
        }
        super.doOKAction();
    }

    private boolean downloadPlugins() {
        UpdateChecker.saveDisabledToUpdatePlugins();
        return UpdateChecker.install(this.myUploadedPlugins);
    }

    private class PluginUpdateInfoPanel {
        private JPanel myPanel;
        private JLabel myPluginsToUpdateLabel;
        private JPanel myPluginsPanel;
        private JEditorPane myMessageArea;

        public PluginUpdateInfoPanel() {
            this.$$$setupUI$$$();
            this.myPluginsToUpdateLabel.setVisible(true);
            this.myPluginsPanel.setVisible(true);
            final DetectedPluginsPanel foundPluginsPanel = new DetectedPluginsPanel();
            foundPluginsPanel.addAll(PluginUpdateInfoDialog.this.myUploadedPlugins);
            TableUtil.ensureSelectionExists((JTable)foundPluginsPanel.getEntryTable());
            foundPluginsPanel.addStateListener(new DetectedPluginsPanel.Listener(){

                @Override
                public void stateChanged() {
                    boolean allSkipped = foundPluginsPanel.getSkippedPlugins().size() == PluginUpdateInfoDialog.this.myUploadedPlugins.size();
                    PluginUpdateInfoDialog.this.getOKAction().setEnabled(!allSkipped);
                }
            });
            this.myPluginsPanel.add((Component)((Object)foundPluginsPanel), "Center");
            PluginUpdateInfoDialog.this.configureMessageArea(this.myMessageArea);
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JEditorPane jEditorPane;
            JPanel jPanel;
            JLabel jLabel;
            JPanel jPanel2;
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            this.myPluginsToUpdateLabel = jLabel = new JLabel();
            jLabel.setPreferredSize(new Dimension(268, 30));
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.plugins.ready.header"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 2;
            jPanel2.add((Component)jLabel, gridBagConstraints);
            this.myPluginsPanel = jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel.setAutoscrolls(false);
            jPanel.setPreferredSize(new Dimension(600, 400));
            jPanel.setMinimumSize(new Dimension(600, 400));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(3, 0, 3, 0);
            jPanel2.add((Component)jPanel, gridBagConstraints2);
            this.myMessageArea = jEditorPane = new JEditorPane();
            jEditorPane.setContentType("text/html");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.fill = 1;
            jPanel2.add((Component)jEditorPane, gridBagConstraints3);
            JPanel jPanel3 = new JPanel();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 3;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.fill = 3;
            jPanel2.add((Component)jPanel3, gridBagConstraints4);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

