/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckForUpdateResult {
    private final BuildInfo myNewBuildInSelectedChannel;
    private final UpdateChannel myUpdatedChannel;
    private final List<String> myAllChannelIds;
    private final UpdateStrategy.State myState;
    private final Exception myError;
    private UpdateChannel myChannelToPropose;

    public CheckForUpdateResult(@Nullable UpdateChannel updated, @Nullable BuildInfo newBuildInSelectedChannel, @NotNull List<String> allChannelsIds) {
        if (allChannelsIds == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult", "<init>"));
        }
        this.myChannelToPropose = null;
        this.myNewBuildInSelectedChannel = newBuildInSelectedChannel;
        this.myUpdatedChannel = updated;
        this.myAllChannelIds = allChannelsIds;
        this.myState = UpdateStrategy.State.LOADED;
        this.myError = null;
    }

    public CheckForUpdateResult(@NotNull UpdateStrategy.State state, @Nullable Exception e) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult", "<init>"));
        }
        this.myChannelToPropose = null;
        this.myNewBuildInSelectedChannel = null;
        this.myUpdatedChannel = null;
        this.myAllChannelIds = Collections.emptyList();
        this.myState = state;
        this.myError = e;
    }

    public CheckForUpdateResult(@NotNull UpdateStrategy.State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult", "<init>"));
        }
        this(state, null);
    }

    @Nullable
    public BuildInfo getNewBuildInSelectedChannel() {
        return this.myNewBuildInSelectedChannel;
    }

    @Nullable
    public UpdateChannel getUpdatedChannel() {
        return this.myUpdatedChannel;
    }

    @NotNull
    public List<String> getAllChannelsIds() {
        List<String> list = this.myAllChannelIds;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult", "getAllChannelsIds"));
        }
        return list;
    }

    @NotNull
    public UpdateStrategy.State getState() {
        UpdateStrategy.State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult", "getState"));
        }
        return state;
    }

    @Nullable
    public Exception getError() {
        return this.myError;
    }

    @Nullable
    public UpdateChannel getChannelToPropose() {
        return this.myChannelToPropose;
    }

    public void setChannelToPropose(@Nullable UpdateChannel channelToPropose) {
        this.myChannelToPropose = channelToPropose;
    }
}

