/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.playback.PathMacro;
import com.intellij.openapi.ui.playback.PlaybackCommand;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.ui.playback.StageInfo;
import java.awt.EventQueue;
import java.awt.Robot;
import java.io.File;
import java.util.Set;
import javax.swing.SwingUtilities;

public abstract class PlaybackContext {
    private PlaybackRunner.StatusCallback myCallback;
    private int myCurrentLine;
    private Robot myRobot;
    private boolean myUseDirectActionCall;
    private PlaybackCommand myCurrentCmd;
    private File myBaseDir;
    private Set<Class> myCallClasses;
    private PlaybackRunner myRunner;
    private boolean myUseTypingTargets;

    public PlaybackContext(PlaybackRunner runner, PlaybackRunner.StatusCallback callback, int currentLine, Robot robot, boolean useDriectActionCall, boolean useTypingTargets, PlaybackCommand currentCmd, File baseDir, Set<Class> callClasses) {
        this.myRunner = runner;
        this.myCallback = callback;
        this.myCurrentLine = currentLine;
        this.myRobot = robot;
        this.myUseDirectActionCall = useDriectActionCall;
        this.myUseTypingTargets = useTypingTargets;
        this.myCurrentCmd = currentCmd;
        this.myBaseDir = baseDir;
        this.myCallClasses = callClasses;
    }

    public PlaybackRunner.StatusCallback getCallback() {
        return this.myCallback;
    }

    public int getCurrentLine() {
        return this.myCurrentLine;
    }

    public Robot getRobot() {
        return this.myRobot;
    }

    public boolean isUseDirectActionCall() {
        return this.myUseDirectActionCall;
    }

    public boolean isUseTypingTargets() {
        return this.myUseTypingTargets;
    }

    public PlaybackCommand getCurrentCmd() {
        return this.myCurrentCmd;
    }

    public File getBaseDir() {
        return this.myBaseDir != null ? this.myBaseDir : new File(System.getProperty("user.dir"));
    }

    public PathMacro getPathMacro() {
        return new PathMacro().setScriptDir(this.getCurrentCmd().getScriptDir()).setBaseDir(this.getBaseDir());
    }

    public void setBaseDir(File dir) {
        this.myBaseDir = dir;
    }

    public Set<Class> getCallClasses() {
        return this.myCallClasses;
    }

    public void flushAwtAndRunInEdt(final Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    PlaybackContext.this.getRobot().waitForIdle();
                    SwingUtilities.invokeLater(runnable);
                }
            });
        } else {
            this.getRobot().waitForIdle();
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void delayAndRunInEdt(final Runnable runnable, final long delay) {
        this.runPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.currentThread();
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(runnable);
            }
        });
    }

    public void runPooledThread(Runnable runnable) {
        ApplicationManager.getApplication().executeOnPooledThread(runnable);
    }

    public void error(String text, int currentLine) {
        this.getCallback().message(this, text, PlaybackRunner.StatusCallback.Type.error);
    }

    public void message(String text, int currentLine) {
        this.getCallback().message(this, text, PlaybackRunner.StatusCallback.Type.message);
    }

    public void test(String text, int currentLine) {
        this.getCallback().message(this, text, PlaybackRunner.StatusCallback.Type.test);
    }

    public void code(String text, int currentLine) {
        this.getCallback().message(this, text, PlaybackRunner.StatusCallback.Type.code);
    }

    public abstract void pushStage(StageInfo var1);

    public abstract StageInfo popStage();

    public abstract int getCurrentStageDepth();

    public abstract void addPassed(StageInfo var1);

    public abstract boolean isDisposed();

    public abstract void storeRegistryValue(String var1);
}

