/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.roots.ui.configuration.ConfigurationError;
import com.intellij.openapi.roots.ui.configuration.ConfigurationErrors;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectConfigurationProblem;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzerListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.util.MultiValuesMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectConfigurationProblems {
    private final MultiValuesMap<ProjectStructureElement, ConfigurationError> myErrors = new MultiValuesMap();
    private final ProjectStructureDaemonAnalyzer myAnalyzer;
    private final StructureConfigurableContext myContext;

    public ProjectConfigurationProblems(ProjectStructureDaemonAnalyzer analyzer, StructureConfigurableContext context) {
        this.myAnalyzer = analyzer;
        this.myContext = context;
        analyzer.addListener(new ProjectStructureDaemonAnalyzerListener(){

            @Override
            public void problemsChanged(@NotNull ProjectStructureElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectConfigurationProblems$1", "problemsChanged"));
                }
                ProjectConfigurationProblems.this.updateErrors(element);
            }
        });
    }

    public void clearProblems() {
        this.removeErrors(this.myErrors.values());
        this.myErrors.clear();
    }

    private void updateErrors(ProjectStructureElement element) {
        List<ProjectStructureProblemDescription> descriptions;
        this.removeErrors(this.myErrors.removeAll((Object)element));
        ProjectStructureProblemsHolderImpl problemsHolder = this.myAnalyzer.getProblemsHolder(element);
        if (problemsHolder != null && (descriptions = problemsHolder.getProblemDescriptions()) != null) {
            for (ProjectStructureProblemDescription description : descriptions) {
                ProjectConfigurationProblem error = new ProjectConfigurationProblem(description, this.myContext.getProject());
                this.myErrors.put((Object)element, (Object)error);
                ConfigurationErrors.Bus.addError(error, this.myContext.getProject());
            }
        }
    }

    private void removeErrors(@Nullable Collection<ConfigurationError> errors) {
        if (errors == null) {
            return;
        }
        for (ConfigurationError error : errors) {
            ConfigurationErrors.Bus.removeError(error, this.myContext.getProject());
        }
    }
}

