/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.packaging;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.impl.ui.LibraryElementPresentation;
import org.jetbrains.annotations.NotNull;

public class PackagingEditorUtil {
    private PackagingEditorUtil() {
    }

    public static String getLibraryItemText(@NotNull Library library, boolean includeTableName) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/packaging/PackagingEditorUtil", "getLibraryItemText"));
        }
        String name = library.getName();
        VirtualFile[] files = library.getFiles(OrderRootType.CLASSES);
        if (name != null) {
            return name + (includeTableName ? LibraryElementPresentation.getLibraryTableComment(library) : "");
        }
        if (files.length > 0) {
            return files[0].getName() + (includeTableName ? LibraryElementPresentation.getLibraryTableComment(library) : "");
        }
        return ProjectBundle.message((String)"library.empty.item", (Object[])new Object[0]);
    }
}

