/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.IconUtil;
import javax.swing.Icon;

public class JavadocOrderRootTypeUIFactory
implements OrderRootTypeUIFactory {
    public SdkPathEditor createPathEditor(Sdk sdk) {
        return new JavadocPathsEditor(sdk);
    }

    public Icon getIcon() {
        return AllIcons.Nodes.JavaDocFolder;
    }

    public String getNodeText() {
        return ProjectBundle.message((String)"library.javadocs.node", (Object[])new Object[0]);
    }

    static class JavadocPathsEditor
    extends SdkPathEditor {
        private final Sdk mySdk;

        public JavadocPathsEditor(Sdk sdk) {
            super(ProjectBundle.message((String)"sdk.configure.javadoc.tab", (Object[])new Object[0]), JavadocOrderRootType.getInstance(), FileChooserDescriptorFactory.createMultipleJavaPathDescriptor());
            this.mySdk = sdk;
        }

        protected void addToolbarButtons(ToolbarDecorator toolbarDecorator) {
            AnActionButton specifyUrlButton = new AnActionButton(ProjectBundle.message((String)"sdk.paths.specify.url.button", (Object[])new Object[0]), IconUtil.getAddLinkIcon()){

                public void actionPerformed(AnActionEvent e) {
                    JavadocPathsEditor.this.onSpecifyUrlButtonClicked();
                }
            };
            specifyUrlButton.setShortcut((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"alt S"}));
            specifyUrlButton.addCustomUpdater(new AnActionButtonUpdater(){

                public boolean isEnabled(AnActionEvent e) {
                    return JavadocPathsEditor.this.myEnabled;
                }
            });
            toolbarDecorator.addExtraAction(specifyUrlButton);
        }

        private void onSpecifyUrlButtonClicked() {
            String defaultDocsUrl = this.mySdk == null ? "" : StringUtil.notNullize((String)((SdkType)this.mySdk.getSdkType()).getDefaultDocumentationUrl(this.mySdk), (String)"");
            VirtualFile virtualFile = Util.showSpecifyJavadocUrlDialog(this.myPanel, defaultDocsUrl);
            if (virtualFile != null) {
                this.addElement(virtualFile);
                this.setModified(true);
                this.requestDefaultFocus();
                this.setSelectedRoots(new Object[]{virtualFile});
            }
        }
    }
}

